/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.io.Files;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Java classes shouldn't use default package", severity=BugPattern.SeverityLevel.WARNING)
public final class DefaultPackage
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (tree.getTypeDecls().stream().anyMatch(s2 -> this.isSuppressed((Tree)s2, state))) {
            return Description.NO_MATCH;
        }
        if (tree.getTypeDecls().stream().map(ASTHelpers::getSymbol).filter(x -> x != null).anyMatch(s2 -> !ASTHelpers.getGeneratedBy(s2, state).isEmpty())) {
            return Description.NO_MATCH;
        }
        if (tree.getPackageName() != null) {
            return Description.NO_MATCH;
        }
        if (Files.getNameWithoutExtension(ASTHelpers.getFileName(tree)).equals("module-info")) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

