/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;

@BugPattern(altNames={"ThrowableInstanceNeverThrown"}, summary="Exception created but not thrown", severity=BugPattern.SeverityLevel.ERROR)
public class DeadException
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    public static final Matcher<Tree> MATCHER = Matchers.allOf(Matchers.parentNode(Matchers.kindIs(Tree.Kind.EXPRESSION_STATEMENT)), Matchers.isSubtypeOf(Suppliers.THROWABLE_TYPE), Matchers.not(Matchers.anyOf(Matchers.enclosingClass(JUnitMatchers.isJUnit3TestClass), Matchers.enclosingClass(JUnitMatchers.isAmbiguousJUnitVersion), Matchers.enclosingClass(JUnitMatchers.isJUnit4TestClass))));

    @Override
    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        if (!MATCHER.matches(newClassTree, state)) {
            return Description.NO_MATCH;
        }
        StatementTree parent = (StatementTree)state.getPath().getParentPath().getLeaf();
        boolean isLastStatement = Matchers.anyOf(new ChildOfBlockOrCase(ChildMultiMatcher.MatchType.LAST, Matchers.isSame(parent)), Matchers.parentNode(Matchers.parentNode(Matchers.kindIs(Tree.Kind.IF)))).matches(newClassTree, state);
        SuggestedFix fix = isLastStatement ? SuggestedFix.prefixWith(newClassTree, "throw ") : SuggestedFix.delete(parent);
        return this.describeMatch(newClassTree, (Fix)fix);
    }

    private static class ChildOfBlockOrCase<T extends Tree>
    extends ChildMultiMatcher<T, StatementTree> {
        public ChildOfBlockOrCase(ChildMultiMatcher.MatchType matchType, Matcher<StatementTree> nodeMatcher) {
            super(matchType, nodeMatcher);
        }

        @Override
        protected Iterable<? extends StatementTree> getChildNodes(T tree, VisitorState state) {
            Object enclosing = state.findEnclosing(CaseTree.class, BlockTree.class);
            if (enclosing == null) {
                return ImmutableList.of();
            }
            if (enclosing instanceof BlockTree) {
                return ((BlockTree)enclosing).getStatements();
            }
            if (enclosing instanceof CaseTree) {
                return ((CaseTree)enclosing).getStatements();
            }
            throw new IllegalStateException("enclosing tree not a BlockTree or CaseTree");
        }
    }
}

