/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_DangerousLiteralNullChecker_NullReplacementRule;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;

@BugPattern(name="DangerousLiteralNull", summary="This method is null-hostile: passing a null literal to it is always wrong", severity=BugPattern.SeverityLevel.ERROR)
public class DangerousLiteralNullChecker
extends BugChecker
implements BugChecker.LiteralTreeMatcher {
    private static final Supplier<ImmutableList<NullReplacementRule>> RULES = VisitorState.memoize(state -> ImmutableList.of(NullReplacementRule.builder().setKlass(state.getName("java.util.Optional")).setMethod(state.getName("orElseGet")).setReplacementBody("orElse(null)").build(), NullReplacementRule.builder().setKlass(state.getName("java.util.Optional")).setMethod(state.getName("orElseThrow")).setReplacementBody("orElseThrow(NullPointerException::new)").build()));
    private static final Supplier<ImmutableTable<Name, Name, String>> RULE_LOOKUP = VisitorState.memoize(state -> {
        ImmutableTable.Builder<Name, Name, String> builder = ImmutableTable.builder();
        for (NullReplacementRule rule : RULES.get(state)) {
            builder.put(rule.klass(), rule.method(), rule.replacementBody());
        }
        return builder.buildOrThrow();
    });

    @Override
    public Description matchLiteral(LiteralTree tree, VisitorState state) {
        if (!Matchers.nullLiteral().matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (!(parent instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree invocation = (MethodInvocationTree)parent;
        if (invocation.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(invocation);
        String newBody = (String)RULE_LOOKUP.get(state).get(sym.owner.getQualifiedName(), sym.name);
        if (newBody == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(invocation, (Fix)SuggestedFix.replace(invocation, String.format("%s.%s", state.getSourceForNode(ASTHelpers.getReceiver(invocation)), newBody)));
    }

    @AutoValue
    static abstract class NullReplacementRule {
        NullReplacementRule() {
        }

        abstract Name klass();

        abstract Name method();

        abstract String replacementBody();

        private static Builder builder() {
            return new AutoValue_DangerousLiteralNullChecker_NullReplacementRule.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setKlass(Name var1);

            abstract Builder setMethod(Name var1);

            abstract Builder setReplacementBody(String var1);

            abstract NullReplacementRule build();
        }
    }
}

