/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;

@BugPattern(summary="This method cannot throw a checked exception that it claims to. This may cause consumers of the API to incorrectly attempt to handle, or propagate, this exception.", severity=BugPattern.SeverityLevel.WARNING)
public final class CheckedExceptionNotThrown
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (tree.getThrows().isEmpty()) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (ASTHelpers.methodCanBeOverridden(symbol) || state.errorProneOptions().isTestOnlyTarget() || tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet thrownExceptions = CheckedExceptionNotThrown.treesToScanForCheckedExceptions(tree, state).flatMap(t2 -> ASTHelpers.getThrownExceptions(t2, state).stream()).filter(t2 -> ASTHelpers.isCheckedExceptionType(t2, state)).collect(ImmutableSet.toImmutableSet());
        ImmutableList canActuallyBeThrown = tree.getThrows().stream().filter(et -> {
            Type type = ASTHelpers.getType(et);
            return !ASTHelpers.isCheckedExceptionType(type, state) || thrownExceptions.stream().anyMatch(t2 -> ASTHelpers.isSubtype(t2, type, state));
        }).collect(ImmutableList.toImmutableList());
        if (tree.getThrows().equals(canActuallyBeThrown)) {
            return Description.NO_MATCH;
        }
        ImmutableSet<Type> thrownTypes = canActuallyBeThrown.stream().map(ASTHelpers::getType).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        String unthrown = tree.getThrows().stream().filter(et -> !canActuallyBeThrown.contains(et)).map(state::getSourceForNode).sorted().collect(Collectors.joining(", ", "(", ")"));
        String description = String.format("This method does not throw checked exceptions %s despite claiming to. This may cause consumers of the API to incorrectly attempt to handle, or propagate, this exception.", unthrown);
        SuggestedFix throwsFix = canActuallyBeThrown.isEmpty() ? CheckedExceptionNotThrown.deleteEntireThrowsClause(tree, state) : SuggestedFix.replace(ASTHelpers.getStartPosition(tree.getThrows().get(0)), state.getEndPosition(Iterables.getLast(tree.getThrows())), canActuallyBeThrown.stream().map(state::getSourceForNode).collect(Collectors.joining(", ")));
        SuggestedFix fix = SuggestedFix.builder().merge(this.fixJavadoc(thrownTypes, state)).merge(throwsFix).build();
        return this.buildDescription(tree.getThrows().get(0)).setMessage(description).addFix(fix).build();
    }

    private static Stream<Tree> treesToScanForCheckedExceptions(MethodTree tree, VisitorState state) {
        if (ASTHelpers.getSymbol(tree).isStatic()) {
            return Stream.of(tree.getBody());
        }
        return Streams.concat(Stream.of(tree.getBody()), CheckedExceptionNotThrown.fieldInitializers((ClassTree)state.findEnclosing(ClassTree.class)));
    }

    private static Stream<ExpressionTree> fieldInitializers(ClassTree tree) {
        return tree.getMembers().stream().filter(VariableTree.class::isInstance).map(VariableTree.class::cast).filter(v -> !ASTHelpers.getSymbol(v).isStatic()).map(VariableTree::getInitializer).filter(i -> i != null);
    }

    private SuggestedFix fixJavadoc(final ImmutableSet<Type> actuallyThrownTypes, final VisitorState state) {
        final DocCommentTree docCommentTree = JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
        if (docCommentTree == null) {
            return SuggestedFix.emptyFix();
        }
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        DocTreePath docTreePath = new DocTreePath(state.getPath(), docCommentTree);
        new DocTreePathScanner<Void, Void>(){

            @Override
            public Void visitThrows(ThrowsTree throwsTree, Void unused) {
                Type type;
                ReferenceTree exName = throwsTree.getExceptionName();
                Element element = JavacTrees.instance(state.context).getElement(new DocTreePath(this.getCurrentPath(), exName));
                if (element != null && !actuallyThrownTypes.contains(type = (Type)element.asType())) {
                    DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
                    CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
                    fix.replace((int)positions.getStartPosition(compilationUnitTree, docCommentTree, throwsTree), (int)positions.getEndPosition(compilationUnitTree, docCommentTree, throwsTree), "");
                }
                return (Void)super.visitThrows(throwsTree, null);
            }
        }.scan(docTreePath, (Void)null);
        return fix.build();
    }

    private static SuggestedFix deleteEntireThrowsClause(MethodTree tree, VisitorState state) {
        int endPos = state.getEndPosition(Iterables.getLast(tree.getThrows()));
        int methodStartPos = ASTHelpers.getStartPosition(tree);
        int startPos = ErrorProneTokens.getTokens(state.getSourceCode().subSequence(methodStartPos, endPos).toString(), methodStartPos, state.context).stream().filter(token -> token.kind().equals(Tokens.TokenKind.THROWS)).findFirst().map(ErrorProneToken::pos).get();
        return SuggestedFix.replace(startPos, endPos, "");
    }
}

