/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Converter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

@BugPattern(summary="Duration can be expressed more clearly with different units", severity=BugPattern.SeverityLevel.WARNING)
public class CanonicalDuration
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> JAVA_TIME_MATCHER = MethodMatchers.staticMethod().onClass(Api.JAVA.getDurationFullyQualifiedName());
    private static final Matcher<ExpressionTree> JODA_MATCHER = MethodMatchers.staticMethod().onClass(Api.JODA.getDurationFullyQualifiedName());
    private static final ImmutableTable<Api, ChronoUnit, String> FACTORIES = ImmutableTable.builder().put(Api.JAVA, ChronoUnit.DAYS, "ofDays").put(Api.JAVA, ChronoUnit.HOURS, "ofHours").put(Api.JAVA, ChronoUnit.MINUTES, "ofMinutes").put(Api.JAVA, ChronoUnit.SECONDS, "ofSeconds").put(Api.JAVA, ChronoUnit.MILLIS, "ofMillis").put(Api.JAVA, ChronoUnit.NANOS, "ofNanos").put(Api.JODA, ChronoUnit.DAYS, "standardDays").put(Api.JODA, ChronoUnit.HOURS, "standardHours").put(Api.JODA, ChronoUnit.MINUTES, "standardMinutes").put(Api.JODA, ChronoUnit.SECONDS, "standardSeconds").buildOrThrow();
    private static final ImmutableMap<String, TemporalUnit> METHOD_NAME_TO_UNIT = ((ImmutableMap)FACTORIES.rowMap()).values().stream().flatMap(x -> x.entrySet().stream()).collect(ImmutableMap.toImmutableMap(x -> (String)x.getValue(), x -> (TemporalUnit)x.getKey()));
    private static final ImmutableMap<ChronoUnit, Converter<Duration, Long>> CONVERTERS = ImmutableMap.builder().put(ChronoUnit.DAYS, Converter.from(Duration::toDays, Duration::ofDays)).put(ChronoUnit.HOURS, Converter.from(Duration::toHours, Duration::ofHours)).put(ChronoUnit.MINUTES, Converter.from(Duration::toMinutes, Duration::ofMinutes)).put(ChronoUnit.SECONDS, Converter.from(Duration::getSeconds, Duration::ofSeconds)).put(ChronoUnit.MILLIS, Converter.from(Duration::toMillis, Duration::ofMillis)).put(ChronoUnit.NANOS, Converter.from(Duration::toNanos, Duration::ofNanos)).buildOrThrow();
    private static final ImmutableMap<TemporalUnit, Long> BANLIST = ImmutableMap.of(ChronoUnit.HOURS, 24L, ChronoUnit.MINUTES, 60L, ChronoUnit.SECONDS, 60L);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Map.Entry entry;
        ChronoUnit nextUnit;
        Api api;
        if (JAVA_TIME_MATCHER.matches(tree, state)) {
            api = Api.JAVA;
        } else if (JODA_MATCHER.matches(tree, state)) {
            api = Api.JODA;
        } else {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() != 1) {
            return Description.NO_MATCH;
        }
        List<MethodInvocationTree> allInvocationsInParentExpression = CanonicalDuration.getAllInvocationsInParentExpression(state);
        if (allInvocationsInParentExpression.isEmpty()) {
            return Description.NO_MATCH;
        }
        List constValues = allInvocationsInParentExpression.stream().map(t2 -> Iterables.getOnlyElement(t2.getArguments())).map(arg -> CanonicalDuration.entirelyLiterals(arg) ? arg : null).map(arg -> ASTHelpers.constValue(arg, Number.class)).collect(Collectors.toList());
        if (constValues.stream().anyMatch(Objects::isNull)) {
            return Description.NO_MATCH;
        }
        if (constValues.stream().mapToLong(Number::longValue).allMatch(v -> v == 0L)) {
            return this.handleAllZeros(state, api, allInvocationsInParentExpression);
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (!METHOD_NAME_TO_UNIT.containsKey(((Name)sym.getSimpleName()).toString())) {
            return Description.NO_MATCH;
        }
        TemporalUnit unit = METHOD_NAME_TO_UNIT.get(((Name)sym.getSimpleName()).toString());
        Long banListValue = BANLIST.get(unit);
        if (banListValue != null && constValues.stream().anyMatch(value -> Objects.equals(banListValue, value.longValue()))) {
            return Description.NO_MATCH;
        }
        List durations = constValues.stream().map(value -> Duration.of(value.longValue(), unit)).collect(Collectors.toList());
        Iterator iterator = ((ImmutableSet)CONVERTERS.entrySet()).iterator();
        while (iterator.hasNext() && !unit.equals(nextUnit = (ChronoUnit)(entry = (Map.Entry)iterator.next()).getKey())) {
            Converter converter = (Converter)entry.getValue();
            List roundTripped = durations.stream().map(converter::convert).map(converter.reverse()::convert).collect(Collectors.toList());
            if (!roundTripped.equals(durations)) continue;
            for (int i = 0; i < allInvocationsInParentExpression.size(); ++i) {
                MethodInvocationTree m4 = allInvocationsInParentExpression.get(i);
                long nextValue = (Long)converter.convert((Duration)durations.get(i));
                String name = (String)FACTORIES.get((Object)api, nextUnit);
                String replacement = String.format("%s(%d%s)", name, nextValue, nextValue == (long)((int)nextValue) ? "" : "L");
                ExpressionTree receiver = ASTHelpers.getReceiver(m4);
                if (receiver == null) {
                    SuggestedFix fix = SuggestedFix.builder().addStaticImport(api.getDurationFullyQualifiedName() + "." + name).replace(m4, replacement).build();
                    state.reportMatch(this.describeMatch(m4, (Fix)fix));
                    continue;
                }
                state.reportMatch(this.describeMatch(m4, (Fix)SuggestedFix.replace(state.getEndPosition(receiver), state.getEndPosition(m4), "." + replacement)));
            }
            return Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    private static boolean entirelyLiterals(ExpressionTree arg) {
        final AtomicBoolean anyNonLiterals = new AtomicBoolean();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                if (!(tree instanceof LiteralTree) && !(tree instanceof BinaryTree)) {
                    anyNonLiterals.set(true);
                }
                return (Void)super.scan(tree, null);
            }
        }.scan((Tree)arg, null);
        return !anyNonLiterals.get();
    }

    private Description handleAllZeros(VisitorState state, Api api, List<MethodInvocationTree> allInvocationsInParentExpression) {
        switch (api) {
            case JODA: {
                for (MethodInvocationTree tree : allInvocationsInParentExpression) {
                    ExpressionTree receiver = ASTHelpers.getReceiver(tree);
                    SuggestedFix fix = receiver == null ? SuggestedFix.builder().addImport(api.getDurationFullyQualifiedName()).replace(tree, "Duration.ZERO").build() : SuggestedFix.replace(state.getEndPosition(ASTHelpers.getReceiver(tree)), state.getEndPosition(tree), ".ZERO");
                    state.reportMatch(this.buildDescription(tree).setMessage("Duration can be expressed more clearly without units, as Duration.ZERO").addFix(fix).build());
                }
                return Description.NO_MATCH;
            }
            case JAVA: {
                return Description.NO_MATCH;
            }
        }
        throw new AssertionError((Object)api);
    }

    private static List<MethodInvocationTree> getAllInvocationsInParentExpression(VisitorState state) {
        TreePath parentPath;
        TreePath expressionPath = state.getPath();
        while ((parentPath = expressionPath.getParentPath()) != null && expressionPath.getParentPath().getLeaf() instanceof ExpressionTree) {
            expressionPath = parentPath;
        }
        final AtomicBoolean notFirst = new AtomicBoolean();
        final MethodInvocationTree tree = (MethodInvocationTree)state.getPath().getLeaf();
        final Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
        final ArrayList<MethodInvocationTree> sameMethodInvocations = new ArrayList<MethodInvocationTree>();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree node, Void unused) {
                if (notFirst.get()) {
                    return null;
                }
                return (Void)super.scan(node, unused);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                if (Objects.equals(methodSymbol, ASTHelpers.getSymbol(node))) {
                    if (sameMethodInvocations.isEmpty() && !Objects.equals(node, tree)) {
                        notFirst.set(true);
                        return null;
                    }
                    sameMethodInvocations.add(node);
                    return (Void)super.visitMethodInvocation(node, unused);
                }
                return (Void)super.visitMethodInvocation(node, unused);
            }
        }.scan(expressionPath.getLeaf(), null);
        if (notFirst.get()) {
            sameMethodInvocations.clear();
        }
        return sameMethodInvocations;
    }

    static enum Api {
        JAVA("java.time.Duration"),
        JODA("org.joda.time.Duration");

        private final String durationFullyQualifiedName;

        private Api(String durationFullyQualifiedName) {
            this.durationFullyQualifiedName = durationFullyQualifiedName;
        }

        String getDurationFullyQualifiedName() {
            return this.durationFullyQualifiedName;
        }
    }
}

