/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="Mockito cannot mock final or static methods, and can't detect this at runtime", altNames={"MockitoBadFinalMethod", "CannotMockFinalMethod"}, severity=BugPattern.SeverityLevel.WARNING)
public final class CannotMockMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> WHEN = Matchers.staticMethod().onClass("org.mockito.Mockito").named("when");
    private static final Matcher<ExpressionTree> VERIFY = Matchers.staticMethod().onClass("org.mockito.Mockito").named("verify");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (WHEN.matches(tree, state)) {
            ExpressionTree firstArgument = tree.getArguments().get(0);
            if (!(firstArgument instanceof MethodInvocationTree)) {
                return Description.NO_MATCH;
            }
            return this.describe(tree, ASTHelpers.getSymbol((MethodInvocationTree)firstArgument));
        }
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (receiver != null && VERIFY.matches(receiver, state)) {
            return this.describe(tree, ASTHelpers.getSymbol(tree));
        }
        return Description.NO_MATCH;
    }

    private Description describe(MethodInvocationTree tree, Symbol.MethodSymbol methodSymbol) {
        if (methodSymbol.isStatic()) {
            return this.buildDescription(tree, "static");
        }
        if ((methodSymbol.flags() & 0x10L) == 16L) {
            return this.buildDescription(tree, "final");
        }
        return Description.NO_MATCH;
    }

    private Description buildDescription(MethodInvocationTree tree, String issue) {
        return this.buildDescription(tree).setMessage(String.format("Mockito cannot mock %s methods, and can't detect this at runtime", issue)).build();
    }
}

