/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

@BugPattern(summary="Giving BugPatterns a name different to the enclosing class can be confusing", severity=BugPattern.SeverityLevel.WARNING)
public final class BugPatternNaming
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!ASTHelpers.isSubtype(ASTHelpers.getType(tree), state.getTypeFromString(BugChecker.class.getName()), state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol(tree);
        Attribute.Compound attribute = classSymbol.attribute(state.getSymbolFromString(BugPattern.class.getName()));
        if (attribute == null) {
            return Description.NO_MATCH;
        }
        return MoreAnnotations.getValue(attribute, "name").flatMap(MoreAnnotations::asStringValue).filter(name -> !name.isEmpty()).flatMap(name -> {
            if (!classSymbol.name.contentEquals((CharSequence)name)) {
                return Optional.of(this.describeMatch(tree));
            }
            return this.removeName(tree, state);
        }).orElse(Description.NO_MATCH);
    }

    private Optional<Description> removeName(ClassTree tree, VisitorState state) {
        return tree.getModifiers().getAnnotations().stream().filter(anno -> ASTHelpers.isSameType(ASTHelpers.getType(anno.getAnnotationType()), state.getTypeFromString(BugPattern.class.getName()), state)).findFirst().flatMap(anno -> anno.getArguments().stream().filter(t2 -> t2 instanceof AssignmentTree && ((IdentifierTree)((AssignmentTree)t2).getVariable()).getName().contentEquals("name")).findFirst().map(ele -> this.buildDescription((Tree)anno).setMessage("Setting @BugPattern.name to the class name of the check is redundant").addFix(SuggestedFixes.removeElement(ele, anno.getArguments(), state)).build()));
    }
}

