/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import javax.annotation.Nullable;

@BugPattern(summary="valueOf or autoboxing provides better time and space performance", severity=BugPattern.SeverityLevel.WARNING, tags={"Performance"})
public class BoxedPrimitiveConstructor
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<Tree> TO_STRING = Matchers.toType(ExpressionTree.class, MethodMatchers.instanceMethod().anyClass().named("toString").withNoParameters());
    private static final Matcher<Tree> HASH_CODE = Matchers.toType(ExpressionTree.class, MethodMatchers.instanceMethod().anyClass().named("hashCode").withNoParameters());
    private static final Matcher<Tree> COMPARE_TO = Matchers.toType(ExpressionTree.class, MethodMatchers.instanceMethod().onDescendantOf("java.lang.Comparable").named("compareTo"));

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree.getIdentifier());
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        Symtab symtab = state.getSymtab();
        if (sym.equals(types.boxedClass(symtab.byteType)) || sym.equals(types.boxedClass(symtab.charType)) || sym.equals(types.boxedClass(symtab.shortType)) || sym.equals(types.boxedClass(symtab.intType)) || sym.equals(types.boxedClass(symtab.longType)) || sym.equals(types.boxedClass(symtab.doubleType)) || sym.equals(types.boxedClass(symtab.floatType)) || sym.equals(types.boxedClass(symtab.booleanType))) {
            return this.describeMatch(tree, BoxedPrimitiveConstructor.buildFix(tree, state));
        }
        return Description.NO_MATCH;
    }

    private static Fix buildFix(NewClassTree tree, VisitorState state) {
        String prefixToArg;
        Type type;
        boolean autoboxFix = BoxedPrimitiveConstructor.shouldAutoboxFix(state);
        Types types = state.getTypes();
        if (types.isSameType(type = types.unboxedTypeOrType(ASTHelpers.getType(tree)), state.getSymtab().booleanType)) {
            Object value = BoxedPrimitiveConstructor.literalValue(tree.getArguments().iterator().next());
            if (value instanceof Boolean) {
                return SuggestedFix.replace(tree, BoxedPrimitiveConstructor.literalFix((Boolean)value, autoboxFix));
            }
            if (value instanceof String) {
                return SuggestedFix.replace(tree, BoxedPrimitiveConstructor.literalFix(Boolean.parseBoolean((String)value), autoboxFix));
            }
        }
        JCTree.JCExpression arg = (JCTree.JCExpression)Iterables.getOnlyElement(tree.getArguments());
        Type argType = ASTHelpers.getType(arg);
        if (autoboxFix && argType.isPrimitive()) {
            return SuggestedFix.builder().replace(ASTHelpers.getStartPosition(tree), arg.getStartPosition(), BoxedPrimitiveConstructor.maybeCast(state, type, argType)).replace(state.getEndPosition(arg), state.getEndPosition(tree), "").build();
        }
        JCTree parent = (JCTree)state.getPath().getParentPath().getParentPath().getLeaf();
        if (TO_STRING.matches(parent, state)) {
            return SuggestedFix.builder().replace(parent.getStartPosition(), arg.getStartPosition(), "String.valueOf(").replace(state.getEndPosition(arg), state.getEndPosition(parent), ")").build();
        }
        String typeName = state.getSourceForNode(tree.getIdentifier());
        DoubleAndFloatStatus doubleAndFloatStatus = BoxedPrimitiveConstructor.doubleAndFloatStatus(state, type, argType);
        if (HASH_CODE.matches(parent, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String optionalCast = "";
            String optionalSuffix = "";
            switch (doubleAndFloatStatus) {
                case PRIMITIVE_DOUBLE_INTO_FLOAT: {
                    optionalCast = "(float) ";
                    break;
                }
                case BOXED_DOUBLE_INTO_FLOAT: {
                    optionalSuffix = ".floatValue()";
                    break;
                }
            }
            String replacement = String.format("%s.hashCode(", typeName);
            return fix.replace(parent.getStartPosition(), arg.getStartPosition(), replacement + optionalCast).replace(state.getEndPosition(arg), state.getEndPosition(parent), optionalSuffix + ")").build();
        }
        if (COMPARE_TO.matches(parent, state) && ASTHelpers.getReceiver((ExpressionTree)((Object)parent)).equals(tree)) {
            JCTree.JCMethodInvocation compareTo = (JCTree.JCMethodInvocation)parent;
            JCTree.JCExpression rhs = (JCTree.JCExpression)Iterables.getOnlyElement(compareTo.getArguments());
            String optionalCast = "";
            String optionalSuffix = "";
            switch (doubleAndFloatStatus) {
                case PRIMITIVE_DOUBLE_INTO_FLOAT: {
                    optionalCast = "(float) ";
                    break;
                }
                case BOXED_DOUBLE_INTO_FLOAT: {
                    optionalSuffix = ".floatValue()";
                    break;
                }
            }
            return SuggestedFix.builder().replace(compareTo.getStartPosition(), arg.getStartPosition(), String.format("%s.compare(%s", typeName, optionalCast)).replace(state.getEndPosition(arg), rhs.getStartPosition(), String.format("%s, ", optionalSuffix)).replace(state.getEndPosition(rhs), state.getEndPosition(compareTo), ")").build();
        }
        String suffix = "";
        switch (doubleAndFloatStatus) {
            case PRIMITIVE_DOUBLE_INTO_FLOAT: {
                prefixToArg = String.format("%s.valueOf(%s", typeName, "(float) ");
                break;
            }
            case BOXED_DOUBLE_INTO_FLOAT: {
                prefixToArg = "";
                suffix = ".floatValue(";
                break;
            }
            default: {
                prefixToArg = String.format("%s.valueOf(", typeName);
            }
        }
        return SuggestedFix.builder().replace(ASTHelpers.getStartPosition(tree), arg.getStartPosition(), prefixToArg).postfixWith(arg, suffix).build();
    }

    private static String maybeCast(VisitorState state, Type type, Type argType) {
        if (BoxedPrimitiveConstructor.doubleAndFloatStatus(state, type, argType) == DoubleAndFloatStatus.PRIMITIVE_DOUBLE_INTO_FLOAT) {
            return "(float) ";
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType(state);
        if (targetType != null && !ASTHelpers.isSameType(type, argType, state) && !ASTHelpers.isSameType(targetType.type(), type, state)) {
            return String.format("(%s) ", type);
        }
        return "";
    }

    private static DoubleAndFloatStatus doubleAndFloatStatus(VisitorState state, Type receiverType, Type argType) {
        Types types = state.getTypes();
        if (!types.isSameType(receiverType, state.getSymtab().floatType)) {
            return DoubleAndFloatStatus.NONE;
        }
        if (types.isSameType(argType, types.boxedClass((Type)state.getSymtab().doubleType).type)) {
            return DoubleAndFloatStatus.BOXED_DOUBLE_INTO_FLOAT;
        }
        if (types.isSameType(argType, state.getSymtab().doubleType)) {
            return DoubleAndFloatStatus.PRIMITIVE_DOUBLE_INTO_FLOAT;
        }
        return DoubleAndFloatStatus.NONE;
    }

    private static boolean shouldAutoboxFix(VisitorState state) {
        switch (state.getPath().getParentPath().getLeaf().getKind()) {
            case METHOD_INVOCATION: {
                return false;
            }
            case MEMBER_SELECT: {
                return false;
            }
            case TYPE_CAST: {
                return false;
            }
        }
        return true;
    }

    private static String literalFix(boolean value, boolean autoboxFix) {
        if (autoboxFix) {
            return value ? "true" : "false";
        }
        return value ? "Boolean.TRUE" : "Boolean.FALSE";
    }

    @Nullable
    private static Object literalValue(Tree arg) {
        if (!(arg instanceof LiteralTree)) {
            return null;
        }
        return ((LiteralTree)arg).getValue();
    }

    private static enum DoubleAndFloatStatus {
        NONE,
        PRIMITIVE_DOUBLE_INTO_FLOAT,
        BOXED_DOUBLE_INTO_FLOAT;

    }
}

