/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(summary="BigDecimal#equals has surprising behavior: it also compares scale.", severity=BugPattern.SeverityLevel.WARNING)
public final class BigDecimalEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String BIG_DECIMAL = "java.math.BigDecimal";
    private static final Supplier<Type> JAVA_MATH_BIGDECIMAL = VisitorState.memoize(state -> state.getTypeFromString(BIG_DECIMAL));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Tree argument;
        Tree receiver;
        boolean handleNulls;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        Type bigDecimal = JAVA_MATH_BIGDECIMAL.get(state);
        if (Matchers.staticEqualsInvocation().matches(tree, state)) {
            handleNulls = true;
            receiver = arguments.get(arguments.size() - 2);
            argument = Iterables.getLast(arguments);
        } else if (Matchers.instanceEqualsInvocation().matches(tree, state)) {
            handleNulls = false;
            receiver = ASTHelpers.getReceiver(tree);
            argument = arguments.get(0);
        } else {
            return Description.NO_MATCH;
        }
        MethodTree enclosingMethod = (MethodTree)state.findEnclosing(MethodTree.class);
        if (enclosingMethod != null && Matchers.equalsMethodDeclaration().matches(enclosingMethod, state)) {
            return Description.NO_MATCH;
        }
        boolean isReceiverBigDecimal = ASTHelpers.isSameType(ASTHelpers.getType(receiver), bigDecimal, state);
        boolean isTargetBigDecimal = ASTHelpers.isSameType(ASTHelpers.getType(argument), bigDecimal, state);
        if (!isReceiverBigDecimal && !isTargetBigDecimal) {
            return Description.NO_MATCH;
        }
        if (isReceiverBigDecimal != isTargetBigDecimal) {
            return this.describeMatch(tree);
        }
        return this.describe(tree, state, receiver, argument, handleNulls);
    }

    private Description describe(MethodInvocationTree tree, VisitorState state, Tree receiver, Tree argument, boolean handleNulls) {
        return this.describeMatch(tree);
    }
}

