/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.SerializableReads;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Deserializing user input via the `Serializable` API is extremely dangerous", severity=BugPattern.SeverityLevel.ERROR)
public final class BanSerializableRead
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> EXEMPT = Matchers.anyOf(Matchers.allOf(Matchers.enclosingClass(Matchers.isSubtypeOf("java.io.Serializable")), Matchers.enclosingMethod(Matchers.methodIsNamed("readObject"))), Matchers.allOf(Matchers.enclosingClass(Matchers.isSubtypeOf("java.io.ObjectInputStream")), Matchers.enclosingMethod((methodTree, state) -> SerializableReads.BANNED_OBJECT_INPUT_STREAM_METHODS.contains(methodTree.getName().toString()))));
    private static final Matcher<ExpressionTree> OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER = Matchers.allOf(Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.io.ObjectInputStream").namedAnyOf(SerializableReads.BANNED_OBJECT_INPUT_STREAM_METHODS), Matchers.instanceMethod().onDescendantOf("java.io.Serializable").named("readObject")), Matchers.not(EXEMPT));
    private static final Matcher<ExpressionTree> MATCHER = OBJECT_INPUT_STREAM_DESERIALIZE_MATCHER;

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget() || !MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        return description.build();
    }
}

