/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Using JNDI may deserialize user input via the `Serializable` API which is extremely dangerous", severity=BugPattern.SeverityLevel.ERROR)
public final class BanJNDI
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.anyOf(Matchers.anyMethod().onDescendantOf("javax.naming.directory.DirContext").namedAnyOf("modifyAttributes", "getAttributes", "search", "getSchema", "getSchemaClassDefinition"), Matchers.anyMethod().onDescendantOf("javax.naming.Context").namedAnyOf("lookup", "bind", "rebind", "createSubcontext"), Matchers.anyMethod().onDescendantOf("javax.jdo.JDOHelperTest").namedAnyOf("testGetPMFBadJNDI", "testGetPMFBadJNDIGoodClassLoader", "testGetPMFNullJNDI", "testGetPMFNullJNDIGoodClassLoader"), Matchers.anyMethod().onDescendantOf("javax.jdo.JDOHelper").named("getPersistenceManagerFactory"), Matchers.anyMethod().onDescendantOf("javax.management.remote.JMXConnectorFactory").named("connect"), Matchers.anyMethod().onDescendantOf("javax.sql.rowset.spi.SyncFactory").named("getInstance"), Matchers.anyMethod().onDescendantOf("javax.management.remote.rmi.RMIConnector.RMIClientCommunicatorAdmin").named("doStart"), Matchers.anyMethod().onDescendantOf("javax.management.remote.rmi.RMIConnector").named("connect"), Matchers.anyMethod().onDescendantOf("javax.naming.InitialContext").named("doLookup"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget() || !MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        return description.build();
    }
}

