/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;

@BugPattern(summary="Possible sign flip from narrowing conversion", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class BadComparable
extends BugChecker
implements BugChecker.TypeCastTreeMatcher {
    private static final Matcher<ClassTree> COMPARABLE_CLASS_MATCHER = Matchers.isSubtypeOf("java.lang.Comparable");
    private static final Matcher<MethodTree> COMPARATOR_METHOD_MATCHER = Matchers.allOf(Matchers.methodIsNamed("compare"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns(Suppliers.INT_TYPE), Matchers.methodHasArity(2));
    private static final Matcher<ClassTree> COMPARATOR_CLASS_MATCHER = Matchers.isSubtypeOf("java.util.Comparator");

    private static Type getTypeOfSubtract(BinaryTree expression, VisitorState state) {
        Type expressionType = ASTHelpers.getType(expression.getLeftOperand());
        if (!ASTHelpers.isSameType(expressionType, ASTHelpers.getType(expression.getRightOperand()), state)) {
            return ASTHelpers.getType(expression);
        }
        return expressionType;
    }

    private static boolean matches(TypeCastTree tree, VisitorState state) {
        Type treeType = ASTHelpers.getType(tree.getType());
        if (treeType.getTag() != TypeTag.INT) {
            return false;
        }
        ExpressionTree expression = ASTHelpers.stripParentheses(tree.getExpression());
        if (expression.getKind() != Tree.Kind.MINUS) {
            return false;
        }
        Type expressionType = BadComparable.getTypeOfSubtract((BinaryTree)expression, state);
        TypeTag expressionTypeTag = state.getTypes().unboxedTypeOrType(expressionType).getTag();
        return expressionTypeTag == TypeTag.LONG;
    }

    @Override
    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!BadComparable.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ClassTree declaringClass = ASTHelpers.findEnclosingNode(state.getPath(), ClassTree.class);
        if (!COMPARABLE_CLASS_MATCHER.matches(declaringClass, state) && !COMPARATOR_CLASS_MATCHER.matches(declaringClass, state)) {
            return Description.NO_MATCH;
        }
        MethodTree method = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
        if (method == null) {
            return Description.NO_MATCH;
        }
        if (!Matchers.compareToMethodDeclaration().matches(method, state) && !COMPARATOR_METHOD_MATCHER.matches(method, state)) {
            return Description.NO_MATCH;
        }
        BinaryTree subtract = (BinaryTree)ASTHelpers.stripParentheses(tree.getExpression());
        ExpressionTree lhs = subtract.getLeftOperand();
        ExpressionTree rhs = subtract.getRightOperand();
        SuggestedFix fix = ASTHelpers.getType(lhs).isPrimitive() ? SuggestedFix.replace(tree, "Long.compare(" + state.getSourceForNode(lhs) + ", " + state.getSourceForNode(rhs) + ")") : SuggestedFix.replace(tree, state.getSourceForNode(lhs) + ".compareTo(" + state.getSourceForNode(rhs) + ")");
        return this.describeMatch(tree, (Fix)fix);
    }
}

