/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Object arrays are inferior to collections in almost every way. Prefer immutable collections (e.g., ImmutableSet, ImmutableList, etc.) over an object array whenever possible.", severity=BugPattern.SeverityLevel.WARNING)
public class AvoidObjectArrays
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of("com.tngtech.java.junit.dataprovider.DataProvider", "org.junit.runners.Parameterized.Parameters", "org.junit.experimental.theories.DataPoints", "junitparams.Parameters");
    private static final Matcher<MethodTree> MAIN_METHOD = Matchers.allOf(Matchers.methodHasArity(1), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.hasModifier(Modifier.STATIC), Matchers.methodReturns(Suppliers.VOID_TYPE), Matchers.methodIsNamed("main"), Matchers.methodHasParameters(Matchers.isSameType(Suppliers.arrayOf(Suppliers.STRING_TYPE))));

    @Override
    public Description matchMethod(MethodTree method, VisitorState state) {
        if (AvoidObjectArrays.shouldApplyApiChecks(method, state)) {
            if (AvoidObjectArrays.isObjectArray(method.getReturnType())) {
                state.reportMatch(this.createDescription(method.getReturnType(), state, "returning", "ImmutableList"));
            }
            for (int i = 0; i < method.getParameters().size(); ++i) {
                VariableTree varTree = method.getParameters().get(i);
                if (!AvoidObjectArrays.isObjectArray(varTree) || ASTHelpers.getSymbol(method).isVarArgs() && i == method.getParameters().size() - 1) continue;
                state.reportMatch(this.createDescription(varTree.getType(), state, "accepting", "Iterable"));
            }
        }
        return Description.NO_MATCH;
    }

    private Description createDescription(Tree tree, VisitorState state, String verb, String newType) {
        boolean isMultiDimensional;
        Type type = ASTHelpers.getType(tree);
        Object message = String.format("Avoid %s a %s", verb, SuggestedFixes.prettyType(type, state));
        if (type instanceof Type.ArrayType && !(isMultiDimensional = (type = ((Type.ArrayType)type).getComponentType()) instanceof Type.ArrayType)) {
            message = (String)message + String.format("; consider an %s<%s> instead", newType, SuggestedFixes.prettyType(type, state));
        }
        return this.buildDescription(tree).setMessage((String)message).build();
    }

    private static boolean isObjectArray(Tree tree) {
        Type type = ASTHelpers.getType(tree);
        return type instanceof Type.ArrayType && !((Type.ArrayType)type).getComponentType().isPrimitive();
    }

    private static boolean shouldApplyApiChecks(MethodTree methodTree, VisitorState state) {
        if (MAIN_METHOD.matches(methodTree, state)) {
            return false;
        }
        for (String annotationName : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Tree)methodTree, annotationName, state)) continue;
            return false;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(methodTree);
        if (state.getTypes().closure(method.owner.type).stream().map(superType -> superType.tsym.getKind()).anyMatch(Predicate.isEqual((Object)ElementKind.ANNOTATION_TYPE))) {
            return false;
        }
        return ASTHelpers.methodIsPublicAndNotAnOverride(method, state);
    }
}

