/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;

@BugPattern(summary="The lambda passed to assertThrows should contain exactly one statement", severity=BugPattern.SeverityLevel.WARNING)
public class AssertThrowsMultipleStatements
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.staticMethod().onClass("org.junit.Assert").named("assertThrows");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = Iterables.getLast(tree.getArguments());
        if (!(arg instanceof LambdaExpressionTree)) {
            return Description.NO_MATCH;
        }
        Tree body = ((LambdaExpressionTree)arg).getBody();
        if (!(body instanceof BlockTree)) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> statements = ((BlockTree)body).getStatements();
        if (statements.size() <= 1) {
            return Description.NO_MATCH;
        }
        StatementTree last = Iterables.getLast(statements);
        int startPosition = ASTHelpers.getStartPosition(statements.get(0));
        int endPosition = state.getEndPosition(statements.get(statements.size() - 2));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (last instanceof ExpressionStatementTree) {
            fix.replace(body, state.getSourceForNode(((ExpressionStatementTree)last).getExpression()));
        } else {
            fix.replace(startPosition, endPosition, "");
        }
        fix.prefixWith((Tree)state.findEnclosing(StatementTree.class), state.getSourceCode().subSequence(startPosition, endPosition).toString());
        return this.describeMatch(last, (Fix)fix.build());
    }
}

