/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Arrays.fill(Object[], Object) called with incompatible types.", severity=BugPattern.SeverityLevel.ERROR)
public class ArrayFillIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ARRAY_FILL_MATCHER = Matchers.anyOf(Matchers.staticMethod().onClass("java.util.Arrays").withSignature("fill(java.lang.Object[],java.lang.Object)"), Matchers.staticMethod().onClass("java.util.Arrays").withSignature("fill(java.lang.Object[],int,int,java.lang.Object)"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        Tree fillingArgument;
        Type fillingObjectType;
        if (!ARRAY_FILL_MATCHER.matches(invocationTree, state)) {
            return Description.NO_MATCH;
        }
        Type arrayComponentType = state.getTypes().elemtype(ASTHelpers.getType(invocationTree.getArguments().get(0)));
        if (ArrayFillIncompatibleType.isValidArrayFill(state, arrayComponentType, fillingObjectType = ASTHelpers.getType(fillingArgument = (Tree)Iterables.getLast(invocationTree.getArguments())))) {
            return Description.NO_MATCH;
        }
        if (fillingArgument.getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            ConditionalExpressionTree cet = (ConditionalExpressionTree)fillingArgument;
            Type trueExpressionType = ASTHelpers.getType(cet.getTrueExpression());
            if (!ArrayFillIncompatibleType.isValidArrayFill(state, arrayComponentType, trueExpressionType)) {
                return this.reportMismatch(invocationTree, arrayComponentType, trueExpressionType);
            }
            Type falseExpressionType = ASTHelpers.getType(cet.getFalseExpression());
            if (!ArrayFillIncompatibleType.isValidArrayFill(state, arrayComponentType, falseExpressionType)) {
                return this.reportMismatch(invocationTree, arrayComponentType, falseExpressionType);
            }
            return Description.NO_MATCH;
        }
        return this.reportMismatch(invocationTree, arrayComponentType, fillingObjectType);
    }

    private Description reportMismatch(MethodInvocationTree invocationTree, Type arrayComponentType, Type fillingObjectType) {
        return this.buildDescription(invocationTree).setMessage(ArrayFillIncompatibleType.getMessage(fillingObjectType, arrayComponentType)).build();
    }

    private static boolean isValidArrayFill(VisitorState state, Type arrayComponentType, Type fillingObjectType) {
        if (arrayComponentType == null || fillingObjectType == null) {
            return true;
        }
        return ASTHelpers.isSubtype(state.getTypes().boxedTypeOrType(fillingObjectType), arrayComponentType, state);
    }

    private static String getMessage(Type fillingObjectType, Type arrayComponentType) {
        String fillingTypeString = Signatures.prettyType(fillingObjectType);
        String arrayComponentTypeString = Signatures.prettyType(arrayComponentType);
        if (arrayComponentTypeString.equals(fillingTypeString)) {
            fillingTypeString = fillingObjectType.toString();
            arrayComponentTypeString = arrayComponentType.toString();
        }
        return "Calling Arrays.fill trying to put a " + fillingTypeString + " into an array of type " + arrayComponentTypeString;
    }
}

