/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Optional;

@BugPattern(summary="AnnotationValue#toString doesn't use fully qualified type names, prefer auto-common's AnnotationValues#toString", severity=BugPattern.SeverityLevel.SUGGESTION)
public class AnnotationValueToString
extends AbstractToString {
    private static final TypePredicate TYPE_PREDICATE = TypePredicates.isExactType("javax.lang.model.element.AnnotationValue");

    @Override
    protected TypePredicate typePredicate() {
        return TYPE_PREDICATE;
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return AnnotationValueToString.fix(tree, tree, state);
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        return AnnotationValueToString.fix(parent, tree, state);
    }

    private static Optional<Fix> fix(Tree replace, Tree with, VisitorState state) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(fix.replace(replace, String.format("%s.toString(%s)", SuggestedFixes.qualifyType(state, fix, "com.google.auto.common.AnnotationValues"), state.getSourceForNode(with))).build());
    }
}

