/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;

@CheckReturnValue
public abstract class AbstractPatternSyntaxChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> REGEX_USAGE = Matchers.anyOf(Matchers.instanceMethod().onExactClass("java.lang.String").namedAnyOf("matches", "split").withParameters("java.lang.String", new String[0]), Matchers.instanceMethod().onExactClass("java.lang.String").named("split").withParameters("java.lang.String", "int"), Matchers.instanceMethod().onExactClass("java.lang.String").namedAnyOf("replaceFirst", "replaceAll").withParameters("java.lang.String", "java.lang.String"), Matchers.staticMethod().onClass("java.util.regex.Pattern").named("matches"), Matchers.staticMethod().onClass("java.util.regex.Pattern").named("compile").withParameters("java.lang.String", new String[0]), Matchers.staticMethod().onClass("com.google.common.base.Splitter").named("onPattern"));
    private static final Matcher<MethodInvocationTree> REGEX_USAGE_WITH_FLAGS = Matchers.anyOf(Matchers.staticMethod().onClass("java.util.regex.Pattern").named("compile").withParameters("java.lang.String", "int"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (this.getMatcherWithoutFlags().matches(tree, state)) {
            String pattern = ASTHelpers.constValue(tree.getArguments().get(0), String.class);
            if (pattern != null) {
                return this.matchRegexLiteral(tree, state, pattern, 0);
            }
        } else if (this.getMatcherWithFlags().matches(tree, state)) {
            String pattern = ASTHelpers.constValue(tree.getArguments().get(0), String.class);
            Integer flags = ASTHelpers.constValue(tree.getArguments().get(1), Integer.class);
            if (pattern != null && flags != null) {
                return this.matchRegexLiteral(tree, state, pattern, flags);
            }
        }
        return Description.NO_MATCH;
    }

    @ForOverride
    protected Matcher<? super MethodInvocationTree> getMatcherWithoutFlags() {
        return REGEX_USAGE;
    }

    @ForOverride
    protected Matcher<? super MethodInvocationTree> getMatcherWithFlags() {
        return REGEX_USAGE_WITH_FLAGS;
    }

    @ForOverride
    protected abstract Description matchRegexLiteral(MethodInvocationTree var1, VisitorState var2, String var3, int var4);
}

