/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Prefer ASTHelpers instead of calling this API directly", severity=BugPattern.SeverityLevel.WARNING)
public class ASTHelpersSuggestions
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Supplier<Type> MODULE_SYMBOL = Suppliers.typeFromString("com.sun.tools.javac.code.Symbol.ModuleSymbol");
    private static final Matcher<ExpressionTree> SYMBOL = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("com.sun.tools.javac.code.Symbol").namedAnyOf("isDirectlyOrIndirectlyLocal", "isLocal", "packge"), MethodMatchers.instanceMethod().onClass((t2, s2) -> ASTHelpers.isSubtype(MODULE_SYMBOL.get(s2), t2, s2)).namedAnyOf("isStatic"));
    private static final Matcher<ExpressionTree> SCOPE = MethodMatchers.instanceMethod().onDescendantOf("com.sun.tools.javac.code.Scope");
    private static final ImmutableMap<String, String> NAMES = ImmutableMap.of("packge", "enclosingPackage", "isDirectlyOrIndirectlyLocal", "isLocal");
    private static final Supplier<Type> COM_SUN_TOOLS_JAVAC_UTIL_FILTER = VisitorState.memoize(state -> state.getTypeFromString("com.sun.tools.javac.util.Filter"));
    private static final Supplier<Type> JAVA_UTIL_FUNCTION_PREDICATE = VisitorState.memoize(state -> state.getTypeFromString("java.util.function.Predicate"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        if (receiver == null) {
            return Description.NO_MATCH;
        }
        if (SYMBOL.matches(tree, state)) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
            String name = ((Name)sym.getSimpleName()).toString();
            name = NAMES.getOrDefault(name, name);
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().addStaticImport("com.google.errorprone.util.ASTHelpers." + name).prefixWith(tree, name + "(").replace(state.getEndPosition(receiver), state.getEndPosition(tree), ")").build());
        }
        if (SCOPE.matches(tree, state)) {
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
            Type filter = COM_SUN_TOOLS_JAVAC_UTIL_FILTER.get(state);
            Type predicate = JAVA_UTIL_FUNCTION_PREDICATE.get(state);
            if (sym.getParameters().stream().anyMatch(p -> ASTHelpers.isSameType(filter, (Type)p.asType(), state) || ASTHelpers.isSameType(predicate, (Type)p.asType(), state))) {
                return this.describeMatch(tree, (Fix)SuggestedFix.builder().addStaticImport("com.google.errorprone.util.ASTHelpers.scope").prefixWith(receiver, "scope(").postfixWith(receiver, ")").build());
            }
        }
        return Description.NO_MATCH;
    }
}

