/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.ServiceLoader;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public final class ErrorPronePlugins {
    public static ScannerSupplier loadPlugins(ScannerSupplier scannerSupplier, Context context) {
        JavaFileManager fileManager = context.get(JavaFileManager.class);
        if (!fileManager.hasLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH)) {
            return scannerSupplier;
        }
        JavacProcessingEnvironment processingEnvironment = JavacProcessingEnvironment.instance(context);
        ClassLoader loader = processingEnvironment.getProcessorClassLoader();
        ImmutableList<Class<? extends BugChecker>> extraBugCheckers = ServiceLoader.load(BugChecker.class, loader).stream().map(ServiceLoader.Provider::type).collect(ImmutableList.toImmutableList());
        if (extraBugCheckers.isEmpty()) {
            return scannerSupplier;
        }
        return scannerSupplier.plus(ScannerSupplier.fromBugCheckerClasses(extraBugCheckers));
    }

    private ErrorPronePlugins() {
    }
}

