/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorPronePlugins;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.RefactoringCollection;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;

public class BaseErrorProneJavaCompiler
implements JavaCompiler {
    private final JavaCompiler javacTool;
    private final ScannerSupplier scannerSupplier;

    public BaseErrorProneJavaCompiler(ScannerSupplier scannerSupplier) {
        this(JavacTool.create(), scannerSupplier);
    }

    BaseErrorProneJavaCompiler(JavaCompiler javacTool, ScannerSupplier scannerSupplier) {
        this.javacTool = javacTool;
        this.scannerSupplier = scannerSupplier;
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        ErrorProneOptions errorProneOptions = ErrorProneOptions.processArgs(options);
        List<String> remainingOptions = Arrays.asList(errorProneOptions.getRemainingArgs());
        ImmutableList<String> javacOpts = ImmutableList.copyOf(remainingOptions);
        javacOpts = BaseErrorProneJavaCompiler.defaultToLatestSupportedLanguageLevel(javacOpts);
        javacOpts = BaseErrorProneJavaCompiler.setCompilePolicyToByFile(javacOpts);
        JavacTask task = (JavacTask)this.javacTool.getTask(out, fileManager, diagnosticListener, javacOpts, classes, compilationUnits);
        BaseErrorProneJavaCompiler.addTaskListener(task, this.scannerSupplier, errorProneOptions);
        return task;
    }

    static void addTaskListener(JavacTask javacTask, ScannerSupplier scannerSupplier, ErrorProneOptions errorProneOptions) {
        Context context = ((BasicJavacTask)javacTask).getContext();
        BaseErrorProneJavaCompiler.checkCompilePolicy(Options.instance(context).get("compilePolicy"));
        BaseErrorProneJavaCompiler.setupMessageBundle(context);
        RefactoringCollection[] refactoringCollection = new RefactoringCollection[]{null};
        javacTask.addTaskListener(BaseErrorProneJavaCompiler.createAnalyzer(scannerSupplier, errorProneOptions, context, refactoringCollection));
        if (refactoringCollection[0] != null) {
            javacTask.addTaskListener(new RefactoringTask(context, refactoringCollection[0]));
        }
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.javacTool.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int isSupportedOption(String option) {
        int numberOfArgs = this.javacTool.isSupportedOption(option);
        if (numberOfArgs != -1) {
            return numberOfArgs;
        }
        return ErrorProneOptions.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        return this.javacTool.run(in, out, err, arguments);
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        EnumSet<SourceVersion> filtered = EnumSet.noneOf(SourceVersion.class);
        for (SourceVersion version : this.javacTool.getSourceVersions()) {
            if (version.compareTo(SourceVersion.RELEASE_6) < 0) continue;
            filtered.add(version);
        }
        return filtered;
    }

    private static ImmutableList<String> defaultToLatestSupportedLanguageLevel(ImmutableList<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new String[]{"-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel})).addAll(args)).build();
    }

    static void checkCompilePolicy(@Nullable String compilePolicy) {
        if (compilePolicy == null) {
            throw new InvalidCommandLineOptionException("The default compilation policy (by-todo) is not supported by Error Prone, pass -XDcompilePolicy=simple instead");
        }
        switch (compilePolicy) {
            case "byfile": 
            case "simple": {
                break;
            }
            default: {
                throw new InvalidCommandLineOptionException(String.format("-XDcompilePolicy=%s is not supported by Error Prone, pass -XDcompilePolicy=simple instead", compilePolicy));
            }
        }
    }

    private static ImmutableList<String> setCompilePolicyToByFile(ImmutableList<String> args) {
        for (String arg : args) {
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            String value = arg.substring(arg.indexOf(61) + 1);
            BaseErrorProneJavaCompiler.checkCompilePolicy(value);
            return args;
        }
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(args)).add("-XDcompilePolicy=simple")).build();
    }

    public static void setupMessageBundle(Context context) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.google.errorprone.errors");
        JavacMessages.instance(context).add(l -> bundle);
    }

    static ErrorProneAnalyzer createAnalyzer(ScannerSupplier scannerSupplier, ErrorProneOptions epOptions, Context context, RefactoringCollection[] refactoringCollection) {
        if (!epOptions.patchingOptions().doRefactor()) {
            return ErrorProneAnalyzer.createByScanningForPlugins(scannerSupplier, epOptions, context);
        }
        refactoringCollection[0] = RefactoringCollection.refactor(epOptions.patchingOptions(), context);
        CodeTransformer codeTransformer = epOptions.patchingOptions().customRefactorer().or(() -> {
            ScannerSupplier toUse = ErrorPronePlugins.loadPlugins(scannerSupplier, context).applyOverrides(epOptions);
            ImmutableSet<String> namedCheckers = epOptions.patchingOptions().namedCheckers();
            if (!namedCheckers.isEmpty()) {
                toUse = toUse.filter(bci -> namedCheckers.contains(bci.canonicalName()));
            }
            return ErrorProneScannerTransformer.create((Scanner)toUse.get());
        }).get();
        return ErrorProneAnalyzer.createWithCustomDescriptionListener(codeTransformer, epOptions, context, refactoringCollection[0]);
    }

    static class RefactoringTask
    implements TaskListener {
        private final Context context;
        private final RefactoringCollection refactoringCollection;

        public RefactoringTask(Context context, RefactoringCollection refactoringCollection) {
            this.context = context;
            this.refactoringCollection = refactoringCollection;
        }

        @Override
        public void started(TaskEvent event) {
        }

        @Override
        public void finished(TaskEvent event) {
            RefactoringCollection.RefactoringResult refactoringResult;
            if (event.getKind() != TaskEvent.Kind.GENERATE) {
                return;
            }
            try {
                refactoringResult = this.refactoringCollection.applyChanges(event.getSourceFile().toUri());
            }
            catch (Exception e) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.ERROR);
                out.println(e.getMessage());
                out.flush();
                return;
            }
            if (refactoringResult.type() == RefactoringCollection.RefactoringResultType.CHANGED) {
                PrintWriter out = Log.instance(this.context).getWriter(Log.WriterKind.NOTICE);
                out.println(refactoringResult.message());
                out.flush();
            }
        }
    }
}

