/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.devtools.build.lib.worker.WorkerProtocol;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.management.OperatingSystemMXBean;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class WorkRequestHandler
implements AutoCloseable {
    final ConcurrentMap<Integer, RequestInfo> activeRequests = new ConcurrentHashMap<Integer, RequestInfo>();
    private final WorkRequestCallback callback;
    private final PrintStream stderr;
    final WorkerMessageProcessor messageProcessor;
    private final BiConsumer<Integer, Thread> cancelCallback;
    private final CpuTimeBasedGcScheduler gcScheduler;
    private final IdleGcScheduler idleGcScheduler;
    private final AtomicBoolean shutdownWorker = new AtomicBoolean(false);

    @Deprecated
    public WorkRequestHandler(BiFunction<List<String>, PrintWriter, Integer> callback, PrintStream stderr, WorkerMessageProcessor messageProcessor) {
        this(callback, stderr, messageProcessor, Duration.ZERO, null);
    }

    @Deprecated
    public WorkRequestHandler(BiFunction<List<String>, PrintWriter, Integer> callback, PrintStream stderr, WorkerMessageProcessor messageProcessor, Duration cpuUsageBeforeGc) {
        this(callback, stderr, messageProcessor, cpuUsageBeforeGc, null);
    }

    @Deprecated
    private WorkRequestHandler(BiFunction<List<String>, PrintWriter, Integer> callback, PrintStream stderr, WorkerMessageProcessor messageProcessor, Duration cpuUsageBeforeGc, BiConsumer<Integer, Thread> cancelCallback) {
        this(new WorkRequestCallback((request, pw) -> (Integer)callback.apply(request.getArgumentsList(), (PrintWriter)pw)), stderr, messageProcessor, cpuUsageBeforeGc, cancelCallback, Duration.ZERO);
    }

    private WorkRequestHandler(WorkRequestCallback callback, PrintStream stderr, WorkerMessageProcessor messageProcessor, Duration cpuUsageBeforeGc, BiConsumer<Integer, Thread> cancelCallback, Duration idleTimeBeforeGc) {
        this.callback = callback;
        this.stderr = stderr;
        this.messageProcessor = messageProcessor;
        this.gcScheduler = new CpuTimeBasedGcScheduler(cpuUsageBeforeGc);
        this.cancelCallback = cancelCallback;
        this.idleGcScheduler = new IdleGcScheduler(idleTimeBeforeGc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processRequests() throws IOException {
        block21: {
            WorkerIO workerIO = WorkerIO.capture();
            while (!this.shutdownWorker.get()) {
                WorkerProtocol.WorkRequest request = this.messageProcessor.readWorkRequest();
                this.idleGcScheduler.markActivity(true);
                if (request == null) break;
                if (request.getCancel()) {
                    this.respondToCancelRequest(request);
                    continue;
                }
                this.startResponseThread(workerIO, request);
            }
            this.idleGcScheduler.stop();
            for (RequestInfo ri : this.activeRequests.values()) {
                if (!ri.thread.isAlive()) continue;
                try {
                    ri.thread.interrupt();
                }
                catch (RuntimeException runtimeException) {}
            }
            try {
                workerIO.close();
            }
            catch (Exception e) {
                this.stderr.println(e.getMessage());
            }
            break block21;
            catch (IOException e) {
                this.stderr.println("Error reading next WorkRequest: " + e);
                e.printStackTrace(this.stderr);
                this.idleGcScheduler.stop();
                for (RequestInfo ri : this.activeRequests.values()) {
                    if (!ri.thread.isAlive()) continue;
                    try {
                        ri.thread.interrupt();
                    }
                    catch (RuntimeException runtimeException) {}
                }
                try {
                    workerIO.close();
                }
                catch (Exception e2) {
                    this.stderr.println(e2.getMessage());
                }
                catch (Throwable throwable) {
                    this.idleGcScheduler.stop();
                    for (RequestInfo ri : this.activeRequests.values()) {
                        if (!ri.thread.isAlive()) continue;
                        try {
                            ri.thread.interrupt();
                        }
                        catch (RuntimeException runtimeException) {}
                    }
                    try {
                        workerIO.close();
                    }
                    catch (Exception e3) {
                        this.stderr.println(e3.getMessage());
                    }
                    throw throwable;
                }
            }
        }
    }

    void startResponseThread(WorkerIO workerIO, WorkerProtocol.WorkRequest request) {
        String threadName;
        Thread currentThread = Thread.currentThread();
        String string = threadName = request.getRequestId() > 0 ? "multiplex-request-" + request.getRequestId() : "singleplex-request";
        if (request.getRequestId() == 0) {
            while (this.activeRequests.containsKey(request.getRequestId())) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        Thread t2 = new Thread(() -> {
            RequestInfo requestInfo = (RequestInfo)this.activeRequests.get(request.getRequestId());
            if (requestInfo == null) {
                this.idleGcScheduler.markActivity(!this.activeRequests.isEmpty());
                return;
            }
            try {
                this.respondToRequest(workerIO, request, requestInfo);
            }
            catch (IOException e) {
                block5: {
                    try {
                        if (this.shutdownWorker.compareAndSet(false, true)) break block5;
                        this.stderr.println("Error communicating with server, shutting down worker.");
                        e.printStackTrace(this.stderr);
                        currentThread.interrupt();
                    }
                    catch (Throwable throwable) {
                        this.activeRequests.remove(request.getRequestId());
                        this.idleGcScheduler.markActivity(!this.activeRequests.isEmpty());
                        throw throwable;
                    }
                }
                this.activeRequests.remove(request.getRequestId());
                this.idleGcScheduler.markActivity(!this.activeRequests.isEmpty());
            }
            this.activeRequests.remove(request.getRequestId());
            this.idleGcScheduler.markActivity(!this.activeRequests.isEmpty());
        }, threadName);
        t2.setUncaughtExceptionHandler((t1, e) -> {
            if (e instanceof Error && this.shutdownWorker.compareAndSet(false, true)) {
                this.stderr.println("Error thrown by worker thread, shutting down worker.");
                e.printStackTrace(this.stderr);
                currentThread.interrupt();
                this.idleGcScheduler.stop();
            }
        });
        RequestInfo previous = this.activeRequests.putIfAbsent(request.getRequestId(), new RequestInfo(t2));
        if (previous != null) {
            throw new IllegalStateException("Request still active: " + request.getRequestId());
        }
        t2.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void respondToRequest(WorkerIO workerIO, WorkerProtocol.WorkRequest request, RequestInfo requestInfo) throws IOException {
        Optional<WorkerProtocol.WorkResponse.Builder> optBuilder;
        int exitCode;
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            try {
                exitCode = this.callback.apply(request, pw);
            }
            catch (InterruptedException e) {
                exitCode = 1;
            }
            catch (RuntimeException e) {
                e.printStackTrace(pw);
                exitCode = 1;
            }
            try {
                String captured = workerIO.readCapturedAsUtf8String().trim();
                if (!captured.isEmpty()) {
                    pw.write(captured);
                }
            }
            catch (IOException e) {
                this.stderr.println(e.getMessage());
            }
        }
        if ((optBuilder = requestInfo.takeBuilder()).isPresent()) {
            WorkerProtocol.WorkResponse.Builder builder = optBuilder.get();
            builder.setRequestId(request.getRequestId());
            if (requestInfo.isCancelled()) {
                builder.setWasCancelled(true);
            } else {
                builder.setOutput(builder.getOutput() + sw).setExitCode(exitCode);
            }
            WorkerProtocol.WorkResponse response = builder.build();
            WorkRequestHandler workRequestHandler = this;
            synchronized (workRequestHandler) {
                this.messageProcessor.writeWorkResponse(response);
            }
        }
        this.gcScheduler.maybePerformGc();
    }

    void respondToCancelRequest(WorkerProtocol.WorkRequest request) {
        RequestInfo ri = (RequestInfo)this.activeRequests.get(request.getRequestId());
        if (ri == null) {
            return;
        }
        if (this.cancelCallback == null) {
            ri.setCancelled();
            ri.addOutput(String.format("Cancellation request received for worker request %d, but this worker does not support cancellation.\n", request.getRequestId()));
        } else if (ri.thread.isAlive() && !ri.isCancelled()) {
            ri.setCancelled();
            Thread t2 = new Thread(() -> this.cancelCallback.accept(request.getRequestId(), ri.thread));
            t2.start();
        }
    }

    @Override
    public void close() throws IOException {
        this.messageProcessor.close();
    }

    public static class WorkerIO
    implements AutoCloseable {
        private final InputStream originalInputStream;
        private final PrintStream originalOutputStream;
        private final PrintStream originalErrorStream;
        private final ByteArrayOutputStream capturedStream;
        private final AutoCloseable restore;

        @VisibleForTesting
        WorkerIO(InputStream originalInputStream, PrintStream originalOutputStream, PrintStream originalErrorStream, ByteArrayOutputStream capturedStream, AutoCloseable restore) {
            this.originalInputStream = originalInputStream;
            this.originalOutputStream = originalOutputStream;
            this.originalErrorStream = originalErrorStream;
            this.capturedStream = capturedStream;
            this.restore = restore;
        }

        public static WorkerIO capture() {
            InputStream originalInputStream = System.in;
            PrintStream originalOutputStream = System.out;
            PrintStream originalErrorStream = System.err;
            ByteArrayOutputStream capturedStream = new ByteArrayOutputStream();
            PrintStream outputBuffer = new PrintStream(capturedStream, true);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
            System.setIn(byteArrayInputStream);
            System.setOut(outputBuffer);
            System.setErr(outputBuffer);
            return new WorkerIO(originalInputStream, originalOutputStream, originalErrorStream, capturedStream, () -> {
                System.setIn(originalInputStream);
                System.setOut(originalOutputStream);
                System.setErr(originalErrorStream);
                outputBuffer.close();
                byteArrayInputStream.close();
            });
        }

        @VisibleForTesting
        InputStream getOriginalInputStream() {
            return this.originalInputStream;
        }

        @VisibleForTesting
        PrintStream getOriginalOutputStream() {
            return this.originalOutputStream;
        }

        @VisibleForTesting
        PrintStream getOriginalErrorStream() {
            return this.originalErrorStream;
        }

        @VisibleForTesting
        String readCapturedAsUtf8String() throws IOException {
            this.capturedStream.flush();
            String captureOutput = this.capturedStream.toString(StandardCharsets.UTF_8);
            this.capturedStream.reset();
            return captureOutput;
        }

        @Override
        public void close() throws Exception {
            this.restore.close();
        }
    }

    private static class CpuTimeBasedGcScheduler {
        private final Duration cpuUsageBeforeGc;
        private final AtomicReference<Duration> cpuTimeAtLastGc;
        private static final OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

        public CpuTimeBasedGcScheduler(Duration cpuUsageBeforeGc) {
            this.cpuUsageBeforeGc = cpuUsageBeforeGc;
            this.cpuTimeAtLastGc = new AtomicReference<Duration>(this.getCpuTime());
        }

        private Duration getCpuTime() {
            return !this.cpuUsageBeforeGc.isZero() ? Duration.ofNanos(bean.getProcessCpuTime()) : Duration.ZERO;
        }

        private void maybePerformGc() {
            Duration lastCpuTime;
            Duration currentCpuTime;
            if (!this.cpuUsageBeforeGc.isZero() && (currentCpuTime = this.getCpuTime()).minus(lastCpuTime = this.cpuTimeAtLastGc.get()).compareTo(this.cpuUsageBeforeGc) > 0 && this.cpuTimeAtLastGc.compareAndSet(lastCpuTime, currentCpuTime)) {
                System.gc();
                this.cpuTimeAtLastGc.compareAndSet(currentCpuTime, this.getCpuTime());
            }
        }
    }

    private static class IdleGcScheduler {
        private Instant lastActivity = Instant.EPOCH;
        private Instant lastGc = Instant.EPOCH;
        private final Duration idleTimeBeforeGc;
        private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        private ScheduledFuture<?> futureGc = null;

        public IdleGcScheduler(Duration idleTimeBeforeGc) {
            this.idleTimeBeforeGc = idleTimeBeforeGc;
        }

        synchronized void start() {
            if (!this.idleTimeBeforeGc.isZero()) {
                this.futureGc = this.executor.schedule(this::maybeDoGc, this.idleTimeBeforeGc.toMillis(), TimeUnit.MILLISECONDS);
            }
        }

        synchronized void markActivity(boolean anythingActive) {
            this.lastActivity = Instant.now();
            if (this.futureGc != null) {
                this.futureGc.cancel(false);
                this.futureGc = null;
            }
            if (!anythingActive) {
                this.start();
            }
        }

        private void maybeDoGc() {
            if (this.lastGc.isBefore(this.lastActivity) && this.lastActivity.isBefore(Instant.now().minus(this.idleTimeBeforeGc))) {
                System.gc();
                this.lastGc = Instant.now();
            } else {
                this.start();
            }
        }

        synchronized void stop() {
            if (this.futureGc != null) {
                this.futureGc.cancel(false);
                this.futureGc = null;
            }
            this.executor.shutdown();
        }
    }

    public static class WorkRequestHandlerBuilder {
        private final WorkRequestCallback callback;
        private final PrintStream stderr;
        private final WorkerMessageProcessor messageProcessor;
        private Duration cpuUsageBeforeGc = Duration.ZERO;
        private BiConsumer<Integer, Thread> cancelCallback;
        private Duration idleTimeBeforeGc = Duration.ZERO;

        @Deprecated
        public WorkRequestHandlerBuilder(BiFunction<List<String>, PrintWriter, Integer> callback, PrintStream stderr, WorkerMessageProcessor messageProcessor) {
            this(new WorkRequestCallback((request, pw) -> (Integer)callback.apply(request.getArgumentsList(), (PrintWriter)pw)), stderr, messageProcessor);
        }

        public WorkRequestHandlerBuilder(WorkRequestCallback callback, PrintStream stderr, WorkerMessageProcessor messageProcessor) {
            this.callback = callback;
            this.stderr = stderr;
            this.messageProcessor = messageProcessor;
        }

        @CanIgnoreReturnValue
        public WorkRequestHandlerBuilder setCpuUsageBeforeGc(Duration cpuUsageBeforeGc) {
            this.cpuUsageBeforeGc = cpuUsageBeforeGc;
            return this;
        }

        @CanIgnoreReturnValue
        public WorkRequestHandlerBuilder setCancelCallback(BiConsumer<Integer, Thread> cancelCallback) {
            this.cancelCallback = cancelCallback;
            return this;
        }

        @CanIgnoreReturnValue
        public WorkRequestHandlerBuilder setIdleTimeBeforeGc(Duration idleTimeBeforeGc) {
            this.idleTimeBeforeGc = idleTimeBeforeGc;
            return this;
        }

        public WorkRequestHandler build() {
            return new WorkRequestHandler(this.callback, this.stderr, this.messageProcessor, this.cpuUsageBeforeGc, this.cancelCallback, this.idleTimeBeforeGc);
        }
    }

    public static class WorkRequestCallback {
        private final BiFunction<WorkerProtocol.WorkRequest, PrintWriter, Integer> callback;

        public WorkRequestCallback(BiFunction<WorkerProtocol.WorkRequest, PrintWriter, Integer> callback) {
            this.callback = callback;
        }

        public Integer apply(WorkerProtocol.WorkRequest workRequest, PrintWriter printWriter) throws InterruptedException {
            Integer result = this.callback.apply(workRequest, printWriter);
            if (Thread.interrupted()) {
                throw new InterruptedException("Work request interrupted: " + workRequest.getRequestId());
            }
            return result;
        }
    }

    static class RequestInfo {
        final Thread thread;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private WorkerProtocol.WorkResponse.Builder responseBuilder = WorkerProtocol.WorkResponse.newBuilder();

        RequestInfo(Thread thread) {
            this.thread = thread;
        }

        void setCancelled() {
            this.cancelled.set(true);
        }

        boolean isCancelled() {
            return this.cancelled.get();
        }

        synchronized Optional<WorkerProtocol.WorkResponse.Builder> takeBuilder() {
            WorkerProtocol.WorkResponse.Builder b = this.responseBuilder;
            this.responseBuilder = null;
            return Optional.ofNullable(b);
        }

        synchronized void addOutput(String s2) {
            if (this.responseBuilder != null) {
                this.responseBuilder.setOutput(this.responseBuilder.getOutput() + s2);
            }
        }
    }

    public static interface WorkerMessageProcessor {
        public WorkerProtocol.WorkRequest readWorkRequest() throws IOException;

        public void writeWorkResponse(WorkerProtocol.WorkResponse var1) throws IOException;

        public void close() throws IOException;
    }
}

