/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.worker;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.worker.WorkRequestHandler;
import com.google.devtools.build.lib.worker.WorkerProtocol;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.JsonFormat;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;

public final class JsonWorkerMessageProcessor
implements WorkRequestHandler.WorkerMessageProcessor {
    private final JsonReader reader;
    private final JsonFormat.Printer jsonPrinter;
    private final BufferedWriter jsonWriter;

    public JsonWorkerMessageProcessor(JsonReader reader, BufferedWriter jsonWriter) {
        this.reader = reader;
        reader.setLenient(true);
        this.jsonWriter = jsonWriter;
        this.jsonPrinter = JsonFormat.printer().omittingInsignificantWhitespace().includingDefaultValueFields();
    }

    private static ImmutableList<String> readArguments(JsonReader reader) throws IOException {
        reader.beginArray();
        ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
        while (reader.hasNext()) {
            argumentsBuilder.add(reader.nextString());
        }
        reader.endArray();
        return argumentsBuilder.build();
    }

    private static ImmutableList<WorkerProtocol.Input> readInputs(JsonReader reader) throws IOException {
        reader.beginArray();
        ImmutableList.Builder inputsBuilder = ImmutableList.builder();
        while (reader.hasNext()) {
            String digest = null;
            String path = null;
            reader.beginObject();
            block9: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "digest": {
                        if (digest != null) {
                            throw new IOException("Input cannot have more than one digest");
                        }
                        digest = reader.nextString();
                        continue block9;
                    }
                    case "path": {
                        if (path != null) {
                            throw new IOException("Input cannot have more than one path");
                        }
                        path = reader.nextString();
                        continue block9;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            WorkerProtocol.Input.Builder inputBuilder = WorkerProtocol.Input.newBuilder();
            if (digest != null) {
                inputBuilder.setDigest(ByteString.copyFromUtf8(digest));
            }
            if (path != null) {
                inputBuilder.setPath(path);
            }
            inputsBuilder.add(inputBuilder.build());
        }
        reader.endArray();
        return inputsBuilder.build();
    }

    @Override
    public WorkerProtocol.WorkRequest readWorkRequest() throws IOException {
        ImmutableList<String> arguments = null;
        ImmutableList<WorkerProtocol.Input> inputs = null;
        Integer requestId = null;
        Integer verbosity = null;
        try {
            this.reader.beginObject();
            block14: while (this.reader.hasNext()) {
                String name;
                switch (name = this.reader.nextName()) {
                    case "arguments": {
                        if (arguments != null) {
                            throw new IOException("WorkRequest cannot have more than one 'arguments' field");
                        }
                        arguments = JsonWorkerMessageProcessor.readArguments(this.reader);
                        continue block14;
                    }
                    case "inputs": {
                        if (inputs != null) {
                            throw new IOException("WorkRequest cannot have more than one 'inputs' field");
                        }
                        inputs = JsonWorkerMessageProcessor.readInputs(this.reader);
                        continue block14;
                    }
                    case "requestId": {
                        if (requestId != null) {
                            throw new IOException("WorkRequest cannot have more than one requestId");
                        }
                        requestId = this.reader.nextInt();
                        continue block14;
                    }
                    case "verbosity": {
                        if (verbosity != null) {
                            throw new IOException("Work response cannot have more than one verbosity");
                        }
                        verbosity = this.reader.nextInt();
                        continue block14;
                    }
                }
                this.reader.skipValue();
            }
            this.reader.endObject();
        }
        catch (MalformedJsonException | EOFException | IllegalStateException e) {
            throw new IOException(e);
        }
        WorkerProtocol.WorkRequest.Builder requestBuilder = WorkerProtocol.WorkRequest.newBuilder();
        if (arguments != null) {
            requestBuilder.addAllArguments(arguments);
        }
        if (inputs != null) {
            requestBuilder.addAllInputs(inputs);
        }
        if (requestId != null) {
            requestBuilder.setRequestId(requestId);
        }
        if (verbosity != null) {
            requestBuilder.setVerbosity(verbosity);
        }
        return requestBuilder.build();
    }

    @Override
    public void writeWorkResponse(WorkerProtocol.WorkResponse response) throws IOException {
        this.jsonPrinter.appendTo(response, this.jsonWriter);
        this.jsonWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.jsonWriter.close();
    }
}

