/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.statistics;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.buildjar.javac.statistics.AutoValue_BlazeJavacStatistics;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.tools.javac.util.Context;
import java.time.Duration;
import java.util.Optional;

@AutoValue
public abstract class BlazeJavacStatistics {
    private static final Cache<Context, Builder> contextsInitialized = Caffeine.newBuilder().weakKeys().build();

    public static void preRegister(Context context) {
        contextsInitialized.get(context, unused -> {
            Builder instance = BlazeJavacStatistics.newBuilder();
            context.put(Builder.class, instance);
            return instance;
        });
    }

    public static BlazeJavacStatistics empty() {
        return BlazeJavacStatistics.newBuilder().build();
    }

    private static Builder newBuilder() {
        return new AutoValue_BlazeJavacStatistics.Builder().transitiveClasspathLength(0).reducedClasspathLength(0).minClasspathLength(0).transitiveClasspathFallback(false);
    }

    public abstract ImmutableMap<AuxiliaryDataSource, byte[]> auxiliaryData();

    public abstract Optional<Duration> totalErrorProneTime();

    public abstract Optional<Duration> errorProneInitializationTime();

    public abstract ImmutableMap<String, Duration> bugpatternTiming();

    public abstract Optional<Duration> totalProcessorTime();

    public abstract ImmutableMap<String, Duration> processorTiming();

    public abstract ImmutableSet<String> processors();

    public abstract int transitiveClasspathLength();

    public abstract int reducedClasspathLength();

    public abstract int minClasspathLength();

    public abstract boolean transitiveClasspathFallback();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder totalErrorProneTime(Duration var1);

        public abstract Builder errorProneInitializationTime(Duration var1);

        public abstract Builder totalProcessorTime(Duration var1);

        abstract ImmutableMap.Builder<String, Duration> bugpatternTimingBuilder();

        abstract ImmutableMap.Builder<String, Duration> processorTimingBuilder();

        abstract ImmutableMap.Builder<AuxiliaryDataSource, byte[]> auxiliaryDataBuilder();

        abstract ImmutableSet.Builder<String> processorsBuilder();

        public abstract Builder transitiveClasspathLength(int var1);

        public abstract Builder reducedClasspathLength(int var1);

        public abstract Builder minClasspathLength(int var1);

        public abstract Builder transitiveClasspathFallback(boolean var1);

        @CanIgnoreReturnValue
        public Builder addBugpatternTiming(String key, Duration value) {
            this.bugpatternTimingBuilder().put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProcessorTiming(String key, Duration value) {
            this.processorTimingBuilder().put(key, value);
            return this;
        }

        public abstract BlazeJavacStatistics build();

        @CanIgnoreReturnValue
        public Builder addAuxiliaryData(AuxiliaryDataSource key, byte[] serializedData) {
            this.auxiliaryDataBuilder().put(key, (byte[])serializedData.clone());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProcessor(String processor) {
            this.processorsBuilder().add((Object)processor);
            return this;
        }
    }

    public static enum AuxiliaryDataSource {
        DAGGER;

    }
}

