/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.statistics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import java.time.Duration;
import java.util.Optional;

final class AutoValue_BlazeJavacStatistics
extends BlazeJavacStatistics {
    private final ImmutableMap<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryData;
    private final Optional<Duration> totalErrorProneTime;
    private final Optional<Duration> errorProneInitializationTime;
    private final ImmutableMap<String, Duration> bugpatternTiming;
    private final Optional<Duration> totalProcessorTime;
    private final ImmutableMap<String, Duration> processorTiming;
    private final ImmutableSet<String> processors;
    private final int transitiveClasspathLength;
    private final int reducedClasspathLength;
    private final int minClasspathLength;
    private final boolean transitiveClasspathFallback;

    private AutoValue_BlazeJavacStatistics(ImmutableMap<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryData, Optional<Duration> totalErrorProneTime, Optional<Duration> errorProneInitializationTime, ImmutableMap<String, Duration> bugpatternTiming, Optional<Duration> totalProcessorTime, ImmutableMap<String, Duration> processorTiming, ImmutableSet<String> processors, int transitiveClasspathLength, int reducedClasspathLength, int minClasspathLength, boolean transitiveClasspathFallback) {
        this.auxiliaryData = auxiliaryData;
        this.totalErrorProneTime = totalErrorProneTime;
        this.errorProneInitializationTime = errorProneInitializationTime;
        this.bugpatternTiming = bugpatternTiming;
        this.totalProcessorTime = totalProcessorTime;
        this.processorTiming = processorTiming;
        this.processors = processors;
        this.transitiveClasspathLength = transitiveClasspathLength;
        this.reducedClasspathLength = reducedClasspathLength;
        this.minClasspathLength = minClasspathLength;
        this.transitiveClasspathFallback = transitiveClasspathFallback;
    }

    @Override
    public ImmutableMap<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryData() {
        return this.auxiliaryData;
    }

    @Override
    public Optional<Duration> totalErrorProneTime() {
        return this.totalErrorProneTime;
    }

    @Override
    public Optional<Duration> errorProneInitializationTime() {
        return this.errorProneInitializationTime;
    }

    @Override
    public ImmutableMap<String, Duration> bugpatternTiming() {
        return this.bugpatternTiming;
    }

    @Override
    public Optional<Duration> totalProcessorTime() {
        return this.totalProcessorTime;
    }

    @Override
    public ImmutableMap<String, Duration> processorTiming() {
        return this.processorTiming;
    }

    @Override
    public ImmutableSet<String> processors() {
        return this.processors;
    }

    @Override
    public int transitiveClasspathLength() {
        return this.transitiveClasspathLength;
    }

    @Override
    public int reducedClasspathLength() {
        return this.reducedClasspathLength;
    }

    @Override
    public int minClasspathLength() {
        return this.minClasspathLength;
    }

    @Override
    public boolean transitiveClasspathFallback() {
        return this.transitiveClasspathFallback;
    }

    public String toString() {
        return "BlazeJavacStatistics{auxiliaryData=" + this.auxiliaryData + ", totalErrorProneTime=" + this.totalErrorProneTime + ", errorProneInitializationTime=" + this.errorProneInitializationTime + ", bugpatternTiming=" + this.bugpatternTiming + ", totalProcessorTime=" + this.totalProcessorTime + ", processorTiming=" + this.processorTiming + ", processors=" + this.processors + ", transitiveClasspathLength=" + this.transitiveClasspathLength + ", reducedClasspathLength=" + this.reducedClasspathLength + ", minClasspathLength=" + this.minClasspathLength + ", transitiveClasspathFallback=" + this.transitiveClasspathFallback + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BlazeJavacStatistics) {
            BlazeJavacStatistics that = (BlazeJavacStatistics)o;
            return this.auxiliaryData.equals(that.auxiliaryData()) && this.totalErrorProneTime.equals(that.totalErrorProneTime()) && this.errorProneInitializationTime.equals(that.errorProneInitializationTime()) && this.bugpatternTiming.equals(that.bugpatternTiming()) && this.totalProcessorTime.equals(that.totalProcessorTime()) && this.processorTiming.equals(that.processorTiming()) && this.processors.equals(that.processors()) && this.transitiveClasspathLength == that.transitiveClasspathLength() && this.reducedClasspathLength == that.reducedClasspathLength() && this.minClasspathLength == that.minClasspathLength() && this.transitiveClasspathFallback == that.transitiveClasspathFallback();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.auxiliaryData.hashCode();
        h$ *= 1000003;
        h$ ^= this.totalErrorProneTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorProneInitializationTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.bugpatternTiming.hashCode();
        h$ *= 1000003;
        h$ ^= this.totalProcessorTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.processorTiming.hashCode();
        h$ *= 1000003;
        h$ ^= this.processors.hashCode();
        h$ *= 1000003;
        h$ ^= this.transitiveClasspathLength;
        h$ *= 1000003;
        h$ ^= this.reducedClasspathLength;
        h$ *= 1000003;
        h$ ^= this.minClasspathLength;
        h$ *= 1000003;
        return h$ ^= this.transitiveClasspathFallback ? 1231 : 1237;
    }

    @Override
    public BlazeJavacStatistics.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BlazeJavacStatistics.Builder {
        private ImmutableMap.Builder<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryDataBuilder$;
        private ImmutableMap<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryData;
        private Optional<Duration> totalErrorProneTime = Optional.empty();
        private Optional<Duration> errorProneInitializationTime = Optional.empty();
        private ImmutableMap.Builder<String, Duration> bugpatternTimingBuilder$;
        private ImmutableMap<String, Duration> bugpatternTiming;
        private Optional<Duration> totalProcessorTime = Optional.empty();
        private ImmutableMap.Builder<String, Duration> processorTimingBuilder$;
        private ImmutableMap<String, Duration> processorTiming;
        private ImmutableSet.Builder<String> processorsBuilder$;
        private ImmutableSet<String> processors;
        private Integer transitiveClasspathLength;
        private Integer reducedClasspathLength;
        private Integer minClasspathLength;
        private Boolean transitiveClasspathFallback;

        Builder() {
        }

        private Builder(BlazeJavacStatistics source) {
            this.auxiliaryData = source.auxiliaryData();
            this.totalErrorProneTime = source.totalErrorProneTime();
            this.errorProneInitializationTime = source.errorProneInitializationTime();
            this.bugpatternTiming = source.bugpatternTiming();
            this.totalProcessorTime = source.totalProcessorTime();
            this.processorTiming = source.processorTiming();
            this.processors = source.processors();
            this.transitiveClasspathLength = source.transitiveClasspathLength();
            this.reducedClasspathLength = source.reducedClasspathLength();
            this.minClasspathLength = source.minClasspathLength();
            this.transitiveClasspathFallback = source.transitiveClasspathFallback();
        }

        @Override
        ImmutableMap.Builder<BlazeJavacStatistics.AuxiliaryDataSource, byte[]> auxiliaryDataBuilder() {
            if (this.auxiliaryDataBuilder$ == null) {
                if (this.auxiliaryData == null) {
                    this.auxiliaryDataBuilder$ = ImmutableMap.builder();
                } else {
                    this.auxiliaryDataBuilder$ = ImmutableMap.builder();
                    this.auxiliaryDataBuilder$.putAll(this.auxiliaryData);
                    this.auxiliaryData = null;
                }
            }
            return this.auxiliaryDataBuilder$;
        }

        @Override
        public BlazeJavacStatistics.Builder totalErrorProneTime(Duration totalErrorProneTime) {
            this.totalErrorProneTime = Optional.of(totalErrorProneTime);
            return this;
        }

        @Override
        public BlazeJavacStatistics.Builder errorProneInitializationTime(Duration errorProneInitializationTime) {
            this.errorProneInitializationTime = Optional.of(errorProneInitializationTime);
            return this;
        }

        @Override
        ImmutableMap.Builder<String, Duration> bugpatternTimingBuilder() {
            if (this.bugpatternTimingBuilder$ == null) {
                if (this.bugpatternTiming == null) {
                    this.bugpatternTimingBuilder$ = ImmutableMap.builder();
                } else {
                    this.bugpatternTimingBuilder$ = ImmutableMap.builder();
                    this.bugpatternTimingBuilder$.putAll(this.bugpatternTiming);
                    this.bugpatternTiming = null;
                }
            }
            return this.bugpatternTimingBuilder$;
        }

        @Override
        public BlazeJavacStatistics.Builder totalProcessorTime(Duration totalProcessorTime) {
            this.totalProcessorTime = Optional.of(totalProcessorTime);
            return this;
        }

        @Override
        ImmutableMap.Builder<String, Duration> processorTimingBuilder() {
            if (this.processorTimingBuilder$ == null) {
                if (this.processorTiming == null) {
                    this.processorTimingBuilder$ = ImmutableMap.builder();
                } else {
                    this.processorTimingBuilder$ = ImmutableMap.builder();
                    this.processorTimingBuilder$.putAll(this.processorTiming);
                    this.processorTiming = null;
                }
            }
            return this.processorTimingBuilder$;
        }

        @Override
        ImmutableSet.Builder<String> processorsBuilder() {
            if (this.processorsBuilder$ == null) {
                if (this.processors == null) {
                    this.processorsBuilder$ = ImmutableSet.builder();
                } else {
                    this.processorsBuilder$ = ImmutableSet.builder();
                    this.processorsBuilder$.addAll(this.processors);
                    this.processors = null;
                }
            }
            return this.processorsBuilder$;
        }

        @Override
        public BlazeJavacStatistics.Builder transitiveClasspathLength(int transitiveClasspathLength) {
            this.transitiveClasspathLength = transitiveClasspathLength;
            return this;
        }

        @Override
        public BlazeJavacStatistics.Builder reducedClasspathLength(int reducedClasspathLength) {
            this.reducedClasspathLength = reducedClasspathLength;
            return this;
        }

        @Override
        public BlazeJavacStatistics.Builder minClasspathLength(int minClasspathLength) {
            this.minClasspathLength = minClasspathLength;
            return this;
        }

        @Override
        public BlazeJavacStatistics.Builder transitiveClasspathFallback(boolean transitiveClasspathFallback) {
            this.transitiveClasspathFallback = transitiveClasspathFallback;
            return this;
        }

        @Override
        public BlazeJavacStatistics build() {
            if (this.auxiliaryDataBuilder$ != null) {
                this.auxiliaryData = this.auxiliaryDataBuilder$.build();
            } else if (this.auxiliaryData == null) {
                this.auxiliaryData = ImmutableMap.of();
            }
            if (this.bugpatternTimingBuilder$ != null) {
                this.bugpatternTiming = this.bugpatternTimingBuilder$.build();
            } else if (this.bugpatternTiming == null) {
                this.bugpatternTiming = ImmutableMap.of();
            }
            if (this.processorTimingBuilder$ != null) {
                this.processorTiming = this.processorTimingBuilder$.build();
            } else if (this.processorTiming == null) {
                this.processorTiming = ImmutableMap.of();
            }
            if (this.processorsBuilder$ != null) {
                this.processors = this.processorsBuilder$.build();
            } else if (this.processors == null) {
                this.processors = ImmutableSet.of();
            }
            if (this.transitiveClasspathLength == null || this.reducedClasspathLength == null || this.minClasspathLength == null || this.transitiveClasspathFallback == null) {
                StringBuilder missing = new StringBuilder();
                if (this.transitiveClasspathLength == null) {
                    missing.append(" transitiveClasspathLength");
                }
                if (this.reducedClasspathLength == null) {
                    missing.append(" reducedClasspathLength");
                }
                if (this.minClasspathLength == null) {
                    missing.append(" minClasspathLength");
                }
                if (this.transitiveClasspathFallback == null) {
                    missing.append(" transitiveClasspathFallback");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BlazeJavacStatistics(this.auxiliaryData, this.totalErrorProneTime, this.errorProneInitializationTime, this.bugpatternTiming, this.totalProcessorTime, this.processorTiming, this.processors, this.transitiveClasspathLength, this.reducedClasspathLength, this.minClasspathLength, this.transitiveClasspathFallback);
        }
    }
}

