/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.processing;

import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.processing.AnnotationProcessingModule;
import com.google.devtools.build.buildjar.proto.JavaCompilation;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;

public class AnnotationProcessingPlugin
extends BlazeJavaCompilerPlugin {
    private final HashSet<JCTree.JCCompilationUnit> toplevels = new HashSet();
    private final AnnotationProcessingModule processingModule;

    public AnnotationProcessingPlugin(AnnotationProcessingModule processingModule) {
        this.processingModule = processingModule;
    }

    @Override
    public void postAttribute(Env<AttrContext> env) {
        if (this.toplevels.add(env.toplevel)) {
            this.recordInfo(env.toplevel);
        }
    }

    private void recordInfo(JCTree.JCCompilationUnit toplevel) {
        JavaCompilation.CompilationUnit.Builder builder = JavaCompilation.CompilationUnit.newBuilder();
        if (toplevel.sourcefile != null) {
            Path path = Paths.get(toplevel.sourcefile.getName(), new String[0]);
            builder.setPath(this.processingModule.stripSourceRoot(path).toString());
            builder.setGeneratedByAnnotationProcessor(this.processingModule.isGenerated(path));
        }
        if (toplevel.getPackageName() != null) {
            builder.setPkg(toplevel.getPackageName().toString());
        }
        for (JCTree decl : toplevel.defs) {
            if (!(decl instanceof JCTree.JCClassDecl)) continue;
            builder.addTopLevel(((JCTree.JCClassDecl)decl).getSimpleName().toString());
        }
        this.processingModule.recordUnit(builder.build());
    }
}

