/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.processing;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.processing.AnnotationProcessingPlugin;
import com.google.devtools.build.buildjar.proto.JavaCompilation;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AnnotationProcessingModule {
    private final boolean enabled;
    private final Path sourceGenDir;
    private final Path manifestProto;
    private final Map<String, JavaCompilation.CompilationUnit> units = new HashMap<String, JavaCompilation.CompilationUnit>();

    public boolean isGenerated(Path path) {
        return path.startsWith(this.sourceGenDir);
    }

    public Path stripSourceRoot(Path path) {
        return path.startsWith(this.sourceGenDir) ? this.sourceGenDir.relativize(path) : path;
    }

    private AnnotationProcessingModule(Path sourceGenDir, Path manifestProto) {
        this.sourceGenDir = sourceGenDir;
        this.manifestProto = manifestProto;
        this.enabled = sourceGenDir != null && manifestProto != null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void registerPlugin(ImmutableList.Builder<BlazeJavaCompilerPlugin> builder) {
        if (this.enabled) {
            builder.add((Object)new AnnotationProcessingPlugin(this));
        }
    }

    public void recordUnit(JavaCompilation.CompilationUnit unit) {
        this.units.put(unit.getPath(), unit);
    }

    private JavaCompilation.Manifest buildManifestProto() {
        JavaCompilation.Manifest.Builder builder = JavaCompilation.Manifest.newBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.units.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            JavaCompilation.CompilationUnit unit = this.units.get(key);
            builder.addCompilationUnit(unit);
        }
        return builder.build();
    }

    public void emitManifestProto() throws IOException {
        if (!this.enabled) {
            return;
        }
        try (OutputStream out = Files.newOutputStream(this.manifestProto, new OpenOption[0]);){
            this.buildManifestProto().writeTo(out);
        }
        catch (IOException ex) {
            throw new IOException("Cannot write manifest to " + this.manifestProto, ex);
        }
    }

    public static class Builder {
        private Path sourceGenDir;
        private Path manifestProto;

        private Builder() {
        }

        public AnnotationProcessingModule build() {
            return new AnnotationProcessingModule(this.sourceGenDir, this.manifestProto);
        }

        public void setSourceGenDir(Path sourceGenDir) {
            this.sourceGenDir = sourceGenDir;
        }

        public void setManifestProtoPath(Path manifestProto) {
            this.manifestProto = manifestProto.toAbsolutePath();
        }
    }
}

