/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.errorprone;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import com.google.errorprone.BaseErrorProneJavaCompiler;
import com.google.errorprone.ErrorProneAnalyzer;
import com.google.errorprone.ErrorProneError;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorProneTimings;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.scanner.BuiltInCheckerSuppliers;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.TaskEvent;
import com.sun.tools.javac.code.DeferredCompletionFailureHandler;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ErrorPronePlugin
extends BlazeJavaCompilerPlugin {
    private final ScannerSupplier scannerSupplier;
    private ErrorProneAnalyzer errorProneAnalyzer;
    private ErrorProneOptions epOptions;
    private ErrorProneTimings timings;
    private DeferredCompletionFailureHandler deferredCompletionFailureHandler;
    private final Stopwatch elapsed = Stopwatch.createUnstarted();

    public ErrorPronePlugin() {
        this(BuiltInCheckerSuppliers.errorChecks());
    }

    public ErrorPronePlugin(ScannerSupplier scannerSupplier) {
        this.scannerSupplier = scannerSupplier;
    }

    public static void setupMessageBundle(Context context) {
        BaseErrorProneJavaCompiler.setupMessageBundle(context);
    }

    @Override
    public void processArgs(ImmutableList<String> standardJavacopts, ImmutableList<String> blazeJavacopts) throws InvalidCommandLineException {
        ImmutableCollection.Builder epArgs = ImmutableList.builder().addAll(blazeJavacopts);
        ((ImmutableList.Builder)epArgs).add("-XepIgnoreUnknownCheckNames");
        this.processEpOptions((List<String>)((Object)((ImmutableList.Builder)epArgs).build()));
    }

    private void processEpOptions(List<String> args) throws InvalidCommandLineException {
        try {
            this.epOptions = ErrorProneOptions.processArgs(args);
        }
        catch (InvalidCommandLineOptionException e) {
            throw new InvalidCommandLineException(e.getMessage());
        }
    }

    @Override
    public void init(Context context, Log log, JavaCompiler compiler, BlazeJavacStatistics.Builder statisticsBuilder) {
        super.init(context, log, compiler, statisticsBuilder);
        ErrorPronePlugin.setupMessageBundle(context);
        if (this.epOptions == null) {
            this.epOptions = ErrorProneOptions.empty();
        }
        this.errorProneAnalyzer = ErrorProneAnalyzer.createByScanningForPlugins(this.scannerSupplier, this.epOptions, context);
        this.timings = ErrorProneTimings.instance(context);
        this.deferredCompletionFailureHandler = DeferredCompletionFailureHandler.instance(context);
    }

    @Override
    public void postFlow(Env<AttrContext> env) {
        DeferredCompletionFailureHandler.Handler previousDeferredCompletionFailureHandler = this.deferredCompletionFailureHandler.setHandler(this.deferredCompletionFailureHandler.userCodeHandler);
        this.elapsed.start();
        try {
            this.errorProneAnalyzer.finished(new TaskEvent(TaskEvent.Kind.ANALYZE, env.toplevel, env.enclClass.sym));
        }
        catch (ErrorProneError e) {
            e.logFatalError(this.log, this.context);
            throw e;
        }
        finally {
            this.elapsed.stop();
            this.deferredCompletionFailureHandler.setHandler(previousDeferredCompletionFailureHandler);
        }
    }

    @Override
    public void finish() {
        this.statisticsBuilder.totalErrorProneTime(this.elapsed.elapsed());
        ErrorPronePlugin.initializationTime(this.timings).ifPresent(this.statisticsBuilder::errorProneInitializationTime);
        this.timings.timings().entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).forEachOrdered(e -> this.statisticsBuilder.addBugpatternTiming((String)e.getKey(), (Duration)e.getValue()));
    }

    private static Optional<Duration> initializationTime(ErrorProneTimings timings) {
        try {
            return Optional.of((Duration)ErrorProneTimings.class.getMethod("initializationTime", new Class[0]).invoke((Object)timings, new Object[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }
}

