/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.dependency;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.devtools.build.buildjar.JarOwner;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.dependency.AutoValue_StrictJavaDepsPlugin_SjdDiagnostic;
import com.google.devtools.build.buildjar.javac.plugins.dependency.DependencyModule;
import com.google.devtools.build.buildjar.javac.plugins.dependency.ImplicitDependencyExtractor;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import com.google.devtools.build.lib.view.proto.Deps;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.tools.JavaFileObject;

public final class StrictJavaDepsPlugin
extends BlazeJavaCompilerPlugin {
    private static final Attributes.Name TARGET_LABEL = new Attributes.Name("Target-Label");
    private static final Attributes.Name INJECTING_RULE_KIND = new Attributes.Name("Injecting-Rule-Kind");
    private ImplicitDependencyExtractor implicitDependencyExtractor;
    private CheckingTreeScanner checkingTreeScanner;
    private final DependencyModule dependencyModule;
    private final Set<JCTree.JCCompilationUnit> toplevels;
    private final Set<JCTree> trees;
    private final Set<JarOwner> missingTargets;
    private final java.util.List<SjdDiagnostic> diagnostics;
    private PrintWriter errWriter;

    public StrictJavaDepsPlugin(DependencyModule dependencyModule) {
        this.dependencyModule = dependencyModule;
        this.toplevels = new HashSet<JCTree.JCCompilationUnit>();
        this.trees = new HashSet<JCTree>();
        this.missingTargets = new HashSet<JarOwner>();
        this.diagnostics = new ArrayList<SjdDiagnostic>();
    }

    @Override
    public void init(Context context, Log log, JavaCompiler compiler, BlazeJavacStatistics.Builder statisticsBuilder) {
        super.init(context, log, compiler, statisticsBuilder);
        this.errWriter = log.getWriter(Log.WriterKind.ERROR);
        this.implicitDependencyExtractor = new ImplicitDependencyExtractor(this.dependencyModule.getImplicitDependenciesMap(), this.dependencyModule.getPlatformJars());
        this.checkingTreeScanner = context.get(CheckingTreeScanner.class);
        if (this.checkingTreeScanner == null) {
            ImmutableSet<Path> platformJars = this.dependencyModule.getPlatformJars();
            this.checkingTreeScanner = new CheckingTreeScanner(this.dependencyModule, this.diagnostics, this.missingTargets, platformJars);
            context.put(CheckingTreeScanner.class, this.checkingTreeScanner);
        }
    }

    @Override
    public void postAttribute(Env<AttrContext> env) {
        JavaFileObject previousSource = this.checkingTreeScanner.source;
        try {
            if (this.isAnnotationProcessorExempt(env.toplevel)) {
                return;
            }
            this.checkingTreeScanner.source = env.enclClass.sym.sourcefile != null ? env.enclClass.sym.sourcefile : env.toplevel.sourcefile;
            if (this.trees.add(env.tree)) {
                this.checkingTreeScanner.scan(env.tree);
            }
            if (this.toplevels.add(env.toplevel)) {
                this.checkingTreeScanner.scan((List<? extends JCTree>)env.toplevel.getImports());
                this.checkingTreeScanner.scan(env.toplevel.getPackage());
                this.dependencyModule.addPackage(env.toplevel.packge);
            }
        }
        finally {
            this.checkingTreeScanner.source = previousSource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void finish() {
        this.implicitDependencyExtractor.accumulate(this.context, this.checkingTreeScanner.getSeenClasses());
lbl2:
        // 5 sources

        block7: for (SjdDiagnostic diagnostic : this.diagnostics) {
            prev = this.log.useSource(diagnostic.source());
            try {
                switch (2.$SwitchMap$com$google$devtools$build$buildjar$javac$plugins$dependency$DependencyModule$StrictJavaDeps[this.dependencyModule.getStrictJavaDeps().ordinal()]) {
                    case 1: {
                        this.log.error(diagnostic.pos(), CompilerProperties.Errors.ProcMessager(diagnostic.message()));
                        ** break;
                    }
                    case 2: {
                        this.log.warning(diagnostic.pos(), CompilerProperties.Warnings.ProcMessager(diagnostic.message()));
                        ** break;
                    }
                    ** default:
lbl13:
                    // 1 sources

                    continue block7;
                }
            }
            finally {
                this.log.useSource(prev);
            }
        }
        if (!this.missingTargets.isEmpty()) {
            canonicalizedLabel = this.dependencyModule.getTargetLabel() == null ? null : StrictJavaDepsPlugin.canonicalizeTarget(this.dependencyModule.getTargetLabel());
            canonicalizedMissing = this.missingTargets.stream().filter((Predicate<JarOwner>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$finish$0(com.google.devtools.build.buildjar.JarOwner ), (Lcom/google/devtools/build/buildjar/JarOwner;)Z)()).sorted(Comparator.comparing((Function<JarOwner, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$finish$1(com.google.devtools.build.buildjar.JarOwner ), (Lcom/google/devtools/build/buildjar/JarOwner;)Ljava/lang/String;)())).map((Function<JarOwner, JarOwner>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$finish$3(com.google.devtools.build.buildjar.JarOwner ), (Lcom/google/devtools/build/buildjar/JarOwner;)Lcom/google/devtools/build/buildjar/JarOwner;)()).collect(ImmutableSet.toImmutableSet());
            if (this.dependencyModule.getStrictJavaDeps() != DependencyModule.StrictJavaDeps.OFF) {
                this.errWriter.print(this.dependencyModule.getFixMessage().get(canonicalizedMissing, canonicalizedLabel));
                this.dependencyModule.setHasMissingTargets();
            }
        }
    }

    public boolean isAnnotationProcessorExempt(JCTree.JCCompilationUnit unit) {
        if (((List)unit.getTypeDecls()).size() != 1) {
            return false;
        }
        Symbol sym = TreeInfo.symbolFor((JCTree)Iterables.getOnlyElement(unit.getTypeDecls()));
        if (sym == null) {
            return false;
        }
        for (String value : StrictJavaDepsPlugin.getGeneratedBy(sym)) {
            if (!this.dependencyModule.getExemptGenerators().contains(value)) continue;
            return true;
        }
        return false;
    }

    private static ImmutableSet<String> getGeneratedBy(Symbol symbol) {
        final ImmutableSet.Builder suppressions = ImmutableSet.builder();
        symbol.getRawAttributes().stream().filter(a -> {
            Name name = a.type.tsym.getQualifiedName();
            return name.contentEquals("javax.annotation.Generated") || name.contentEquals("javax.annotation.processing.Generated");
        }).flatMap(a -> a.getElementValues().entrySet().stream().filter(e -> ((Name)((Symbol.MethodSymbol)e.getKey()).getSimpleName()).contentEquals("value")).map(e -> (Attribute)e.getValue())).forEachOrdered(a -> a.accept(new SimpleAnnotationValueVisitor8<Void, Void>(){

            @Override
            public Void visitString(String s2, Void aVoid) {
                suppressions.add(s2);
                return (Void)super.visitString(s2, aVoid);
            }

            @Override
            public Void visitArray(java.util.List<? extends AnnotationValue> vals, Void aVoid) {
                vals.forEach(v -> v.accept(this, null));
                return (Void)super.visitArray(vals, aVoid);
            }
        }, null));
        return suppressions.build();
    }

    static String canonicalizeTarget(String target) {
        String suffix;
        int colonIndex = target.indexOf(58);
        if (colonIndex == -1) {
            return target;
        }
        int lastSlash = target.lastIndexOf(47, colonIndex);
        if (lastSlash == -1) {
            return target;
        }
        String packageName = target.substring(lastSlash + 1, colonIndex);
        if (packageName.equals(suffix = target.substring(colonIndex + 1))) {
            return target.substring(0, colonIndex);
        }
        return target;
    }

    public static Path getJarPath(Symbol.ClassSymbol classSymbol, Set<Path> platformJars) {
        if (classSymbol == null) {
            return null;
        }
        if (StrictJavaDepsPlugin.haveSourceForSymbol(classSymbol)) {
            return null;
        }
        JavaFileObject classfile = classSymbol.classfile;
        Path path = ImplicitDependencyExtractor.getJarPath(classfile);
        if (path == null) {
            return null;
        }
        if (platformJars.contains(path)) {
            return null;
        }
        return path;
    }

    private static boolean haveSourceForSymbol(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.sourcefile == null) {
            return false;
        }
        try {
            classSymbol.sourcefile.getLastModified();
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean runOnAttributionErrors() {
        return true;
    }

    private static /* synthetic */ JarOwner lambda$finish$3(JarOwner owner) {
        return owner.withLabel(owner.label().map(label -> StrictJavaDepsPlugin.canonicalizeTarget(label)));
    }

    private static /* synthetic */ String lambda$finish$1(JarOwner owner) {
        return owner.label().get();
    }

    private static /* synthetic */ boolean lambda$finish$0(JarOwner owner) {
        return owner.label().isPresent();
    }

    private static class CheckingTreeScanner
    extends TreeScanner {
        private final ImmutableSet<Path> directJars;
        private final java.util.List<SjdDiagnostic> diagnostics;
        private final Set<JarOwner> missingTargets;
        private final Map<Path, Deps.Dependency> directDependenciesMap;
        private final Set<Symbol.ClassSymbol> seenClasses = new HashSet<Symbol.ClassSymbol>();
        private final Set<JarOwner> seenTargets = new HashSet<JarOwner>();
        private final Set<Path> seenStrictDepsViolatingJars = new HashSet<Path>();
        private final Set<Path> platformJars;
        private JavaFileObject source = null;
        private static final Predicate<JCTree.JCVariableDecl> DECLARED_USING_VAR = CheckingTreeScanner.getDeclaredUsingVar();

        public CheckingTreeScanner(DependencyModule dependencyModule, java.util.List<SjdDiagnostic> diagnostics, Set<JarOwner> missingTargets, Set<Path> platformJars) {
            this.directJars = dependencyModule.directJars();
            this.diagnostics = diagnostics;
            this.missingTargets = missingTargets;
            this.directDependenciesMap = dependencyModule.getExplicitDependenciesMap();
            this.platformJars = platformJars;
        }

        Set<Symbol.ClassSymbol> getSeenClasses() {
            return this.seenClasses;
        }

        private void checkTypeLiteral(JCTree node, Symbol sym) {
            if (sym == null || sym.kind != Kinds.Kind.TYP) {
                return;
            }
            Path jarPath = StrictJavaDepsPlugin.getJarPath(sym.enclClass(), this.platformJars);
            if (jarPath != null && this.seenClasses.add(sym.enclClass())) {
                this.collectExplicitDependency(jarPath, node, sym);
            }
        }

        private void collectExplicitDependency(Path jarPath, JCTree node, Symbol sym) {
            JarOwner owner;
            if (!this.directJars.contains(jarPath) && this.seenStrictDepsViolatingJars.add(jarPath) && this.seenTargets.add(owner = CheckingTreeScanner.readJarOwnerFromManifest(jarPath))) {
                Optional<String> canonicalTargetName = owner.label().map(label -> StrictJavaDepsPlugin.canonicalizeTarget(label));
                this.missingTargets.add(owner);
                String toolInfo = owner.aspect().isPresent() ? String.format("%s wrapped in %s", canonicalTargetName.get(), owner.aspect().get()) : (canonicalTargetName.isPresent() ? canonicalTargetName.get() : owner.jar().toString());
                String used = sym.getSimpleName().contentEquals("package-info") ? "package " + sym.getEnclosingElement() : "type " + sym;
                String message = String.format("[strict] Using %s from an indirect dependency (TOOL_INFO: \"%s\").%s", used, toolInfo, owner.label().isPresent() ? " See command below **" : "");
                this.diagnostics.add(SjdDiagnostic.create(node.pos, message, this.source));
            }
            if (!this.directDependenciesMap.containsKey(jarPath)) {
                Deps.Dependency dep = Deps.Dependency.newBuilder().setPath(jarPath.toString()).setKind(Deps.Dependency.Kind.EXPLICIT).build();
                this.directDependenciesMap.put(jarPath, dep);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static JarOwner readJarOwnerFromManifest(Path jarPath) {
            try (JarFile jarFile = new JarFile(jarPath.toFile());){
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    JarOwner jarOwner = JarOwner.create(jarPath);
                    return jarOwner;
                }
                Attributes attributes = manifest.getMainAttributes();
                String label = (String)attributes.get(TARGET_LABEL);
                if (label == null) {
                    JarOwner jarOwner = JarOwner.create(jarPath);
                    return jarOwner;
                }
                String injectingRuleKind = (String)attributes.get(INJECTING_RULE_KIND);
                JarOwner jarOwner = JarOwner.create(jarPath, label, Optional.ofNullable(injectingRuleKind));
                return jarOwner;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if ((method.mods.flags & 0x1000000000L) != 0L) {
                this.scan(method.body);
            } else {
                super.visitMethodDef(method);
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl variable) {
            this.scan(variable.mods);
            if (!CheckingTreeScanner.declaredUsingVar(variable)) {
                this.scan(variable.vartype);
            }
            this.scan(variable.nameexpr);
            this.scan(variable.init);
        }

        private static boolean declaredUsingVar(JCTree.JCVariableDecl variableTree) {
            return DECLARED_USING_VAR.test(variableTree);
        }

        private static Predicate<JCTree.JCVariableDecl> getDeclaredUsingVar() {
            Method method;
            try {
                method = JCTree.JCVariableDecl.class.getMethod("declaredUsingVar", new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                return variableTree -> false;
            }
            return variableTree -> {
                try {
                    return (Boolean)method.invoke(variableTree, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError(e.getMessage(), e);
                }
            };
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.checkTypeLiteral(tree, tree.sym);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            this.scan(tree.selected);
            this.checkTypeLiteral(tree, tree.sym);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.paramKind != JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.scan(tree.params);
            }
            this.scan(tree.body);
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl tree) {
            this.scan(tree.annotations);
            this.checkTypeLiteral(tree, tree.packge.package_info);
        }
    }

    @AutoValue
    static abstract class SjdDiagnostic {
        SjdDiagnostic() {
        }

        abstract int pos();

        abstract String message();

        abstract JavaFileObject source();

        static SjdDiagnostic create(int pos, String message, JavaFileObject source) {
            return new AutoValue_StrictJavaDepsPlugin_SjdDiagnostic(pos, message, source);
        }
    }
}

