/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.dependency;

import com.google.devtools.build.lib.view.proto.Deps;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.util.Context;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.tools.JavaFileObject;

public class ImplicitDependencyExtractor {
    private final Map<Path, Deps.Dependency> depsMap;
    private final TypeVisitor typeVisitor = new TypeVisitor();
    private final Set<Path> platformJars;

    public ImplicitDependencyExtractor(Map<Path, Deps.Dependency> depsMap, Set<Path> platformJars) {
        this.depsMap = depsMap;
        this.platformJars = platformJars;
    }

    public void accumulate(Context context, Set<Symbol.ClassSymbol> roots) {
        Symtab symtab = Symtab.instance(context);
        for (Symbol.ClassSymbol root : roots) {
            root.type.accept(this.typeVisitor, null);
        }
        for (Symbol.ClassSymbol cs : symtab.getAllClasses()) {
            boolean completed = cs.isCompleted();
            if (cs.classfile != null) {
                this.collectJarOf(cs.classfile, this.platformJars, completed);
                continue;
            }
            if (cs.sourcefile == null) continue;
            this.collectJarOf(cs.sourcefile, this.platformJars, completed);
        }
    }

    private void collectJarOf(JavaFileObject reference, Set<Path> platformJars, boolean completed) {
        Path path = ImplicitDependencyExtractor.getJarPath(reference);
        if (path == null) {
            return;
        }
        if (platformJars.contains(path)) {
            return;
        }
        Deps.Dependency currentDep = this.depsMap.get(path);
        if (currentDep == null || completed && currentDep.getKind() == Deps.Dependency.Kind.INCOMPLETE) {
            this.depsMap.put(path, Deps.Dependency.newBuilder().setKind(completed ? Deps.Dependency.Kind.IMPLICIT : Deps.Dependency.Kind.INCOMPLETE).setPath(path.toString()).build());
        }
    }

    public static Path getJarPath(JavaFileObject file) {
        if (file == null) {
            return null;
        }
        try {
            Field field = file.getClass().getDeclaredField("userJarPath");
            field.setAccessible(true);
            return (Path)field.get(file);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static class TypeVisitor
    extends SimpleTypeVisitor7<Void, Void> {
        private TypeVisitor() {
        }
    }
}

