/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac.plugins.dependency;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.devtools.build.buildjar.JarOwner;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.dependency.StrictJavaDepsPlugin;
import com.google.devtools.build.lib.view.proto.Deps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.sun.tools.javac.code.Symbol;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public final class DependencyModule {
    private static final ImmutableSet<String> SJD_EXEMPT_PROCESSORS = ImmutableSet.of("dagger.internal.codegen.ComponentProcessor", "dagger.hilt.processor.internal.root.RootProcessor");
    private final StrictJavaDeps strictJavaDeps;
    private final FixTool fixDepsTool;
    private final ImmutableSet<Path> directJars;
    private final boolean strictClasspathMode;
    private final Set<Path> depsArtifacts;
    private final String targetLabel;
    private final Path outputDepsProtoFile;
    private boolean hasMissingTargets;
    private final Map<Path, Deps.Dependency> explicitDependenciesMap;
    private final Map<Path, Deps.Dependency> implicitDependenciesMap;
    private final ImmutableSet<Path> platformJars;
    Set<Path> requiredClasspath;
    private final FixMessage fixMessage;
    private final Set<String> exemptGenerators;
    private final Set<Symbol.PackageSymbol> packages;

    DependencyModule(StrictJavaDeps strictJavaDeps, FixTool fixDepsTool, ImmutableSet<Path> directJars, boolean strictClasspathMode, Set<Path> depsArtifacts, ImmutableSet<Path> platformJars, String targetLabel, Path outputDepsProtoFile, FixMessage fixMessage, Set<String> exemptGenerators) {
        this.strictJavaDeps = strictJavaDeps;
        this.fixDepsTool = fixDepsTool;
        this.directJars = directJars;
        this.strictClasspathMode = strictClasspathMode;
        this.depsArtifacts = depsArtifacts;
        this.targetLabel = targetLabel;
        this.outputDepsProtoFile = outputDepsProtoFile;
        this.explicitDependenciesMap = new HashMap<Path, Deps.Dependency>();
        this.implicitDependenciesMap = new HashMap<Path, Deps.Dependency>();
        this.platformJars = platformJars;
        this.fixMessage = fixMessage;
        this.exemptGenerators = exemptGenerators;
        this.packages = new HashSet<Symbol.PackageSymbol>();
    }

    public BlazeJavaCompilerPlugin getPlugin() {
        return new StrictJavaDepsPlugin(this);
    }

    public void emitDependencyInformation(ImmutableList<Path> classpath, boolean successful, boolean requiresFallback) throws IOException {
        if (this.outputDepsProtoFile == null) {
            return;
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(this.outputDepsProtoFile, new OpenOption[0]));){
            this.buildDependenciesProto(classpath, successful, requiresFallback).writeTo(out);
        }
        catch (IOException ex) {
            throw new IOException("Cannot write dependencies to " + this.outputDepsProtoFile, ex);
        }
    }

    @VisibleForTesting
    Deps.Dependencies buildDependenciesProto(ImmutableList<Path> classpath, boolean successful, boolean requiresFallback) {
        Deps.Dependencies.Builder deps = Deps.Dependencies.newBuilder();
        if (this.targetLabel != null) {
            deps.setRuleLabel(this.targetLabel);
        }
        deps.setSuccess(successful);
        if (requiresFallback) {
            deps.setRequiresReducedClasspathFallback(true);
        }
        deps.addAllContainedPackage(this.packages.stream().map(pkg -> pkg.isUnnamed() ? "" : pkg.getQualifiedName().toString()).sorted().collect(ImmutableList.toImmutableList()));
        for (Path entry : classpath) {
            if (this.explicitDependenciesMap.containsKey(entry)) {
                deps.addDependency(this.explicitDependenciesMap.get(entry));
                continue;
            }
            if (!this.implicitDependenciesMap.containsKey(entry)) continue;
            deps.addDependency(this.implicitDependenciesMap.get(entry));
        }
        return deps.build();
    }

    public ImmutableSet<Path> directJars() {
        return this.directJars;
    }

    public StrictJavaDeps getStrictJavaDeps() {
        return this.strictJavaDeps;
    }

    public FixTool getFixDepsTool() {
        return this.fixDepsTool;
    }

    public Map<Path, Deps.Dependency> getExplicitDependenciesMap() {
        return this.explicitDependenciesMap;
    }

    public Map<Path, Deps.Dependency> getImplicitDependenciesMap() {
        return this.implicitDependenciesMap;
    }

    public ImmutableSet<Path> getPlatformJars() {
        return this.platformJars;
    }

    public boolean addPackage(Symbol.PackageSymbol packge) {
        return this.packages.add(packge);
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public Path getOutputDepsProtoFile() {
        return this.outputDepsProtoFile;
    }

    public FixMessage getFixMessage() {
        return this.fixMessage;
    }

    public Set<String> getExemptGenerators() {
        return this.exemptGenerators;
    }

    public boolean reduceClasspath() {
        return this.strictClasspathMode;
    }

    void setHasMissingTargets() {
        this.hasMissingTargets = true;
    }

    public boolean hasMissingTargets() {
        return this.hasMissingTargets;
    }

    public ImmutableList<Path> computeStrictClasspath(ImmutableList<Path> originalClasspath) throws IOException {
        if (!this.strictClasspathMode) {
            return originalClasspath;
        }
        this.requiredClasspath = new HashSet<Path>(this.directJars);
        for (Path depsArtifact : this.depsArtifacts) {
            this.collectDependenciesFromArtifact(depsArtifact);
        }
        return originalClasspath.stream().filter(this.requiredClasspath::contains).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    void setStrictClasspath(Set<Path> strictClasspath) {
        this.requiredClasspath = strictClasspath;
    }

    private void collectDependenciesFromArtifact(Path path) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));){
            Deps.Dependencies deps = Deps.Dependencies.parseFrom(bis);
            if (!deps.hasRuleLabel()) {
                throw new IOException("Could not parse Deps.Dependencies message from proto.");
            }
            for (Deps.Dependency dep : deps.getDependencyList()) {
                if (dep.getKind() != Deps.Dependency.Kind.EXPLICIT && dep.getKind() != Deps.Dependency.Kind.IMPLICIT && dep.getKind() != Deps.Dependency.Kind.INCOMPLETE) continue;
                this.requiredClasspath.add(Paths.get(dep.getPath(), new String[0]));
            }
        }
        catch (IOException e) {
            throw new IOException(String.format("error reading deps artifact: %s", path), e);
        }
    }

    static /* synthetic */ ImmutableSet access$100() {
        return SJD_EXEMPT_PROCESSORS;
    }

    public static class Builder {
        private StrictJavaDeps strictJavaDeps = StrictJavaDeps.OFF;
        private FixTool fixDepsTool = null;
        private ImmutableSet<Path> directJars = ImmutableSet.of();
        private final Set<Path> depsArtifacts = new HashSet<Path>();
        private ImmutableSet<Path> platformJars = ImmutableSet.of();
        private String targetLabel;
        private Path outputDepsProtoFile;
        private boolean strictClasspathMode = false;
        private FixMessage fixMessage = new DefaultFixMessage();
        private final Set<String> exemptGenerators = new LinkedHashSet<String>(DependencyModule.access$100());

        public DependencyModule build() {
            return new DependencyModule(this.strictJavaDeps, this.fixDepsTool, this.directJars, this.strictClasspathMode, this.depsArtifacts, this.platformJars, this.targetLabel, this.outputDepsProtoFile, this.fixMessage, this.exemptGenerators);
        }

        @CanIgnoreReturnValue
        public Builder setStrictJavaDeps(String strictJavaDeps) {
            this.strictJavaDeps = StrictJavaDeps.valueOf(strictJavaDeps);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFixDepsTool(FixTool fixDepsTool) {
            this.fixDepsTool = fixDepsTool;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTargetLabel(String targetLabel) {
            this.targetLabel = targetLabel;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDirectJars(ImmutableSet<Path> directJars) {
            this.directJars = directJars;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOutputDepsProtoFile(Path outputDepsProtoFile) {
            this.outputDepsProtoFile = outputDepsProtoFile;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addDepsArtifacts(Collection<Path> depsArtifacts) {
            this.depsArtifacts.addAll(depsArtifacts);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPlatformJars(ImmutableSet<Path> platformJars) {
            this.platformJars = platformJars;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReduceClasspath() {
            this.strictClasspathMode = true;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFixMessage(FixMessage fixMessage) {
            this.fixMessage = fixMessage;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addExemptGenerator(String exemptGenerator) {
            this.exemptGenerators.add(exemptGenerator);
            return this;
        }

        private static class DefaultFixMessage
        implements FixMessage {
            private DefaultFixMessage() {
            }

            @Override
            public String get(Iterable<JarOwner> missing, String recipient) {
                ImmutableSet missingTargets = Streams.stream(missing).flatMap(owner -> owner.label().map(Stream::of).orElse(Stream.empty())).collect(ImmutableSet.toImmutableSet());
                if (missingTargets.isEmpty()) {
                    return "";
                }
                return String.format("%1$s ** Please add the following dependencies:%2$s \n  %3$s to %4$s \n%1$s ** You can use the following buildozer command:%2$s \nbuildozer 'add deps %3$s' %4$s \n\n", "\u001b[35m\u001b[1m", "\u001b[0m", Joiner.on(" ").join(missingTargets), recipient);
            }
        }
    }

    public static interface FixTool {
        public Optional<String> resolveMissingImport(Diagnostic<JavaFileObject> var1, ImmutableList<String> var2);

        public String getFixCommand(Iterable<String> var1, String var2);
    }

    public static interface FixMessage {
        public String get(Iterable<JarOwner> var1, String var2);
    }

    public static enum StrictJavaDeps {
        OFF,
        WARN,
        ERROR;

    }
}

