/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class WerrorCustomOption {
    private static final String WERROR = "-Werror:";
    private final ImmutableMap<String, Boolean> werrors;

    public WerrorCustomOption(ImmutableMap<String, Boolean> werrors) {
        this.werrors = werrors;
    }

    public boolean isEnabled(String lintCategory) {
        boolean all = this.werrors.containsKey("all");
        return this.werrors.getOrDefault(lintCategory, all);
    }

    static WerrorCustomOption create(String arg) {
        return new Builder(ImmutableList.of()).process(arg).build();
    }

    public String toString() {
        if (this.werrors.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, Boolean> werrors = new LinkedHashMap<String, Boolean>(this.werrors);
        StringBuilder sb = new StringBuilder(WERROR);
        if (werrors.containsKey("all")) {
            boolean b = (Boolean)werrors.remove("all");
            sb.append(b ? "" : "-").append("all,");
        }
        for (String warning : werrors.keySet()) {
            boolean b = (Boolean)werrors.get(warning);
            sb.append(b ? "" : "-").append(warning).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    static class Builder {
        private final ImmutableList<String> warningsAsErrorsDefault;
        private final Map<String, Boolean> werrors = new LinkedHashMap<String, Boolean>();

        Builder(ImmutableList<String> warningsAsErrorsDefault) {
            this.warningsAsErrorsDefault = warningsAsErrorsDefault;
            for (String errorWarning : warningsAsErrorsDefault) {
                this.werrors.put(errorWarning, true);
            }
        }

        @CanIgnoreReturnValue
        Builder all() {
            this.werrors.clear();
            this.werrors.put("all", true);
            return this;
        }

        @CanIgnoreReturnValue
        Builder process(String flag) {
            Preconditions.checkArgument(flag.startsWith(WerrorCustomOption.WERROR), flag);
            for (String arg : Splitter.on(',').split(flag.substring(WerrorCustomOption.WERROR.length()))) {
                String warning;
                if (arg.equals("+all") || arg.equals("all")) {
                    this.werrors.clear();
                    this.werrors.put("all", true);
                    continue;
                }
                if (arg.equals("-all") || arg.equals("none")) {
                    this.werrors.clear();
                    this.werrors.put("none", true);
                    for (String errorWarning : this.warningsAsErrorsDefault) {
                        this.werrors.put(errorWarning, true);
                    }
                    continue;
                }
                if (arg.startsWith("-")) {
                    warning = arg.substring(1);
                    if (this.warningsAsErrorsDefault.contains(warning)) continue;
                    this.werrors.put(warning, false);
                    continue;
                }
                warning = arg.startsWith("+") ? arg.substring(1) : arg;
                this.werrors.put(warning, true);
            }
            return this;
        }

        WerrorCustomOption build() {
            return new WerrorCustomOption(ImmutableMap.copyOf(this.werrors));
        }
    }
}

