/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.devtools.build.buildjar.javac.AutoValue_JavacOptions_FilteredJavacopts;
import com.google.devtools.build.buildjar.javac.WerrorCustomOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class JavacOptions {
    private final ImmutableList<JavacOptionNormalizer> normalizers;

    public static ImmutableList<String> removeBazelSpecificFlags(String[] javacopts) {
        return JavacOptions.removeBazelSpecificFlags(Arrays.asList(javacopts));
    }

    public static ImmutableList<String> removeBazelSpecificFlags(Iterable<String> javacopts) {
        return JavacOptions.filterJavacopts(javacopts).standardJavacopts();
    }

    public static FilteredJavacopts filterJavacopts(Iterable<String> javacopts) {
        ImmutableList.Builder bazelJavacopts = ImmutableList.builder();
        ImmutableList.Builder standardJavacopts = ImmutableList.builder();
        for (String opt : javacopts) {
            if (JavacOptions.isBazelSpecificFlag(opt)) {
                bazelJavacopts.add(opt);
                continue;
            }
            standardJavacopts.add(opt);
        }
        return FilteredJavacopts.create((ImmutableList<String>)bazelJavacopts.build(), (ImmutableList<String>)standardJavacopts.build());
    }

    private static boolean isBazelSpecificFlag(String opt) {
        return opt.startsWith("-Werror:") || opt.startsWith("-Xep");
    }

    JavacOptions(ImmutableList<JavacOptionNormalizer> normalizers) {
        this.normalizers = normalizers;
    }

    public List<String> normalize(List<String> javacopts) {
        ArrayList<String> normalized = new ArrayList<String>();
        Iterator<String> it = javacopts.iterator();
        while (it.hasNext()) {
            String opt = it.next();
            boolean found = false;
            for (JavacOptionNormalizer normalizer : this.normalizers) {
                if (!normalizer.processOption(opt, it)) continue;
                found = true;
                break;
            }
            if (found) continue;
            normalized.add(opt);
        }
        for (JavacOptionNormalizer normalizer : this.normalizers) {
            normalizer.normalize(normalized);
        }
        return normalized;
    }

    public static List<String> normalizeOptionsWithNormalizers(List<String> javacopts, JavacOptionNormalizer ... normalizers) {
        return new JavacOptions(ImmutableList.copyOf(normalizers)).normalize(javacopts);
    }

    public static JavacOptions createWithWarningsAsErrorsDefault(ImmutableList<String> warningsAsErrorsDefault) {
        return new JavacOptions(ImmutableList.of(new XlintOptionNormalizer(warningsAsErrorsDefault), new WErrorOptionNormalizer(warningsAsErrorsDefault), new ReleaseOptionNormalizer(), new ParameterOptionNormalizer()));
    }

    static final class ParameterOptionNormalizer
    implements JavacOptionNormalizer {
        private static final String PARAMETERS = "-parameters";
        private boolean parameters = false;

        ParameterOptionNormalizer() {
        }

        @Override
        public boolean processOption(String option, Iterator<String> remaining) {
            switch (option) {
                case "-XDnoparameters": {
                    this.parameters = false;
                    return true;
                }
                case "-parameters": {
                    this.parameters = true;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void normalize(List<String> normalized) {
            if (this.parameters) {
                normalized.add(PARAMETERS);
            }
        }
    }

    private static final class WErrorOptionNormalizer
    implements JavacOptionNormalizer {
        private final WerrorCustomOption.Builder builder;

        WErrorOptionNormalizer(ImmutableList<String> warningsAsErrorsDefault) {
            this.builder = new WerrorCustomOption.Builder(warningsAsErrorsDefault);
        }

        @Override
        public boolean processOption(String option, Iterator<String> remaining) {
            if (option.startsWith("-Werror:")) {
                this.builder.process(option);
                return true;
            }
            if (option.equals("-Werror")) {
                this.builder.all();
                return true;
            }
            return false;
        }

        @Override
        public void normalize(List<String> normalized) {
            String flag = this.builder.build().toString();
            if (!flag.isEmpty()) {
                normalized.add(flag);
            }
        }
    }

    public static class ReleaseOptionNormalizer
    implements JavacOptionNormalizer {
        private String source;
        private String target;
        private String release;
        private final List<String> modular = new ArrayList<String>();
        private boolean preview = false;

        @Override
        public boolean processOption(String option, Iterator<String> remaining) {
            switch (option) {
                case "-source": {
                    if (remaining.hasNext()) {
                        this.source = remaining.next();
                        this.release = null;
                    }
                    return true;
                }
                case "-target": {
                    if (remaining.hasNext()) {
                        this.target = remaining.next();
                        this.release = null;
                    }
                    return true;
                }
                case "--release": {
                    if (remaining.hasNext()) {
                        this.release = remaining.next();
                        this.source = null;
                        this.target = null;
                    }
                    return true;
                }
                case "--add-exports": 
                case "--add-opens": 
                case "--add-modules": {
                    if (remaining.hasNext()) {
                        this.modular.add(option);
                        this.modular.add(remaining.next());
                    }
                    return true;
                }
            }
            if (option.startsWith("--release=")) {
                this.release = option.substring("--release=".length());
                this.source = null;
                this.target = null;
                return true;
            }
            if (option.startsWith("--add-exports=") || option.startsWith("--add-opens=") || option.startsWith("--add-modules=")) {
                this.modular.add(option);
                return true;
            }
            if (option.equals("--enable-preview")) {
                this.preview = true;
                return true;
            }
            return false;
        }

        private void addModular(List<String> normalized) {
            String value;
            if (this.release != null) {
                value = this.release;
            } else if (this.target != null) {
                value = this.target;
            } else {
                return;
            }
            boolean hasPrefix = value.startsWith("1.");
            Integer version = Ints.tryParse(hasPrefix ? value.substring("1.".length()) : value);
            if (version == null) {
                return;
            }
            if (version > 8) {
                normalized.addAll(this.modular);
                if (this.preview) {
                    normalized.add("--enable-preview");
                }
            }
        }

        @Override
        public void normalize(List<String> normalized) {
            this.addModular(normalized);
            if (this.release != null) {
                normalized.add("--release");
                normalized.add(this.release);
            } else {
                if (this.source != null) {
                    normalized.add("-source");
                    normalized.add(this.source);
                }
                if (this.target != null) {
                    normalized.add("-target");
                    normalized.add(this.target);
                }
            }
        }
    }

    public static final class XlintOptionNormalizer
    implements JavacOptionNormalizer {
        private static final Joiner COMMA_MINUS_JOINER = Joiner.on(",-");
        private static final Joiner COMMA_JOINER = Joiner.on(",");
        private final ImmutableList<String> enforcedXlints;
        private final Set<String> xlintPlus;
        private final Set<String> xlintMinus = new LinkedHashSet<String>();
        private BasisXlintSelection xlintBasis = BasisXlintSelection.Empty;

        public XlintOptionNormalizer() {
            this(ImmutableList.of());
        }

        public XlintOptionNormalizer(ImmutableList<String> enforcedXlints) {
            this.enforcedXlints = enforcedXlints;
            this.xlintPlus = new LinkedHashSet<String>(enforcedXlints);
            this.resetBasisTo(BasisXlintSelection.Empty);
        }

        @Override
        public boolean processOption(String option, Iterator<String> remaining) {
            if (option.equals("-nowarn")) {
                this.resetBasisTo(BasisXlintSelection.None);
                return true;
            }
            if (option.equals("-Xlint")) {
                this.resetBasisTo(BasisXlintSelection.Recommended);
                return true;
            }
            if (option.startsWith("-Xlint")) {
                for (String arg : option.substring("-Xlint:".length()).split(",", -1)) {
                    if (arg.equals("all") || arg.isEmpty()) {
                        this.resetBasisTo(BasisXlintSelection.All);
                        continue;
                    }
                    if (arg.equals("none")) {
                        this.resetBasisTo(BasisXlintSelection.None);
                        continue;
                    }
                    if (arg.startsWith("-")) {
                        if (this.enforcedXlints.contains(arg = arg.substring("-".length()))) continue;
                        this.xlintPlus.remove(arg);
                        if (this.xlintBasis == BasisXlintSelection.None) continue;
                        this.xlintMinus.add(arg);
                        continue;
                    }
                    this.xlintMinus.remove(arg);
                    if (this.xlintBasis == BasisXlintSelection.All) continue;
                    this.xlintPlus.add(arg);
                }
                return true;
            }
            return false;
        }

        @Override
        public void normalize(List<String> normalized) {
            switch (this.xlintBasis) {
                case Recommended: {
                    normalized.add("-Xlint");
                    break;
                }
                case All: {
                    normalized.add("-Xlint:all");
                    break;
                }
                case None: {
                    if (!this.xlintPlus.isEmpty()) break;
                    normalized.add("-Xlint:none");
                    break;
                }
            }
            if (this.xlintBasis != BasisXlintSelection.All && !this.xlintPlus.isEmpty()) {
                normalized.add("-Xlint:" + COMMA_JOINER.join(this.xlintPlus));
            }
            if (this.xlintBasis != BasisXlintSelection.None && !this.xlintMinus.isEmpty()) {
                normalized.add("-Xlint:-" + COMMA_MINUS_JOINER.join(this.xlintMinus));
            }
        }

        private void resetBasisTo(BasisXlintSelection selection) {
            this.xlintBasis = selection;
            this.xlintPlus.clear();
            this.xlintMinus.clear();
            if (selection != BasisXlintSelection.All) {
                this.xlintPlus.addAll(this.enforcedXlints);
            }
        }

        private static enum BasisXlintSelection {
            None,
            All,
            Recommended,
            Empty;

        }
    }

    public static interface JavacOptionNormalizer {
        public boolean processOption(String var1, Iterator<String> var2);

        public void normalize(List<String> var1);
    }

    @AutoValue
    public static abstract class FilteredJavacopts {
        public abstract ImmutableList<String> bazelJavacopts();

        public abstract ImmutableList<String> standardJavacopts();

        public static FilteredJavacopts create(ImmutableList<String> bazelJavacopts, ImmutableList<String> standardJavacopts) {
            return new AutoValue_JavacOptions_FilteredJavacopts(bazelJavacopts, standardJavacopts);
        }
    }
}

