/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.common.collect.ImmutableList;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.Log;
import java.util.Locale;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class FormattedDiagnostic
implements Diagnostic<JavaFileObject> {
    public final Diagnostic<? extends JavaFileObject> diagnostic;
    public final String formatted;
    public final String lintCategory;

    public FormattedDiagnostic(Diagnostic<? extends JavaFileObject> diagnostic, String formatted, String lintCategory) {
        this.diagnostic = diagnostic;
        this.formatted = formatted;
        this.lintCategory = lintCategory;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getLintCategory() {
        return this.lintCategory;
    }

    public String toString() {
        return this.formatted;
    }

    @Override
    public Diagnostic.Kind getKind() {
        return this.diagnostic.getKind();
    }

    @Override
    public JavaFileObject getSource() {
        return this.diagnostic.getSource();
    }

    @Override
    public long getPosition() {
        return this.diagnostic.getPosition();
    }

    @Override
    public long getStartPosition() {
        return this.diagnostic.getStartPosition();
    }

    @Override
    public long getEndPosition() {
        return this.diagnostic.getEndPosition();
    }

    @Override
    public long getLineNumber() {
        return this.diagnostic.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        return this.diagnostic.getColumnNumber();
    }

    @Override
    public String getCode() {
        return this.diagnostic.getCode();
    }

    @Override
    public String getMessage(Locale locale) {
        return this.diagnostic.getMessage(locale);
    }

    public boolean isJSpecifyDiagnostic() {
        return this.getKind().equals((Object)Diagnostic.Kind.ERROR) && this.getCode().equals("compiler.err.proc.messager") && this.getMessage(Locale.ENGLISH).startsWith("[nullness] ");
    }

    static class FailFastException
    extends RuntimeException {
        FailFastException(String message) {
            super(message);
        }
    }

    @ClientCodeWrapper.Trusted
    static class Listener
    implements DiagnosticListener<JavaFileObject> {
        private final ImmutableList.Builder<FormattedDiagnostic> diagnostics = ImmutableList.builder();
        private final boolean failFast;
        private final Context context;

        Listener(boolean failFast, Context context) {
            this.failFast = failFast;
            this.context = context;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            DiagnosticFormatter<JCDiagnostic> formatter = Log.instance(this.context).getDiagnosticFormatter();
            Locale locale = JavacMessages.instance(this.context).getCurrentLocale();
            String formatted = formatter.format((JCDiagnostic)diagnostic, locale);
            Lint.LintCategory lintCategory = ((JCDiagnostic)diagnostic).getLintCategory();
            FormattedDiagnostic formattedDiagnostic = new FormattedDiagnostic(diagnostic, formatted, lintCategory != null ? lintCategory.option : null);
            this.diagnostics.add((Object)formattedDiagnostic);
            if (this.failFast && diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR)) {
                throw new FailFastException(formatted);
            }
        }

        ImmutableList<FormattedDiagnostic> build() {
            return this.diagnostics.build();
        }
    }
}

