/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.javac.WorkerCancellationRegistry;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.util.Context;

public class CancelCompilerPlugin
extends BlazeJavaCompilerPlugin
implements TaskListener {
    private final int requestId;
    private final WorkerCancellationRegistry cancellationRegistry;

    public CancelCompilerPlugin(int requestId, WorkerCancellationRegistry cancellationRegistry) {
        this.requestId = requestId;
        this.cancellationRegistry = cancellationRegistry;
    }

    @Override
    public void initializeContext(Context context) {
        super.initializeContext(context);
        MultiTaskListener.instance(context).add(this);
    }

    @Override
    public void processArgs(ImmutableList<String> standardJavacopts, ImmutableList<String> blazeJavacopts) throws InvalidCommandLineException {
        this.cancelRequest();
    }

    @Override
    public void postAttribute(Env<AttrContext> env) {
        this.cancelRequest();
    }

    @Override
    public void postFlow(Env<AttrContext> env) {
        this.cancelRequest();
    }

    @Override
    public void started(TaskEvent e) {
        this.cancelRequest();
    }

    @Override
    public void finished(TaskEvent e) {
        this.cancelRequest();
    }

    private void cancelRequest() {
        if (this.cancellationRegistry.checkIfRequestIsCancelled(this.requestId)) {
            throw new CancelRequestException();
        }
    }

    public static class CancelRequestException
    extends RuntimeException {
    }
}

