/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.buildjar.javac.AutoValue_BootClassPathCachingFileManager_Key;
import com.google.devtools.build.buildjar.javac.BlazeJavacArguments;
import com.google.protobuf.ByteString;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.tools.StandardLocation;

@VisibleForTesting
class BootClassPathCachingFileManager
extends JavacFileManager {
    private final Key key;

    public BootClassPathCachingFileManager(Context context, Key key) {
        super(context, false, StandardCharsets.UTF_8);
        this.key = key;
        try {
            this.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, key.bootJarsAndDigest().keySet());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Key getKey() {
        return this.key;
    }

    @VisibleForTesting
    static boolean areArgumentsValid(BlazeJavacArguments arguments) {
        if (arguments.bootClassPath().isEmpty()) {
            return false;
        }
        for (Path bootClassPath : arguments.bootClassPath()) {
            ByteString currDigest = arguments.inputsAndDigest().get(bootClassPath.toString());
            if (currDigest != null) continue;
            return false;
        }
        return true;
    }

    @AutoValue
    public static abstract class Key {
        static Key create(BlazeJavacArguments arguments) {
            ImmutableMap.Builder<Path, ByteString> bootClasspathsBuilder = ImmutableMap.builder();
            for (Path bootClassPath : arguments.bootClassPath()) {
                bootClasspathsBuilder.put(bootClassPath, arguments.inputsAndDigest().get(bootClassPath.toString()));
            }
            return new AutoValue_BootClassPathCachingFileManager_Key(bootClasspathsBuilder.buildOrThrow());
        }

        abstract ImmutableMap<Path, ByteString> bootJarsAndDigest();
    }
}

