/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.javac.BlazeJavaCompiler;
import com.google.devtools.build.buildjar.javac.FormattedDiagnostic;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import javax.annotation.Nullable;

public class BlazeJavacResult {
    private final Status status;
    private final ImmutableList<FormattedDiagnostic> diagnostics;
    private final String output;
    private final BlazeJavaCompiler compiler;
    private final BlazeJavacStatistics statistics;

    public static BlazeJavacResult ok() {
        return BlazeJavacResult.createFullResult(Status.OK, ImmutableList.of(), "", null, BlazeJavacStatistics.empty());
    }

    public static BlazeJavacResult error(String message) {
        return BlazeJavacResult.createFullResult(Status.ERROR, ImmutableList.of(), message, null, BlazeJavacStatistics.empty());
    }

    public static BlazeJavacResult cancelled(String message) {
        return BlazeJavacResult.createFullResult(Status.CANCELLED, ImmutableList.of(), message, null, BlazeJavacStatistics.empty());
    }

    public static BlazeJavacResult fallback() {
        return BlazeJavacResult.createFullResult(Status.REQUIRES_FALLBACK, ImmutableList.of(), "", null, BlazeJavacStatistics.empty());
    }

    public BlazeJavacResult withStatistics(BlazeJavacStatistics statistics) {
        return new BlazeJavacResult(this.status, this.diagnostics, this.output, this.compiler, statistics);
    }

    private BlazeJavacResult(Status status, ImmutableList<FormattedDiagnostic> diagnostics, String output, @Nullable BlazeJavaCompiler compiler, BlazeJavacStatistics statistics) {
        this.status = status;
        this.diagnostics = diagnostics;
        this.output = output;
        this.compiler = compiler;
        this.statistics = statistics;
    }

    public static BlazeJavacResult createFullResult(Status status, ImmutableList<FormattedDiagnostic> diagnostics, String output, BlazeJavaCompiler compiler, BlazeJavacStatistics statistics) {
        return new BlazeJavacResult(status, diagnostics, output, compiler, statistics);
    }

    public boolean isOk() {
        return this.status == Status.OK;
    }

    public Status status() {
        return this.status;
    }

    public ImmutableList<FormattedDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public String output() {
        return this.output;
    }

    public BlazeJavacStatistics statistics() {
        return this.statistics;
    }

    @VisibleForTesting
    public BlazeJavaCompiler compiler() {
        return this.compiler;
    }

    public static enum Status {
        OK,
        ERROR,
        CRASH,
        REQUIRES_FALLBACK,
        CANCELLED;

    }
}

