/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.javac.BlazeJavaCompiler;
import com.google.devtools.build.buildjar.javac.BlazeJavacArguments;
import com.google.devtools.build.buildjar.javac.BlazeJavacResult;
import com.google.devtools.build.buildjar.javac.BootClassPathCachingFileManager;
import com.google.devtools.build.buildjar.javac.CancelCompilerPlugin;
import com.google.devtools.build.buildjar.javac.FormattedDiagnostic;
import com.google.devtools.build.buildjar.javac.WerrorCustomOption;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class BlazeJavacMain {
    private static final ImmutableSet<String> IGNORED_DIAGNOSTIC_CODES = ImmutableSet.of("compiler.note.deprecated.filename", "compiler.note.deprecated.plural", "compiler.note.deprecated.recompile", "compiler.note.deprecated.filename.additional", "compiler.note.deprecated.plural.additional", "compiler.note.unchecked.filename", new String[]{"compiler.note.unchecked.plural", "compiler.note.unchecked.recompile", "compiler.note.unchecked.filename.additional", "compiler.note.unchecked.plural.additional", "compiler.warn.sun.proprietary", "compiler.warn.proc.unmatched.processor.options", "compiler.warn.big.major.version", "compiler.warn.proc.processor.incompatible.source.version", "compiler.warn.unknown.enum.constant", "compiler.warn.unknown.enum.constant.reason"});
    private static final boolean BOOT_CLASSPATH_CACHE_ENABLED = Boolean.parseBoolean(System.getProperty("com.google.devtools.build.buildjar.javac.enable_boot_classpath_cache", "true"));
    private static final Map<BootClassPathCachingFileManager.Key, BootClassPathCachingFileManager> bootFileManagers = new HashMap<BootClassPathCachingFileManager.Key, BootClassPathCachingFileManager>();

    @VisibleForTesting
    static void setupBlazeJavaCompiler(ImmutableList<BlazeJavaCompilerPlugin> plugins, Context context) {
        for (BlazeJavaCompilerPlugin plugin : plugins) {
            plugin.initializeContext(context);
        }
        BlazeJavaCompiler.preRegister(context, plugins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlazeJavacResult compile(BlazeJavacArguments arguments) {
        BlazeJavaCompiler compiler;
        Optional<WerrorCustomOption> maybeWerrorCustom;
        ImmutableList<String> javacArguments = arguments.javacOptions();
        try {
            BlazeJavacMain.processPluginArgs(arguments.plugins(), arguments.javacOptions(), arguments.blazeJavacOptions());
        }
        catch (CancelCompilerPlugin.CancelRequestException e) {
            return BlazeJavacResult.cancelled(e.getMessage());
        }
        catch (InvalidCommandLineException e) {
            return BlazeJavacResult.error(e.getMessage());
        }
        Context context = new Context();
        BlazeJavacStatistics.preRegister(context);
        CacheFSInfo.preRegister(context);
        BlazeJavacMain.setupBlazeJavaCompiler(arguments.plugins(), context);
        BlazeJavacStatistics.Builder builder = context.get(BlazeJavacStatistics.Builder.class);
        BlazeJavacResult.Status status = BlazeJavacResult.Status.ERROR;
        StringWriter errOutput = new StringWriter();
        PrintWriter errWriter = new PrintWriter(errOutput);
        FormattedDiagnostic.Listener diagnosticsBuilder = new FormattedDiagnostic.Listener(arguments.failFast(), context);
        context.put(DiagnosticListener.class, diagnosticsBuilder);
        Log.instance(context).setWriters(errWriter);
        Options options = Options.instance(context);
        options.put("-Xlint:path", "path");
        options.put("expandJarClassPaths", "false");
        try (ClassloaderMaskingFileManager fileManager = new ClassloaderMaskingFileManager(context, arguments.builtinProcessors(), BlazeJavacMain.getMatchingBootFileManager(arguments));){
            BlazeJavacMain.setLocations(fileManager, arguments);
            JavacTask task = JavacTool.create().getTask(errWriter, fileManager, diagnosticsBuilder, javacArguments, ImmutableList.of(), fileManager.getJavaFileObjectsFromPaths((Iterable<? extends Path>)arguments.sourceFiles()), context);
            try {
                status = BlazeJavacMain.fromResult(((JavacTaskImpl)task).doCall());
            }
            catch (PropagatedException e) {
                throw e.getCause();
            }
        }
        catch (Exception t2) {
            if (t2.getCause() instanceof CancelCompilerPlugin.CancelRequestException) {
                BlazeJavacResult task = BlazeJavacResult.cancelled(t2.getCause().getMessage());
                return task;
            }
            t2.printStackTrace(errWriter);
            status = BlazeJavacResult.Status.CRASH;
        }
        finally {
            BlazeJavaCompiler compiler2 = (BlazeJavaCompiler)JavaCompiler.instance(context);
            if (status == BlazeJavacResult.Status.OK && compiler2.skippedFlowEvents() > 0 && compiler2.flowEvents() == 0) {
                errWriter.println("Expected at least one FLOW event");
                status = BlazeJavacResult.Status.ERROR;
            }
        }
        errWriter.flush();
        ImmutableList<FormattedDiagnostic> diagnostics = diagnosticsBuilder.build();
        boolean werror = diagnostics.stream().anyMatch(d -> d.getCode().equals("compiler.err.warnings.and.werror"));
        if (status.equals((Object)BlazeJavacResult.Status.OK) && (maybeWerrorCustom = arguments.blazeJavacOptions().stream().filter(arg -> arg.startsWith("-Werror:")).collect(MoreCollectors.toOptional()).map(WerrorCustomOption::create)).isPresent()) {
            WerrorCustomOption werrorCustom = maybeWerrorCustom.get();
            if (diagnostics.stream().anyMatch(d -> BlazeJavacMain.isWerror(werrorCustom, d))) {
                errOutput.append("error: warnings found and -Werror specified\n");
                status = BlazeJavacResult.Status.ERROR;
                werror = true;
            }
        }
        return BlazeJavacResult.createFullResult(status, BlazeJavacMain.filterDiagnostics(werror, diagnostics), errOutput.toString(), compiler, builder.build());
    }

    private static BlazeJavacResult.Status fromResult(Main.Result result) {
        switch (result) {
            case OK: {
                return BlazeJavacResult.Status.OK;
            }
            case ERROR: 
            case CMDERR: 
            case SYSERR: {
                return BlazeJavacResult.Status.ERROR;
            }
            case ABNORMAL: {
                return BlazeJavacResult.Status.CRASH;
            }
        }
        throw new AssertionError((Object)result);
    }

    private static boolean isWerror(WerrorCustomOption werrorCustom, FormattedDiagnostic diagnostic) {
        switch (diagnostic.getKind()) {
            case WARNING: 
            case MANDATORY_WARNING: {
                return werrorCustom.isEnabled(diagnostic.getLintCategory());
            }
        }
        return false;
    }

    private static ImmutableList<FormattedDiagnostic> filterDiagnostics(boolean werror, ImmutableList<FormattedDiagnostic> diagnostics) {
        return diagnostics.stream().filter(d -> BlazeJavacMain.shouldReportDiagnostic(werror, d)).sorted(Comparator.comparing(FormattedDiagnostic::getKind).reversed()).collect(ImmutableList.toImmutableList());
    }

    private static boolean shouldReportDiagnostic(boolean werror, FormattedDiagnostic diagnostic) {
        if (!IGNORED_DIAGNOSTIC_CODES.contains(diagnostic.getCode())) {
            return true;
        }
        return werror && diagnostic.getKind() != Diagnostic.Kind.NOTE;
    }

    @VisibleForTesting
    static void processPluginArgs(ImmutableList<BlazeJavaCompilerPlugin> plugins, ImmutableList<String> standardJavacopts, ImmutableList<String> blazeJavacopts) throws InvalidCommandLineException {
        for (BlazeJavaCompilerPlugin plugin : plugins) {
            plugin.processArgs(standardJavacopts, blazeJavacopts);
        }
    }

    private static void setLocations(JavacFileManager fileManager, BlazeJavacArguments arguments) {
        try {
            ImmutableList<Path> bootClassPath;
            ImmutableList moduleInfos;
            ImmutableList<Path> sourcePath;
            fileManager.setLocationFromPaths(StandardLocation.CLASS_PATH, arguments.classPath());
            fileManager.setLocationFromPaths(StandardLocation.locationFor("MODULE_PATH"), arguments.classPath());
            fileManager.setLocationFromPaths(StandardLocation.CLASS_OUTPUT, ImmutableList.of(arguments.classOutput()));
            if (arguments.nativeHeaderOutput() != null) {
                fileManager.setLocationFromPaths(StandardLocation.NATIVE_HEADER_OUTPUT, ImmutableList.of(arguments.nativeHeaderOutput()));
            }
            if ((sourcePath = arguments.sourcePath()).isEmpty() && (moduleInfos = arguments.sourceFiles().stream().filter(f -> f.getFileName().toString().equals("module-info.java")).collect(ImmutableList.toImmutableList())).size() == 1) {
                sourcePath = ImmutableList.of(((Path)Iterables.getOnlyElement(moduleInfos)).getParent());
            }
            fileManager.setLocationFromPaths(StandardLocation.SOURCE_PATH, sourcePath);
            Path system = arguments.system();
            if (system != null) {
                fileManager.setLocationFromPaths(StandardLocation.locationFor("SYSTEM_MODULES"), ImmutableList.of(system));
            }
            if (!(bootClassPath = arguments.bootClassPath()).isEmpty()) {
                fileManager.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, bootClassPath);
            }
            fileManager.setLocationFromPaths(StandardLocation.ANNOTATION_PROCESSOR_PATH, arguments.processorPath());
            if (arguments.sourceOutput() != null) {
                fileManager.setLocationFromPaths(StandardLocation.SOURCE_OUTPUT, ImmutableList.of(arguments.sourceOutput()));
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Nullable
    private static synchronized BootClassPathCachingFileManager getMatchingBootFileManager(BlazeJavacArguments arguments) {
        if (!BOOT_CLASSPATH_CACHE_ENABLED) {
            return null;
        }
        if (!arguments.requestId().isPresent()) {
            return null;
        }
        if (!BootClassPathCachingFileManager.areArgumentsValid(arguments)) {
            return null;
        }
        BootClassPathCachingFileManager.Key key = BootClassPathCachingFileManager.Key.create(arguments);
        return bootFileManagers.computeIfAbsent(key, x -> new BootClassPathCachingFileManager(new Context(), key));
    }

    private BlazeJavacMain() {
    }

    @ClientCodeWrapper.Trusted
    private static class ClassloaderMaskingFileManager
    extends JavacFileManager {
        private final ImmutableSet<String> builtinProcessors;
        private final BootClassPathCachingFileManager bootFileManger;

        public ClassloaderMaskingFileManager(Context context, ImmutableSet<String> builtinProcessors, BootClassPathCachingFileManager bootFileManager) {
            super(context, true, StandardCharsets.UTF_8);
            this.builtinProcessors = builtinProcessors;
            this.bootFileManger = bootFileManager;
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            if (this.bootFileManger != null && location == StandardLocation.PLATFORM_CLASS_PATH) {
                return this.bootFileManger.list(location, packageName, kinds, recurse);
            }
            return super.list(location, packageName, kinds, recurse);
        }

        @Override
        protected ClassLoader getClassLoader(URL[] urls) {
            return new URLClassLoader(urls, new ClassLoader(ClassLoader.getPlatformClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    if (name.startsWith("com.google.errorprone.") || name.startsWith("com.google.common.collect.") || name.startsWith("com.google.common.base.") || name.startsWith("com.google.common.graph.") || name.startsWith("org.checkerframework.shaded.dataflow.") || name.startsWith("org.checkerframework.errorprone.dataflow.") || name.startsWith("com.sun.source.") || name.startsWith("com.sun.tools.") || name.startsWith("com.google.devtools.build.buildjar.javac.statistics.") || name.startsWith("dagger.model.") || name.startsWith("dagger.spi.") && !name.startsWith("dagger.spi.model.") || builtinProcessors.contains(name)) {
                        return Class.forName(name);
                    }
                    throw new ClassNotFoundException(name);
                }
            });
        }
    }
}

