/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.javac;

import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class BlazeJavaCompiler
extends JavaCompiler {
    private int skippedFlowEvents = 0;
    private int flowEvents = 0;
    private final List<BlazeJavaCompilerPlugin> plugins = new ArrayList<BlazeJavaCompilerPlugin>();

    private BlazeJavaCompiler(Context context, Iterable<BlazeJavaCompilerPlugin> plugins) {
        super(context);
        BlazeJavacStatistics.Builder statisticsBuilder = context.get(BlazeJavacStatistics.Builder.class);
        for (BlazeJavaCompilerPlugin plugin : plugins) {
            plugin.init(context, this.log, this, statisticsBuilder);
            this.plugins.add(plugin);
        }
    }

    public static void preRegister(Context context, final Iterable<BlazeJavaCompilerPlugin> plugins) {
        context.put(compilerKey, new Context.Factory<JavaCompiler>(){
            boolean first = true;

            @Override
            public JavaCompiler make(Context c) {
                if (!this.first) {
                    throw new AssertionError((Object)"Expected a single creation of BlazeJavaCompiler.");
                }
                this.first = false;
                return new BlazeJavaCompiler(c, plugins);
            }
        });
    }

    @Override
    public Env<AttrContext> attribute(Env<AttrContext> env) {
        Env<AttrContext> result = super.attribute(env);
        boolean errors = this.errorCount() > 0;
        for (BlazeJavaCompilerPlugin plugin : this.plugins) {
            if (errors && !plugin.runOnAttributionErrors()) continue;
            plugin.postAttribute(result);
        }
        return result;
    }

    @Override
    protected void flow(Env<AttrContext> env, Queue<Env<AttrContext>> results) {
        boolean isDone = this.compileStates.isDone(env, CompileStates.CompileState.FLOW);
        super.flow(env, results);
        if (isDone) {
            return;
        }
        if (this.errorCount() > 0) {
            ++this.skippedFlowEvents;
            return;
        }
        ++this.flowEvents;
        for (BlazeJavaCompilerPlugin plugin : this.plugins) {
            plugin.postFlow(env);
        }
    }

    @Override
    public void close() {
        for (BlazeJavaCompilerPlugin plugin : this.plugins) {
            plugin.finish();
        }
        this.plugins.clear();
        super.close();
    }

    public int skippedFlowEvents() {
        return this.skippedFlowEvents;
    }

    public int flowEvents() {
        return this.flowEvents;
    }

    boolean pluginsContain(Class<? extends BlazeJavaCompilerPlugin> klass) {
        for (BlazeJavaCompilerPlugin plugin : this.plugins) {
            if (!klass.isInstance(plugin)) continue;
            return true;
        }
        return false;
    }
}

