/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.jarhelper;

import com.google.devtools.build.buildjar.jarhelper.JarHelper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarCreator
extends JarHelper {
    private final TreeMap<String, Path> jarEntries = new TreeMap();
    private String manifestFile;
    private String mainClass;
    private String targetLabel;
    private String injectingRuleKind;

    @Deprecated
    public JarCreator(String fileName) {
        this(Paths.get(fileName, new String[0]));
    }

    public JarCreator(Path path) {
        super(path);
    }

    public boolean addEntry(String entryName, Path path) {
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        } else if (entryName.length() >= 3 && Character.isLetter(entryName.charAt(0)) && entryName.charAt(1) == ':' && (entryName.charAt(2) == '\\' || entryName.charAt(2) == '/')) {
            entryName = entryName.substring(3);
        } else if (entryName.startsWith("./")) {
            entryName = entryName.substring(2);
        }
        return this.jarEntries.put(entryName, path) == null;
    }

    public boolean addEntry(String entryName, String fileName) {
        return this.addEntry(entryName, Paths.get(fileName, new String[0]));
    }

    @Deprecated
    public void addDirectory(String directory) {
        this.addDirectory(Paths.get(directory, new String[0]));
    }

    public void addDirectory(final Path directory) {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new IllegalArgumentException("directory does not exist: " + directory);
        }
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    if (!path.equals(directory)) {
                        this.addEntry(path, true);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    this.addEntry(path, false);
                    return FileVisitResult.CONTINUE;
                }

                void addEntry(Path path, boolean isDirectory) {
                    StringBuilder sb = new StringBuilder();
                    boolean first = true;
                    for (Path entry : directory.relativize(path)) {
                        if (!first) {
                            sb.append('/');
                        }
                        sb.append(entry.getFileName());
                        first = false;
                    }
                    if (isDirectory) {
                        sb.append('/');
                    }
                    JarCreator.this.jarEntries.put(sb.toString(), path);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setJarOwner(String targetLabel, String injectingRuleKind) {
        this.targetLabel = targetLabel;
        this.injectingRuleKind = injectingRuleKind;
    }

    public void setManifestFile(String manifestFile) {
        this.manifestFile = manifestFile;
    }

    private byte[] manifestContent() throws IOException {
        if (this.manifestFile != null) {
            try (FileInputStream in = new FileInputStream(this.manifestFile);){
                byte[] byArray = this.manifestContentImpl(new Manifest(in));
                return byArray;
            }
        }
        return this.manifestContentImpl(new Manifest());
    }

    private byte[] manifestContentImpl(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Attributes.Name createdBy = new Attributes.Name("Created-By");
        if (attributes.getValue(createdBy) == null) {
            attributes.put(createdBy, "bazel");
        }
        if (this.mainClass != null) {
            attributes.put(Attributes.Name.MAIN_CLASS, this.mainClass);
        }
        if (this.targetLabel != null) {
            attributes.put(JarHelper.TARGET_LABEL, this.targetLabel);
        }
        if (this.injectingRuleKind != null) {
            attributes.put(JarHelper.INJECTING_RULE_KIND, this.injectingRuleKind);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        return out.toByteArray();
    }

    public void execute() throws IOException {
        try (OutputStream os = Files.newOutputStream(this.jarPath, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);
             JarOutputStream out = new JarOutputStream(bos);){
            this.writeManifestEntry(out, this.manifestContent());
            for (Map.Entry<String, Path> entry : this.jarEntries.entrySet()) {
                this.copyEntry(out, entry.getKey(), entry.getValue());
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("usage: CreateJar output [root directories]");
            System.exit(1);
        }
        String output = args[0];
        JarCreator createJar = new JarCreator(output);
        for (int i = 1; i < args.length; ++i) {
            createJar.addDirectory(args[i]);
        }
        createJar.setCompression(true);
        createJar.setNormalize(true);
        createJar.setVerbose(true);
        long start = System.currentTimeMillis();
        try {
            createJar.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        long stop = System.currentTimeMillis();
        System.err.println(stop - start + "ms.");
    }
}

