/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar.instrumentation;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.JavaLibraryBuildRequest;
import com.google.devtools.build.buildjar.jarhelper.JarCreator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public final class JacocoInstrumentationProcessor {
    private Path instrumentedClassesDirectory;
    private final String coverageInformation;
    private final boolean isNewCoverageImplementation;

    public static JacocoInstrumentationProcessor create(List<String> args) throws InvalidCommandLineException {
        if (args.size() < 1) {
            throw new InvalidCommandLineException("Number of arguments for Jacoco instrumentation should be 1+ (given " + args.size() + ": metadataOutput [filters*].");
        }
        return new JacocoInstrumentationProcessor(args.get(0));
    }

    private JacocoInstrumentationProcessor(String coverageInfo) {
        this.coverageInformation = coverageInfo;
        this.isNewCoverageImplementation = coverageInfo.endsWith(".txt");
    }

    public boolean isNewCoverageImplementation() {
        return this.isNewCoverageImplementation;
    }

    public void processRequest(JavaLibraryBuildRequest build, JarCreator jar) throws IOException {
        this.instrumentedClassesDirectory = JacocoInstrumentationProcessor.getMetadataDirRelativeToJar(build.getOutputJar());
        Files.createDirectories(this.instrumentedClassesDirectory, new FileAttribute[0]);
        if (jar == null) {
            jar = new JarCreator(this.coverageInformation);
        }
        jar.setNormalize(true);
        jar.setCompression(build.compressJar());
        Instrumenter instr = new Instrumenter(new OfflineInstrumentationAccessGenerator());
        this.instrumentRecursively(instr, build.getClassDir());
        jar.addDirectory(this.instrumentedClassesDirectory);
        if (this.isNewCoverageImplementation) {
            jar.addEntry(this.coverageInformation, this.coverageInformation);
        } else {
            jar.execute();
            this.cleanup();
        }
    }

    public void cleanup() throws IOException {
        if (Files.exists(this.instrumentedClassesDirectory, new LinkOption[0])) {
            MoreFiles.deleteRecursively(this.instrumentedClassesDirectory, RecursiveDeleteOption.ALLOW_INSECURE);
        }
    }

    private static Path getMetadataDirRelativeToJar(Path outputJar) {
        return outputJar.resolveSibling(outputJar + "-coverage-metadata");
    }

    private void instrumentRecursively(final Instrumenter instr, final Path root) throws IOException {
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path uninstrumentedCopy;
                if (!file.getFileName().toString().endsWith(".class")) {
                    return FileVisitResult.CONTINUE;
                }
                Path instrumentedCopy = file;
                if (JacocoInstrumentationProcessor.this.isNewCoverageImplementation) {
                    Path absoluteUninstrumentedCopy = Paths.get(file + ".uninstrumented", new String[0]);
                    uninstrumentedCopy = JacocoInstrumentationProcessor.this.instrumentedClassesDirectory.resolve(root.relativize(absoluteUninstrumentedCopy));
                } else {
                    uninstrumentedCopy = JacocoInstrumentationProcessor.this.instrumentedClassesDirectory.resolve(root.relativize(file));
                }
                Files.createDirectories(uninstrumentedCopy.getParent(), new FileAttribute[0]);
                Files.move(file, uninstrumentedCopy, new CopyOption[0]);
                try (BufferedInputStream input = new BufferedInputStream(Files.newInputStream(uninstrumentedCopy, new OpenOption[0]));
                     BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(instrumentedCopy, new OpenOption[0]));){
                    instr.instrument(input, output, file.toString());
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

