/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.base.CharMatcher;
import com.google.common.io.ByteStreams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.devtools.build.buildjar.JavaLibraryBuildRequest;
import com.google.devtools.build.buildjar.instrumentation.JacocoInstrumentationProcessor;
import com.google.devtools.build.buildjar.jarhelper.JarCreator;
import com.google.devtools.build.buildjar.javac.BlazeJavacMain;
import com.google.devtools.build.buildjar.javac.BlazeJavacResult;
import com.google.devtools.build.buildjar.javac.JavacRunner;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;

public class SimpleJavaLibraryBuilder
implements Closeable {
    private static final String PROTOBUF_META_NAME = "protobuf.meta";

    BlazeJavacResult compileSources(JavaLibraryBuildRequest build, JavacRunner javacRunner) throws IOException {
        BlazeJavacResult result = javacRunner.invokeJavac(build.toBlazeJavacArguments(build.getClassPath()));
        BlazeJavacStatistics.Builder stats = result.statistics().toBuilder().transitiveClasspathLength(build.getClassPath().size()).reducedClasspathLength(build.getClassPath().size()).transitiveClasspathFallback(false);
        build.getProcessors().stream().map(p -> p.substring(p.lastIndexOf(46) + 1)).forEachOrdered(stats::addProcessor);
        return result.withStatistics(stats.build());
    }

    protected void prepareSourceCompilation(JavaLibraryBuildRequest build) throws IOException {
        SimpleJavaLibraryBuilder.cleanupDirectory(build.getClassDir());
        this.setUpSourceJars(build);
        SimpleJavaLibraryBuilder.cleanupDirectory(build.getSourceGenDir());
        SimpleJavaLibraryBuilder.cleanupDirectory(build.getNativeHeaderDir());
    }

    private static void cleanupDirectory(@Nullable Path directory) throws IOException {
        if (directory == null) {
            return;
        }
        if (Files.exists(directory, new LinkOption[0])) {
            try {
                MoreFiles.deleteRecursively(directory, RecursiveDeleteOption.ALLOW_INSECURE);
            }
            catch (IOException e) {
                throw new IOException("Cannot clean '" + directory + "'", e);
            }
        }
        Files.createDirectories(directory, new FileAttribute[0]);
    }

    public void buildGensrcJar(JavaLibraryBuildRequest build) throws IOException {
        JarCreator jar = new JarCreator(build.getGeneratedSourcesOutputJar());
        try {
            jar.setNormalize(true);
            jar.setCompression(build.compressJar());
            jar.addDirectory(build.getSourceGenDir());
        }
        finally {
            jar.execute();
        }
    }

    private BlazeJavacResult compileJavaLibrary(JavaLibraryBuildRequest build) throws Exception {
        this.prepareSourceCompilation(build);
        if (build.getSourceFiles().isEmpty()) {
            return BlazeJavacResult.ok();
        }
        return this.compileSources(build, BlazeJavacMain::compile);
    }

    @CheckReturnValue
    public BlazeJavacResult run(JavaLibraryBuildRequest build) throws Exception {
        BlazeJavacResult result = BlazeJavacResult.error("");
        try {
            result = this.compileJavaLibrary(build);
            if (result.isOk()) {
                this.buildJar(build);
                this.nativeHeaderOutput(build);
            }
            if (!build.getProcessors().isEmpty() && build.getGeneratedSourcesOutputJar() != null) {
                this.buildGensrcJar(build);
            }
            build.getDependencyModule().emitDependencyInformation(build.getClassPath(), result.isOk(), result.status() == BlazeJavacResult.Status.REQUIRES_FALLBACK);
        }
        catch (Throwable throwable) {
            build.getDependencyModule().emitDependencyInformation(build.getClassPath(), result.isOk(), result.status() == BlazeJavacResult.Status.REQUIRES_FALLBACK);
            build.getProcessingModule().emitManifestProto();
            throw throwable;
        }
        build.getProcessingModule().emitManifestProto();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildJar(JavaLibraryBuildRequest build) throws IOException {
        Files.createDirectories(build.getOutputJar().getParent(), new FileAttribute[0]);
        JarCreator jar = new JarCreator(build.getOutputJar());
        JacocoInstrumentationProcessor processor = null;
        try {
            jar.setNormalize(true);
            jar.setCompression(build.compressJar());
            jar.addDirectory(build.getClassDir());
            jar.setJarOwner(build.getTargetLabel(), build.getInjectingRuleKind());
            processor = build.getJacocoInstrumentationProcessor();
            if (processor != null) {
                processor.processRequest(build, processor.isNewCoverageImplementation() ? jar : null);
            }
        }
        finally {
            jar.execute();
            if (processor != null) {
                processor.cleanup();
            }
        }
    }

    public void nativeHeaderOutput(JavaLibraryBuildRequest build) throws IOException {
        if (build.getNativeHeaderOutput() == null) {
            return;
        }
        JarCreator jar = new JarCreator(build.getNativeHeaderOutput());
        try {
            jar.setNormalize(true);
            jar.setCompression(build.compressJar());
            jar.addDirectory(build.getNativeHeaderDir());
        }
        finally {
            jar.execute();
        }
    }

    private void setUpSourceJars(JavaLibraryBuildRequest build) throws IOException {
        Path sourcesDir = build.getTempDir();
        SimpleJavaLibraryBuilder.cleanupDirectory(sourcesDir);
        if (build.getSourceJars().isEmpty()) {
            return;
        }
        ByteArrayOutputStream protobufMetadataBuffer = new ByteArrayOutputStream();
        for (Path sourceJar : build.getSourceJars()) {
            try (JarFile jarFile = new JarFile(sourceJar.toFile());){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String fileName = entry.getName();
                    if (fileName.endsWith(".java")) {
                        if (fileName.charAt(0) == '/') {
                            fileName = CharMatcher.is('/').trimLeadingFrom(fileName);
                        }
                        Path to = sourcesDir.resolve(fileName);
                        int root = 1;
                        if (Files.exists(to, new LinkOption[0])) {
                            while (Files.exists(to = sourcesDir.resolve(Integer.toString(root++)).resolve(fileName), new LinkOption[0])) {
                            }
                        }
                        Files.createDirectories(to.getParent(), new FileAttribute[0]);
                        Files.copy(jarFile.getInputStream(entry), to, new CopyOption[0]);
                        build.getSourceFiles().add(to);
                        continue;
                    }
                    if (!fileName.equals(PROTOBUF_META_NAME)) continue;
                    ByteStreams.copy(jarFile.getInputStream(entry), protobufMetadataBuffer);
                }
            }
            catch (IOException e) {
                throw new IOException("unable to open " + sourceJar + " as a jar file", e);
            }
        }
        Path output = build.getClassDir().resolve(PROTOBUF_META_NAME);
        if (protobufMetadataBuffer.size() > 0) {
            try (OutputStream outputStream = Files.newOutputStream(output, new OpenOption[0]);){
                protobufMetadataBuffer.writeTo(outputStream);
            }
        } else if (Files.exists(output, new LinkOption[0])) {
            Files.delete(output);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

