/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.JavaLibraryBuildRequest;
import com.google.devtools.build.buildjar.OptionsParser;
import com.google.devtools.build.buildjar.SimpleJavaLibraryBuilder;
import com.google.devtools.build.buildjar.javac.BlazeJavacResult;
import com.google.devtools.build.buildjar.javac.JavacRunner;
import com.google.devtools.build.buildjar.javac.statistics.BlazeJavacStatistics;
import java.io.IOException;
import java.nio.file.Path;

public class ReducedClasspathJavaLibraryBuilder
extends SimpleJavaLibraryBuilder {
    @Override
    BlazeJavacResult compileSources(JavaLibraryBuildRequest build, JavacRunner javacRunner) throws IOException {
        BlazeJavacResult result;
        boolean fallback;
        ImmutableList<Path> compressedClasspath = build.getClassPath();
        if (!build.getSourceFiles().isEmpty() && build.reduceClasspathMode() == OptionsParser.ReduceClasspathMode.JAVABUILDER_REDUCED) {
            compressedClasspath = build.getDependencyModule().computeStrictClasspath(build.getClassPath());
        }
        if (fallback = ReducedClasspathJavaLibraryBuilder.shouldFallBack(result = javacRunner.invokeJavac(build.toBlazeJavacArguments(compressedClasspath)))) {
            if (build.reduceClasspathMode() == OptionsParser.ReduceClasspathMode.BAZEL_REDUCED) {
                return BlazeJavacResult.fallback();
            }
            if (build.reduceClasspathMode() == OptionsParser.ReduceClasspathMode.JAVABUILDER_REDUCED) {
                result = this.fallback(build, javacRunner);
            }
        }
        BlazeJavacStatistics.Builder stats = result.statistics().toBuilder().minClasspathLength(build.getDependencyModule().getImplicitDependenciesMap().size());
        build.getProcessors().stream().map(p -> p.substring(p.lastIndexOf(46) + 1)).forEachOrdered(stats::addProcessor);
        switch (build.reduceClasspathMode()) {
            case BAZEL_REDUCED: 
            case BAZEL_FALLBACK: {
                stats.transitiveClasspathLength(build.fullClasspathLength());
                stats.reducedClasspathLength(build.reducedClasspathLength());
                stats.transitiveClasspathFallback(build.reduceClasspathMode() == OptionsParser.ReduceClasspathMode.BAZEL_FALLBACK);
                break;
            }
            case JAVABUILDER_REDUCED: {
                stats.transitiveClasspathLength(build.getClassPath().size());
                stats.reducedClasspathLength(compressedClasspath.size());
                stats.transitiveClasspathFallback(fallback);
                break;
            }
            default: {
                throw new AssertionError((Object)build.reduceClasspathMode());
            }
        }
        return result.withStatistics(stats.build());
    }

    private BlazeJavacResult fallback(JavaLibraryBuildRequest build, JavacRunner javacRunner) throws IOException {
        this.prepareSourceCompilation(build);
        return javacRunner.invokeJavac(build.toBlazeJavacArguments(build.getClassPath()));
    }

    private static boolean shouldFallBack(BlazeJavacResult result) {
        if (result.isOk()) {
            return false;
        }
        if (result.status().equals((Object)BlazeJavacResult.Status.CRASH)) {
            return true;
        }
        return !result.diagnostics().stream().allMatch(d -> d.isJSpecifyDiagnostic());
    }
}

