/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.OptionsParser;
import com.google.devtools.build.buildjar.instrumentation.JacocoInstrumentationProcessor;
import com.google.devtools.build.buildjar.javac.BlazeJavacArguments;
import com.google.devtools.build.buildjar.javac.JavacOptions;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.dependency.DependencyModule;
import com.google.devtools.build.buildjar.javac.plugins.processing.AnnotationProcessingModule;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;

public final class JavaLibraryBuildRequest {
    private ImmutableList<String> javacOpts;
    private final Path sourceGenDir;
    private final Path generatedSourcesOutputJar;
    private final ArrayList<Path> sourceFiles;
    private final ImmutableList<Path> sourceJars;
    private final ImmutableList<Path> sourcePath;
    private final ImmutableList<Path> classPath;
    private final ImmutableList<Path> bootClassPath;
    private final Path system;
    private final ImmutableList<Path> processorPath;
    private final List<String> processorNames;
    private final ImmutableSet<String> builtinProcessorNames;
    private final Path outputJar;
    private final Path nativeHeaderOutput;
    @Nullable
    private final String targetLabel;
    @Nullable
    private final String injectingRuleKind;
    private final Path classDir;
    private final Path tempDir;
    private JacocoInstrumentationProcessor jacocoInstrumentationProcessor;
    private final boolean compressJar;
    private final OptionsParser.ReduceClasspathMode reduceClasspathMode;
    private final int fullClasspathLength;
    private final int reducedClasspathLength;
    private final DependencyModule dependencyModule;
    private final AnnotationProcessingModule processingModule;
    private final ImmutableList<BlazeJavaCompilerPlugin> plugins;
    private final ImmutableMap<String, ByteString> inputsAndDigest;
    private final OptionalInt requestId;

    public JavaLibraryBuildRequest(OptionsParser optionsParser, List<BlazeJavaCompilerPlugin> extraPlugins) throws InvalidCommandLineException, IOException {
        this(optionsParser, extraPlugins, new DependencyModule.Builder());
    }

    public JavaLibraryBuildRequest(OptionsParser optionsParser, List<BlazeJavaCompilerPlugin> extraPlugins, DependencyModule.Builder depsBuilder) throws InvalidCommandLineException, IOException {
        this(optionsParser, extraPlugins, depsBuilder, ImmutableMap.of(), OptionalInt.empty());
    }

    public JavaLibraryBuildRequest(OptionsParser optionsParser, List<BlazeJavaCompilerPlugin> extraPlugins, DependencyModule.Builder depsBuilder, ImmutableMap<String, ByteString> inputsAndDigest, OptionalInt requestId) throws InvalidCommandLineException, IOException {
        depsBuilder.setDirectJars(optionsParser.directJars().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableSet.toImmutableSet()));
        if (optionsParser.getStrictJavaDeps() != null) {
            depsBuilder.setStrictJavaDeps(optionsParser.getStrictJavaDeps());
        }
        if (optionsParser.getOutputDepsProtoFile() != null) {
            depsBuilder.setOutputDepsProtoFile(Paths.get(optionsParser.getOutputDepsProtoFile(), new String[0]));
        }
        depsBuilder.addDepsArtifacts(JavaLibraryBuildRequest.asPaths(optionsParser.getDepsArtifacts()));
        depsBuilder.setPlatformJars(optionsParser.getBootClassPath().stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableSet.toImmutableSet()));
        if (optionsParser.reduceClasspathMode() != OptionsParser.ReduceClasspathMode.NONE) {
            depsBuilder.setReduceClasspath();
        }
        if (optionsParser.getTargetLabel() != null) {
            depsBuilder.setTargetLabel(optionsParser.getTargetLabel());
        }
        this.dependencyModule = depsBuilder.build();
        this.sourceGenDir = JavaLibraryBuildRequest.deriveDirectory(optionsParser.getTargetLabel(), optionsParser.getOutputJar(), "_sources");
        AnnotationProcessingModule.Builder processingBuilder = AnnotationProcessingModule.builder();
        processingBuilder.setSourceGenDir(this.sourceGenDir);
        if (optionsParser.getManifestProtoPath() != null) {
            processingBuilder.setManifestProtoPath(Paths.get(optionsParser.getManifestProtoPath(), new String[0]));
        }
        this.processingModule = processingBuilder.build();
        ImmutableCollection.Builder pluginsBuilder = ImmutableList.builder().add(this.dependencyModule.getPlugin());
        this.processingModule.registerPlugin((ImmutableList.Builder<BlazeJavaCompilerPlugin>)pluginsBuilder);
        ((ImmutableList.Builder)pluginsBuilder).addAll(extraPlugins);
        this.plugins = ((ImmutableList.Builder)pluginsBuilder).build();
        this.compressJar = optionsParser.compressJar();
        this.reduceClasspathMode = optionsParser.reduceClasspathMode();
        this.fullClasspathLength = optionsParser.fullClasspathLength();
        this.reducedClasspathLength = optionsParser.reducedClasspathLength();
        this.sourceFiles = new ArrayList<Path>(JavaLibraryBuildRequest.asPaths(optionsParser.getSourceFiles()));
        this.sourceJars = JavaLibraryBuildRequest.asPaths(optionsParser.getSourceJars());
        this.classPath = JavaLibraryBuildRequest.asPaths(optionsParser.getClassPath());
        this.sourcePath = JavaLibraryBuildRequest.asPaths(optionsParser.getSourcePath());
        this.bootClassPath = JavaLibraryBuildRequest.asPaths(optionsParser.getBootClassPath());
        this.system = JavaLibraryBuildRequest.asPath(optionsParser.getSystem());
        this.processorPath = JavaLibraryBuildRequest.asPaths(optionsParser.getProcessorPath());
        this.processorNames = optionsParser.getProcessorNames();
        this.builtinProcessorNames = ImmutableSet.copyOf(optionsParser.getBuiltinProcessorNames());
        this.classDir = JavaLibraryBuildRequest.deriveDirectory(optionsParser.getTargetLabel(), optionsParser.getOutputJar(), "_classes");
        this.tempDir = JavaLibraryBuildRequest.deriveDirectory(optionsParser.getTargetLabel(), optionsParser.getOutputJar(), "_tmp");
        this.outputJar = JavaLibraryBuildRequest.asPath(optionsParser.getOutputJar());
        this.nativeHeaderOutput = JavaLibraryBuildRequest.asPath(optionsParser.getNativeHeaderOutput());
        block6: for (Map.Entry<String, List<String>> entry : optionsParser.getPostProcessors().entrySet()) {
            switch (entry.getKey()) {
                case "jacoco": {
                    this.jacocoInstrumentationProcessor = JacocoInstrumentationProcessor.create(entry.getValue());
                    continue block6;
                }
            }
            throw new AssertionError((Object)("unsupported post-processor " + entry.getKey()));
        }
        this.javacOpts = ImmutableList.copyOf(optionsParser.getJavacOpts());
        this.generatedSourcesOutputJar = JavaLibraryBuildRequest.asPath(optionsParser.getGeneratedSourcesOutputJar());
        this.targetLabel = optionsParser.getTargetLabel();
        this.injectingRuleKind = optionsParser.getInjectingRuleKind();
        this.inputsAndDigest = inputsAndDigest;
        this.requestId = requestId;
    }

    @VisibleForTesting
    static Path deriveDirectory(String label, String outputJar, String suffix) throws IOException {
        Preconditions.checkArgument(label != null, "--target_label is required");
        Preconditions.checkArgument(outputJar != null, "--output is required");
        Preconditions.checkArgument(label.contains(":"), "--target_label must be a canonical label (containing a `:`)");
        Path path = Paths.get(outputJar, new String[0]);
        String name = MoreFiles.getNameWithoutExtension(path);
        String base = label.substring(label.lastIndexOf(58) + 1);
        return path.resolveSibling("_javac").resolve(base).resolve(name + suffix);
    }

    private static ImmutableList<Path> asPaths(Collection<String> paths) {
        return paths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static Path asPath(@Nullable String path) {
        return path != null ? Paths.get(path, new String[0]) : null;
    }

    public ImmutableList<String> getJavacOpts() {
        return this.javacOpts;
    }

    public Path getSourceGenDir() {
        return this.sourceGenDir;
    }

    public ImmutableList<Path> getSourcePath() {
        return this.sourcePath;
    }

    public Path getGeneratedSourcesOutputJar() {
        return this.generatedSourcesOutputJar;
    }

    public ArrayList<Path> getSourceFiles() {
        return this.sourceFiles;
    }

    public ImmutableList<Path> getSourceJars() {
        return this.sourceJars;
    }

    public ImmutableList<Path> getClassPath() {
        return this.classPath;
    }

    public ImmutableList<Path> getBootClassPath() {
        return this.bootClassPath;
    }

    public Path getSystem() {
        return this.system;
    }

    public ImmutableList<Path> getProcessorPath() {
        return this.processorPath;
    }

    public List<String> getProcessors() {
        return this.processorNames;
    }

    public Path getOutputJar() {
        return this.outputJar;
    }

    public Path getNativeHeaderOutput() {
        return this.nativeHeaderOutput;
    }

    public Path getClassDir() {
        return this.classDir;
    }

    public Path getTempDir() {
        return this.tempDir;
    }

    public Path getNativeHeaderDir() {
        return this.getTempDir().resolve("native_headers");
    }

    public JacocoInstrumentationProcessor getJacocoInstrumentationProcessor() {
        return this.jacocoInstrumentationProcessor;
    }

    public boolean compressJar() {
        return this.compressJar;
    }

    public OptionsParser.ReduceClasspathMode reduceClasspathMode() {
        return this.reduceClasspathMode;
    }

    public int fullClasspathLength() {
        return this.fullClasspathLength;
    }

    public int reducedClasspathLength() {
        return this.reducedClasspathLength;
    }

    public DependencyModule getDependencyModule() {
        return this.dependencyModule;
    }

    public AnnotationProcessingModule getProcessingModule() {
        return this.processingModule;
    }

    public ImmutableList<BlazeJavaCompilerPlugin> getPlugins() {
        return this.plugins;
    }

    public ImmutableMap<String, ByteString> getInputsAndDigest() {
        return this.inputsAndDigest;
    }

    public OptionalInt getRequestId() {
        return this.requestId;
    }

    @Nullable
    public String getTargetLabel() {
        return this.targetLabel;
    }

    @Nullable
    public String getInjectingRuleKind() {
        return this.injectingRuleKind;
    }

    public BlazeJavacArguments toBlazeJavacArguments(ImmutableList<Path> classPath) {
        BlazeJavacArguments.Builder builder = BlazeJavacArguments.builder().classPath(classPath).classOutput(this.getClassDir()).bootClassPath(this.getBootClassPath()).system(this.getSystem()).sourceFiles(ImmutableList.copyOf(this.getSourceFiles())).builtinProcessors(this.builtinProcessorNames).sourcePath(this.getSourcePath()).sourceOutput(this.getSourceGenDir()).processorPath(this.getProcessorPath()).plugins(this.getPlugins()).inputsAndDigest(this.getInputsAndDigest()).requestId(this.getRequestId());
        this.addJavacArguments(builder);
        if (this.reduceClasspathMode.equals((Object)OptionsParser.ReduceClasspathMode.BAZEL_REDUCED) && this.getProcessors().isEmpty()) {
            builder.failFast(this.getProcessors().isEmpty());
        }
        if (this.getNativeHeaderOutput() != null) {
            builder.nativeHeaderOutput(this.getNativeHeaderDir());
        }
        return builder.build();
    }

    void addJavacArguments(BlazeJavacArguments.Builder builder) {
        JavacOptions.FilteredJavacopts filtered = JavacOptions.filterJavacopts(this.getJavacOpts());
        builder.blazeJavacOptions(filtered.bazelJavacopts());
        ImmutableList<String> javacOpts = filtered.standardJavacopts();
        ImmutableList.Builder javacArguments = ImmutableList.builder();
        javacArguments.add("-implicit:none");
        javacArguments.addAll(javacOpts);
        if (!this.getProcessors().isEmpty() && !this.getSourceFiles().isEmpty()) {
            ImmutableSet<String> deduplicatedProcessorNames = ImmutableSet.copyOf(this.getProcessors());
            javacArguments.add("-processor");
            javacArguments.add(Joiner.on(',').join(deduplicatedProcessorNames));
        } else {
            javacArguments.add("-proc:none");
        }
        for (String option : javacOpts) {
            if (option.startsWith("-J") || !option.equals("-processor") && !option.equals("-processorpath")) continue;
            throw new IllegalStateException("Using " + option + " in javacopts is no longer supported. Use a java_plugin() rule instead.");
        }
        builder.javacOptions((ImmutableList<String>)javacArguments.build());
    }
}

