/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.buildjar;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.devtools.build.buildjar.InvalidCommandLineException;
import com.google.devtools.build.buildjar.JavaLibraryBuildRequest;
import com.google.devtools.build.buildjar.OptionsParser;
import com.google.devtools.build.buildjar.ReducedClasspathJavaLibraryBuilder;
import com.google.devtools.build.buildjar.SimpleJavaLibraryBuilder;
import com.google.devtools.build.buildjar.javac.BlazeJavacResult;
import com.google.devtools.build.buildjar.javac.FormattedDiagnostic;
import com.google.devtools.build.buildjar.javac.JavacOptions;
import com.google.devtools.build.buildjar.javac.plugins.BlazeJavaCompilerPlugin;
import com.google.devtools.build.buildjar.javac.plugins.dependency.DependencyModule;
import com.google.devtools.build.buildjar.javac.plugins.errorprone.ErrorPronePlugin;
import com.google.devtools.build.lib.worker.ProtoWorkerMessageProcessor;
import com.google.devtools.build.lib.worker.WorkRequestHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class BazelJavaBuilder {
    private static final String CMDNAME = "BazelJavaBuilder";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BazelJavaBuilder builder = new BazelJavaBuilder();
        if (args.length == 1 && args[0].equals("--persistent_worker")) {
            WorkRequestHandler workerHandler = new WorkRequestHandler.WorkRequestHandlerBuilder(builder::parseAndBuild, System.err, (WorkRequestHandler.WorkerMessageProcessor)new ProtoWorkerMessageProcessor(System.in, System.out)).setCpuUsageBeforeGc(Duration.ofSeconds(10L)).build();
            int exitCode = 1;
            try {
                workerHandler.processRequests();
                exitCode = 0;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            finally {
                System.exit(exitCode);
            }
        } else {
            int returnCode;
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, Charset.defaultCharset()));
            try {
                returnCode = builder.parseAndBuild(Arrays.asList(args), pw);
            }
            finally {
                pw.flush();
            }
            System.exit(returnCode);
        }
    }

    public int parseAndBuild(List<String> args, PrintWriter pw) {
        int n;
        block9: {
            JavaLibraryBuildRequest build = this.parse(args);
            SimpleJavaLibraryBuilder builder = build.getDependencyModule().reduceClasspath() ? new ReducedClasspathJavaLibraryBuilder() : new SimpleJavaLibraryBuilder();
            try {
                n = this.build(builder, build, pw);
                if (builder == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCommandLineException e) {
                    pw.println("BazelJavaBuilder threw exception: " + e.getMessage());
                    return 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 1;
                }
            }
            builder.close();
        }
        return n;
    }

    protected int build(SimpleJavaLibraryBuilder builder, JavaLibraryBuildRequest buildRequest, Writer err) throws Exception {
        BlazeJavacResult result = builder.run(buildRequest);
        if (result.status() == BlazeJavacResult.Status.REQUIRES_FALLBACK) {
            return 0;
        }
        for (FormattedDiagnostic d : result.diagnostics()) {
            err.write(d.getFormatted() + "\n");
        }
        err.write(result.output());
        return result.isOk() ? 0 : 1;
    }

    @VisibleForTesting
    public JavaLibraryBuildRequest parse(List<String> args) throws IOException, InvalidCommandLineException {
        OptionsParser optionsParser = new OptionsParser(args, JavacOptions.createWithWarningsAsErrorsDefault(ImmutableList.of()));
        ImmutableList<BlazeJavaCompilerPlugin> plugins = ImmutableList.of(new ErrorPronePlugin());
        return new JavaLibraryBuildRequest(optionsParser, plugins, new DependencyModule.Builder());
    }
}

