/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.memoized.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$GeneratedAnnotationSpecs;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreStreams;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.common.$Visibility;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.base.$Predicates;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$Sets;
import autovalue.shaded.com.squareup.javapoet$.$AnnotationSpec;
import autovalue.shaded.com.squareup.javapoet$.$ClassName;
import autovalue.shaded.com.squareup.javapoet$.$CodeBlock;
import autovalue.shaded.com.squareup.javapoet$.$FieldSpec;
import autovalue.shaded.com.squareup.javapoet$.$JavaFile;
import autovalue.shaded.com.squareup.javapoet$.$MethodSpec;
import autovalue.shaded.com.squareup.javapoet$.$ParameterizedTypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeSpec;
import autovalue.shaded.com.squareup.javapoet$.$TypeVariableName;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.extension.memoized.processor.MemoizedValidator;
import java.lang.annotation.Inherited;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@google..AutoService(value={AutoValueExtension.class})
public final class MemoizeExtension
extends AutoValueExtension {
    private static final $ImmutableSet<String> DO_NOT_PULL_DOWN_ANNOTATIONS = $ImmutableSet.of(Override.class.getCanonicalName(), "com.google.auto.value.extension.memoized.Memoized");
    private static final String AUTO_VALUE_PACKAGE_NAME = "com.google.auto.value.";
    private static final String AUTO_VALUE_NAME = "com.google.auto.value.AutoValue";
    private static final String COPY_ANNOTATIONS_NAME = "com.google.auto.value.AutoValue.CopyAnnotations";
    private static final $ClassName LAZY_INIT = $ClassName.get("com".concat(".google.errorprone.annotations.concurrent"), "LazyInit", new String[0]);
    private static final $AnnotationSpec SUPPRESS_WARNINGS = $AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "Immutable").build();

    @Override
    public AutoValueExtension.IncrementalExtensionType incrementalType(ProcessingEnvironment processingEnvironment) {
        return AutoValueExtension.IncrementalExtensionType.ISOLATING;
    }

    @Override
    public boolean applicable(AutoValueExtension.Context context) {
        return !MemoizeExtension.memoizedMethods(context).isEmpty();
    }

    @Override
    public String generateClass(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        return new Generator(context, className, classToExtend, isFinal).generate();
    }

    private static $ImmutableSet<ExecutableElement> memoizedMethods(AutoValueExtension.Context context) {
        return ElementFilter.methodsIn(context.autoValueClass().getEnclosedElements()).stream().filter(m4 -> MemoizedValidator.getAnnotationMirror(m4, "com.google.auto.value.extension.memoized.Memoized").isPresent()).collect($MoreStreams.toImmutableSet());
    }

    private static Optional<$AnnotationSpec> getLazyInitAnnotation(Elements elements) {
        if (elements.getTypeElement(LAZY_INIT.toString()) == null) {
            return Optional.empty();
        }
        return Optional.of($AnnotationSpec.builder(LAZY_INIT).build());
    }

    private static boolean containsNullable(List<? extends AnnotationMirror> annotations) {
        return annotations.stream().map(a -> a.getAnnotationType().asElement().getSimpleName()).anyMatch(n -> n.contentEquals("Nullable"));
    }

    private static $TypeName annotatedType(TypeMirror type) {
        List<$AnnotationSpec> annotations = type.getAnnotationMirrors().stream().map($AnnotationSpec::get).collect(Collectors.toList());
        return $TypeName.get(type).annotated(annotations);
    }

    static final class Generator {
        private final AutoValueExtension.Context context;
        private final String className;
        private final String classToExtend;
        private final boolean isFinal;
        private final Elements elements;
        private final Types types;
        private final SourceVersion sourceVersion;
        private final Messager messager;
        private final Optional<$AnnotationSpec> lazyInitAnnotation;
        private boolean hasErrors;

        Generator(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
            this.context = context;
            this.className = className;
            this.classToExtend = classToExtend;
            this.isFinal = isFinal;
            this.elements = context.processingEnvironment().getElementUtils();
            this.types = context.processingEnvironment().getTypeUtils();
            this.sourceVersion = context.processingEnvironment().getSourceVersion();
            this.messager = context.processingEnvironment().getMessager();
            this.lazyInitAnnotation = MemoizeExtension.getLazyInitAnnotation(this.elements);
        }

        String generate() {
            $TypeSpec.Builder generated = $TypeSpec.classBuilder(this.className).superclass(this.superType()).addAnnotations(this.copiedClassAnnotations(this.context.autoValueClass())).addTypeVariables(this.annotatedTypeVariableNames()).addModifiers(this.isFinal ? Modifier.FINAL : Modifier.ABSTRACT).addMethod(this.constructor());
            $GeneratedAnnotationSpecs.generatedAnnotationSpec(this.elements, this.sourceVersion, MemoizeExtension.class).ifPresent(generated::addAnnotation);
            for (ExecutableElement method : MemoizeExtension.memoizedMethods(this.context)) {
                MethodOverrider methodOverrider = new MethodOverrider(method);
                generated.addFields(methodOverrider.fields());
                generated.addMethod(methodOverrider.method());
            }
            if (this.isHashCodeMemoized() && !this.isEqualsFinal()) {
                generated.addMethod(this.equalsWithHashCodeCheck());
            }
            if (this.hasErrors) {
                return null;
            }
            return $JavaFile.builder(this.context.packageName(), generated.build()).build().toString();
        }

        private $TypeName superType() {
            $ClassName superType = $ClassName.get(this.context.packageName(), this.classToExtend, new String[0]);
            $ImmutableList<$TypeVariableName> typeVariableNames = this.typeVariableNames();
            return typeVariableNames.isEmpty() ? superType : $ParameterizedTypeName.get(superType, typeVariableNames.toArray(new $TypeName[0]));
        }

        private $ImmutableList<$TypeVariableName> typeVariableNames() {
            return this.context.autoValueClass().getTypeParameters().stream().map($TypeVariableName::get).collect($MoreStreams.toImmutableList());
        }

        private $ImmutableList<$TypeVariableName> annotatedTypeVariableNames() {
            return this.context.autoValueClass().getTypeParameters().stream().map(p -> $TypeVariableName.get(p).annotated((List)p.getAnnotationMirrors().stream().map($AnnotationSpec::get).collect($MoreStreams.toImmutableList()))).collect($MoreStreams.toImmutableList());
        }

        private $MethodSpec constructor() {
            $MethodSpec.Builder constructor = $MethodSpec.constructorBuilder();
            this.context.propertyTypes().forEach((name, type) -> constructor.addParameter(MemoizeExtension.annotatedType(type), name + "$", new Modifier[0]));
            String superParams = this.context.properties().keySet().stream().map(n -> n + "$").collect(Collectors.joining(", "));
            constructor.addStatement("super($L)", superParams);
            return constructor.build();
        }

        private boolean isHashCodeMemoized() {
            return MemoizeExtension.memoizedMethods(this.context).stream().anyMatch(method -> method.getSimpleName().contentEquals("hashCode"));
        }

        private boolean isEqualsFinal() {
            TypeMirror objectType = this.elements.getTypeElement(Object.class.getCanonicalName()).asType();
            ExecutableElement equals = $MoreElements.getLocalAndInheritedMethods(this.context.autoValueClass(), this.types, this.elements).stream().filter(method -> method.getSimpleName().contentEquals("equals")).filter(method -> method.getParameters().size() == 1).filter(method -> this.types.isSameType($Iterables.getOnlyElement(method.getParameters()).asType(), objectType)).findFirst().get();
            return equals.getModifiers().contains((Object)Modifier.FINAL);
        }

        private $MethodSpec equalsWithHashCodeCheck() {
            return $MethodSpec.methodBuilder("equals").addModifiers(Modifier.PUBLIC).returns($TypeName.BOOLEAN).addAnnotation(Override.class).addParameter($TypeName.OBJECT, "that", new Modifier[0]).beginControlFlow("if (this == that)", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().addStatement("return that instanceof $N && this.hashCode() == that.hashCode() && super.equals(that)", this.className).build();
        }

        private boolean isInAutoValuePackage(String className) {
            return className.startsWith(MemoizeExtension.AUTO_VALUE_PACKAGE_NAME) && !className.contains("Test");
        }

        private static String getAnnotationFqName(AnnotationMirror annotation) {
            return ((QualifiedNameable)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
        }

        private boolean annotationVisibleFrom(AnnotationMirror annotation, Element from) {
            Element annotationElement = annotation.getAnnotationType().asElement();
            $Visibility visibility = $Visibility.effectiveVisibilityOfElement(annotationElement);
            switch (visibility) {
                case PUBLIC: {
                    return true;
                }
                case PROTECTED: {
                    return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from)) || this.types.isSubtype(from.asType(), annotationElement.getEnclosingElement().asType());
                }
                case DEFAULT: {
                    return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from));
                }
            }
            return false;
        }

        private $ImmutableList<AnnotationMirror> annotationsToCopy(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
            $ImmutableList.Builder result = $ImmutableList.builder();
            for (AnnotationMirror annotationMirror : typeOrMethod.getAnnotationMirrors()) {
                String annotationFqName = Generator.getAnnotationFqName(annotationMirror);
                if (this.isInAutoValuePackage(annotationFqName) || excludedAnnotations.contains(annotationFqName) || !this.annotationVisibleFrom(annotationMirror, autoValueType)) continue;
                result.add(annotationMirror);
            }
            return result.build();
        }

        private $ImmutableList<$AnnotationSpec> copyAnnotations(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
            $ImmutableList<AnnotationMirror> annotationsToCopy = this.annotationsToCopy(autoValueType, typeOrMethod, excludedAnnotations);
            return annotationsToCopy.stream().map($AnnotationSpec::get).collect($MoreStreams.toImmutableList());
        }

        private static boolean hasAnnotationMirror(Element element, String annotationName) {
            return MemoizedValidator.getAnnotationMirror(element, annotationName).isPresent();
        }

        private $ImmutableSet<TypeMirror> getExcludedAnnotationTypes(Element element) {
            Optional<AnnotationMirror> maybeAnnotation = MemoizedValidator.getAnnotationMirror(element, MemoizeExtension.COPY_ANNOTATIONS_NAME);
            if (!maybeAnnotation.isPresent()) {
                return $ImmutableSet.of();
            }
            List excludedClasses = (List)$AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "exclude").getValue();
            return excludedClasses.stream().map(annotationValue -> $MoreTypes.equivalence().wrap((TypeMirror)annotationValue.getValue())).distinct().map($Equivalence.Wrapper::get).collect($MoreStreams.toImmutableSet());
        }

        private Set<String> getExcludedAnnotationClassNames(Element element) {
            return this.getExcludedAnnotationTypes(element).stream().map($MoreTypes::asTypeElement).map(typeElement -> typeElement.getQualifiedName().toString()).collect(Collectors.toSet());
        }

        private static Set<String> getAnnotationsMarkedWithInherited(Element element) {
            return element.getAnnotationMirrors().stream().filter(a -> $MoreElements.isAnnotationPresent(a.getAnnotationType().asElement(), Inherited.class)).map(Generator::getAnnotationFqName).collect(Collectors.toSet());
        }

        private $ImmutableList<$AnnotationSpec> copiedClassAnnotations(TypeElement type) {
            if (Generator.hasAnnotationMirror(type, MemoizeExtension.COPY_ANNOTATIONS_NAME)) {
                $Sets.SetView<String> excludedAnnotations = $Sets.union(this.getExcludedAnnotationClassNames(type), Generator.getAnnotationsMarkedWithInherited(type));
                return this.copyAnnotations(type, type, excludedAnnotations);
            }
            return $ImmutableList.of();
        }

        private final class MethodOverrider {
            private final ExecutableElement method;
            private final $MethodSpec.Builder override;
            private final $FieldSpec cacheField;
            private final $ImmutableList.Builder<$FieldSpec> fields = $ImmutableList.builder();

            MethodOverrider(ExecutableElement method) {
                this.method = method;
                this.validate();
                this.cacheField = this.buildCacheField(MemoizeExtension.annotatedType(method.getReturnType()), method.getSimpleName().toString());
                this.fields.add((Object)this.cacheField);
                this.override = $MethodSpec.methodBuilder(method.getSimpleName().toString()).addAnnotation(Override.class).returns(this.cacheField.type).addExceptions(method.getThrownTypes().stream().map($TypeName::get).collect(Collectors.toList())).addModifiers($Iterables.filter(method.getModifiers(), $Predicates.not($Predicates.equalTo(Modifier.ABSTRACT))));
                for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                    $AnnotationSpec annotationSpec = $AnnotationSpec.get(annotationMirror);
                    if (!this.pullDownMethodAnnotation(annotationMirror)) continue;
                    this.override.addAnnotation(annotationSpec);
                }
                InitializationStrategy checkStrategy = this.strategy();
                this.fields.addAll((Iterable)checkStrategy.additionalFields());
                this.override.beginControlFlow("if ($L)", checkStrategy.checkMemoized()).beginControlFlow("synchronized (this)", new Object[0]).beginControlFlow("if ($L)", checkStrategy.checkMemoized()).addStatement("$N = super.$L()", this.cacheField, method.getSimpleName()).addCode(checkStrategy.setMemoized()).endControlFlow().endControlFlow().endControlFlow().addStatement("return $N", this.cacheField);
            }

            Iterable<$FieldSpec> fields() {
                return this.fields.build();
            }

            $MethodSpec method() {
                return this.override.build();
            }

            private void validate() {
                if (this.method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot be void", new Object[0]);
                }
                if (!this.method.getParameters().isEmpty()) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot have parameters", new Object[0]);
                }
                this.checkIllegalModifier(Modifier.PRIVATE);
                this.checkIllegalModifier(Modifier.FINAL);
                this.checkIllegalModifier(Modifier.STATIC);
                if (!this.overridesObjectMethod("hashCode") && !this.overridesObjectMethod("toString")) {
                    this.checkIllegalModifier(Modifier.ABSTRACT);
                }
            }

            private void checkIllegalModifier(Modifier modifier) {
                if (this.method.getModifiers().contains((Object)modifier)) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot be %s", modifier.toString());
                }
            }

            @google..FormatMethod
            private void printMessage(Diagnostic.Kind kind, String format, Object ... args) {
                if (kind.equals((Object)Diagnostic.Kind.ERROR)) {
                    Generator.this.hasErrors = true;
                }
                Generator.this.messager.printMessage(kind, String.format(format, args), this.method);
            }

            private boolean overridesObjectMethod(String methodName) {
                return Generator.this.elements.overrides(this.method, this.objectMethod(methodName), Generator.this.context.autoValueClass());
            }

            private ExecutableElement objectMethod(String methodName) {
                TypeElement object = Generator.this.elements.getTypeElement(Object.class.getName());
                return ElementFilter.methodsIn(object.getEnclosedElements()).stream().filter(m4 -> m4.getSimpleName().contentEquals(methodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No method in Object named \"%s\"", methodName)));
            }

            private boolean pullDownMethodAnnotation(AnnotationMirror annotation) {
                return !DO_NOT_PULL_DOWN_ANNOTATIONS.contains($MoreElements.asType(annotation.getAnnotationType().asElement()).getQualifiedName().toString());
            }

            private $FieldSpec buildCacheField($TypeName type, String name) {
                $FieldSpec.Builder builder = $FieldSpec.builder(type, name, Modifier.PRIVATE, Modifier.TRANSIENT, Modifier.VOLATILE);
                if (Generator.this.lazyInitAnnotation.isPresent()) {
                    builder.addAnnotation(($AnnotationSpec)Generator.this.lazyInitAnnotation.get());
                    builder.addAnnotation(SUPPRESS_WARNINGS);
                }
                return builder.build();
            }

            InitializationStrategy strategy() {
                if (this.method.getReturnType().getKind().isPrimitive()) {
                    return new CheckBooleanField();
                }
                if (MemoizeExtension.containsNullable(this.method.getAnnotationMirrors()) || MemoizeExtension.containsNullable(this.method.getReturnType().getAnnotationMirrors())) {
                    return new CheckBooleanField();
                }
                return new NullMeansUninitialized();
            }

            private final class CheckBooleanField
            extends InitializationStrategy {
                private final $FieldSpec field;

                private CheckBooleanField() {
                    this.field = MethodOverrider.this.buildCacheField($TypeName.BOOLEAN, MethodOverrider.this.method.getSimpleName() + "$Memoized");
                }

                @Override
                Iterable<$FieldSpec> additionalFields() {
                    return $ImmutableList.of(this.field);
                }

                @Override
                $CodeBlock checkMemoized() {
                    return $CodeBlock.of("!$N", this.field);
                }

                @Override
                $CodeBlock setMemoized() {
                    return $CodeBlock.builder().addStatement("$N = true", this.field).build();
                }
            }

            private final class NullMeansUninitialized
            extends InitializationStrategy {
                private NullMeansUninitialized() {
                }

                @Override
                Iterable<$FieldSpec> additionalFields() {
                    return $ImmutableList.of();
                }

                @Override
                $CodeBlock checkMemoized() {
                    return $CodeBlock.of("$N == null", MethodOverrider.this.cacheField);
                }

                @Override
                $CodeBlock setMemoized() {
                    return $CodeBlock.builder().beginControlFlow("if ($N == null)", MethodOverrider.this.cacheField).addStatement("throw new NullPointerException($S)", MethodOverrider.this.method.getSimpleName() + "() cannot return null").endControlFlow().build();
                }
            }

            private abstract class InitializationStrategy {
                private InitializationStrategy() {
                }

                abstract Iterable<$FieldSpec> additionalFields();

                abstract $CodeBlock checkMemoized();

                abstract $CodeBlock setMemoized();
            }
        }
    }
}

