/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.common.base;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.common.annotations.$GwtCompatible;
import autovalue.shaded.com.google$.common.base.$Function;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.errorprone.annotations.$CanIgnoreReturnValue;
import autovalue.shaded.com.google$.errorprone.annotations.$ForOverride;
import autovalue.shaded.com.google$.errorprone.annotations.concurrent.$LazyInit;
import autovalue.shaded.org.checkerframework;
import java.io.Serializable;
import java.util.Iterator;

@$GwtCompatible
public abstract class $Converter<A, B>
implements $Function<A, B> {
    private final boolean handleNullAutomatically;
    @$LazyInit
    @google..RetainedWith
    private transient @checkerframework..Nullable $Converter<B, A> reverse;

    protected $Converter() {
        this(true);
    }

    $Converter(boolean handleNullAutomatically) {
        this.handleNullAutomatically = handleNullAutomatically;
    }

    @$ForOverride
    protected abstract B doForward(A var1);

    @$ForOverride
    protected abstract A doBackward(B var1);

    @$CanIgnoreReturnValue
    public final @checkerframework..Nullable B convert(@checkerframework..Nullable A a) {
        return this.correctedDoForward(a);
    }

    @checkerframework..Nullable B correctedDoForward(@checkerframework..Nullable A a) {
        if (this.handleNullAutomatically) {
            return a == null ? null : (B)$Preconditions.checkNotNull(this.doForward(a));
        }
        return this.doForward(a);
    }

    @checkerframework..Nullable A correctedDoBackward(@checkerframework..Nullable B b) {
        if (this.handleNullAutomatically) {
            return b == null ? null : (A)$Preconditions.checkNotNull(this.doBackward(b));
        }
        return this.doBackward(b);
    }

    @$CanIgnoreReturnValue
    public Iterable<B> convertAll(final Iterable<? extends A> fromIterable) {
        $Preconditions.checkNotNull(fromIterable, "fromIterable");
        return new Iterable<B>(){

            @Override
            public Iterator<B> iterator() {
                return new Iterator<B>(){
                    private final Iterator<? extends A> fromIterator;
                    {
                        this.fromIterator = fromIterable.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.fromIterator.hasNext();
                    }

                    @Override
                    public B next() {
                        return $Converter.this.convert(this.fromIterator.next());
                    }

                    @Override
                    public void remove() {
                        this.fromIterator.remove();
                    }
                };
            }
        };
    }

    @$CanIgnoreReturnValue
    public $Converter<B, A> reverse() {
        $Converter<A, B> result = this.reverse;
        return result == null ? (this.reverse = new ReverseConverter(this)) : result;
    }

    @Override
    public final <C> $Converter<A, C> andThen($Converter<B, C> secondConverter) {
        return this.doAndThen(secondConverter);
    }

    <C> $Converter<A, C> doAndThen($Converter<B, C> secondConverter) {
        return new ConverterComposition(this, $Preconditions.checkNotNull(secondConverter));
    }

    @Override
    @Deprecated
    @$CanIgnoreReturnValue
    public final @checkerframework..Nullable B apply(@checkerframework..Nullable A a) {
        return this.convert(a);
    }

    @Override
    public boolean equals(@checkerframework..Nullable Object object) {
        return super.equals(object);
    }

    public static <A, B> $Converter<A, B> from($Function<? super A, ? extends B> forwardFunction, $Function<? super B, ? extends A> backwardFunction) {
        return new FunctionBasedConverter(forwardFunction, backwardFunction);
    }

    public static <T> $Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }

    private static final class IdentityConverter<T>
    extends $Converter<T, T>
    implements Serializable {
        static final IdentityConverter<?> INSTANCE = new IdentityConverter();
        private static final long serialVersionUID = 0L;

        private IdentityConverter() {
        }

        @Override
        protected T doForward(T t2) {
            return t2;
        }

        @Override
        protected T doBackward(T t2) {
            return t2;
        }

        public IdentityConverter<T> reverse() {
            return this;
        }

        @Override
        <S> $Converter<T, S> doAndThen($Converter<T, S> otherConverter) {
            return $Preconditions.checkNotNull(otherConverter, "otherConverter");
        }

        public String toString() {
            return "Converter.identity()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class FunctionBasedConverter<A, B>
    extends $Converter<A, B>
    implements Serializable {
        private final $Function<? super A, ? extends B> forwardFunction;
        private final $Function<? super B, ? extends A> backwardFunction;

        private FunctionBasedConverter($Function<? super A, ? extends B> forwardFunction, $Function<? super B, ? extends A> backwardFunction) {
            this.forwardFunction = $Preconditions.checkNotNull(forwardFunction);
            this.backwardFunction = $Preconditions.checkNotNull(backwardFunction);
        }

        @Override
        protected B doForward(A a) {
            return this.forwardFunction.apply(a);
        }

        @Override
        protected A doBackward(B b) {
            return this.backwardFunction.apply(b);
        }

        @Override
        public boolean equals(@checkerframework..Nullable Object object) {
            if (object instanceof FunctionBasedConverter) {
                FunctionBasedConverter that = (FunctionBasedConverter)object;
                return this.forwardFunction.equals(that.forwardFunction) && this.backwardFunction.equals(that.backwardFunction);
            }
            return false;
        }

        public int hashCode() {
            return this.forwardFunction.hashCode() * 31 + this.backwardFunction.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.forwardFunction);
            String string2 = String.valueOf(this.backwardFunction);
            return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Converter.from(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    private static final class ConverterComposition<A, B, C>
    extends $Converter<A, C>
    implements Serializable {
        final $Converter<A, B> first;
        final $Converter<B, C> second;
        private static final long serialVersionUID = 0L;

        ConverterComposition($Converter<A, B> first, $Converter<B, C> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        protected C doForward(A a) {
            throw new AssertionError();
        }

        @Override
        protected A doBackward(C c) {
            throw new AssertionError();
        }

        @Override
        @checkerframework..Nullable C correctedDoForward(@checkerframework..Nullable A a) {
            return this.second.correctedDoForward(this.first.correctedDoForward(a));
        }

        @Override
        @checkerframework..Nullable A correctedDoBackward(@checkerframework..Nullable C c) {
            return this.first.correctedDoBackward(this.second.correctedDoBackward(c));
        }

        @Override
        public boolean equals(@checkerframework..Nullable Object object) {
            if (object instanceof ConverterComposition) {
                ConverterComposition that = (ConverterComposition)object;
                return this.first.equals(that.first) && this.second.equals(that.second);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.first.hashCode() + this.second.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.first);
            String string2 = String.valueOf(this.second);
            return new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".andThen(").append(string2).append(")").toString();
        }
    }

    private static final class ReverseConverter<A, B>
    extends $Converter<B, A>
    implements Serializable {
        final $Converter<A, B> original;
        private static final long serialVersionUID = 0L;

        ReverseConverter($Converter<A, B> original) {
            this.original = original;
        }

        @Override
        protected A doForward(B b) {
            throw new AssertionError();
        }

        @Override
        protected B doBackward(A a) {
            throw new AssertionError();
        }

        @Override
        @checkerframework..Nullable A correctedDoForward(@checkerframework..Nullable B b) {
            return this.original.correctedDoBackward(b);
        }

        @Override
        @checkerframework..Nullable B correctedDoBackward(@checkerframework..Nullable A a) {
            return this.original.correctedDoForward(a);
        }

        @Override
        public $Converter<A, B> reverse() {
            return this.original;
        }

        @Override
        public boolean equals(@checkerframework..Nullable Object object) {
            if (object instanceof ReverseConverter) {
                ReverseConverter that = (ReverseConverter)object;
                return this.original.equals(that.original);
            }
            return false;
        }

        public int hashCode() {
            return ~this.original.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.original);
            return new StringBuilder(10 + String.valueOf(string).length()).append(string).append(".reverse()").toString();
        }
    }
}

