/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_43a39aa.output;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import org.jacoco.agent.rt.internal_43a39aa.core.runtime.IRemoteCommandVisitor;
import org.jacoco.agent.rt.internal_43a39aa.core.runtime.RemoteControlReader;
import org.jacoco.agent.rt.internal_43a39aa.core.runtime.RemoteControlWriter;
import org.jacoco.agent.rt.internal_43a39aa.core.runtime.RuntimeData;

class TcpConnection
implements IRemoteCommandVisitor {
    private final RuntimeData data;
    private final Socket socket;
    private RemoteControlWriter writer;
    private RemoteControlReader reader;
    private boolean initialized;

    public TcpConnection(Socket socket, RuntimeData data) {
        this.socket = socket;
        this.data = data;
        this.initialized = false;
    }

    public void init() throws IOException {
        this.writer = new RemoteControlWriter(this.socket.getOutputStream());
        this.reader = new RemoteControlReader(this.socket.getInputStream());
        this.reader.setRemoteCommandVisitor(this);
        this.initialized = true;
    }

    public void run() throws IOException {
        try {
            while (this.reader.read()) {
            }
        }
        catch (SocketException e) {
            if (!this.socket.isClosed()) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    public void writeExecutionData(boolean reset) throws IOException {
        if (this.initialized && !this.socket.isClosed()) {
            this.visitDumpCommand(true, reset);
        }
    }

    public void close() throws IOException {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void visitDumpCommand(boolean dump, boolean reset) throws IOException {
        if (dump) {
            this.data.collect(this.writer, this.writer, reset);
        } else if (reset) {
            this.data.reset();
        }
        this.writer.sendCmdOk();
    }
}

