/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.collect.ImmutableList;
import com.google.turbine.type.Type;

public class Deannotate {
    public static Type deannotate(Type ty) {
        switch (ty.tyKind()) {
            case CLASS_TY: {
                return Deannotate.deannotateClassTy((Type.ClassTy)ty);
            }
            case ARRAY_TY: {
                return Type.ArrayTy.create(Deannotate.deannotate(((Type.ArrayTy)ty).elementType()), ImmutableList.of());
            }
            case INTERSECTION_TY: {
                return Type.IntersectionTy.create(Deannotate.deannotate(((Type.IntersectionTy)ty).bounds()));
            }
            case WILD_TY: {
                return Deannotate.deannotateWildTy((Type.WildTy)ty);
            }
            case METHOD_TY: {
                return Deannotate.deannotateMethodTy((Type.MethodTy)ty);
            }
            case PRIM_TY: {
                return Type.PrimTy.create(((Type.PrimTy)ty).primkind(), ImmutableList.of());
            }
            case TY_VAR: {
                return Type.TyVar.create(((Type.TyVar)ty).sym(), ImmutableList.of());
            }
            case VOID_TY: 
            case ERROR_TY: 
            case NONE_TY: {
                return ty;
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private static ImmutableList<Type> deannotate(ImmutableList<Type> types) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type type : types) {
            result.add(Deannotate.deannotate(type));
        }
        return result.build();
    }

    public static Type.ClassTy deannotateClassTy(Type.ClassTy ty) {
        ImmutableList.Builder classes = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy c : ty.classes()) {
            classes.add(Type.ClassTy.SimpleClassTy.create(c.sym(), Deannotate.deannotate(c.targs()), ImmutableList.of()));
        }
        return Type.ClassTy.create(classes.build());
    }

    private static Type deannotateWildTy(Type.WildTy ty) {
        switch (ty.boundKind()) {
            case NONE: {
                return Type.WildUnboundedTy.create(ImmutableList.of());
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(ty.bound(), ImmutableList.of());
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(ty.bound(), ImmutableList.of());
            }
        }
        throw new AssertionError((Object)ty.boundKind());
    }

    private static Type deannotateMethodTy(Type.MethodTy ty) {
        return Type.MethodTy.create(ty.tyParams(), Deannotate.deannotate(ty.returnType()), ty.receiverType() != null ? Deannotate.deannotate(ty.receiverType()) : null, Deannotate.deannotate(ty.parameters()), Deannotate.deannotate(ty.thrown()));
    }

    private Deannotate() {
    }
}

