/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public class Canonicalize {
    private final SourceFile source;
    private final int position;
    private final Env<ClassSymbol, TypeBoundClass> env;

    public static Type canonicalize(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Type type) {
        return new Canonicalize(source, position, env).canonicalize(sym, type);
    }

    public static Type.ClassTy canonicalizeClassTy(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol owner, Type.ClassTy classTy) {
        return new Canonicalize(source, position, env).canonicalizeClassTy(owner, classTy);
    }

    public Canonicalize(SourceFile source, int position, Env<ClassSymbol, TypeBoundClass> env) {
        this.source = source;
        this.position = position;
        this.env = env;
    }

    private Type canonicalize(ClassSymbol base, Type type) {
        switch (type.tyKind()) {
            case PRIM_TY: 
            case VOID_TY: 
            case TY_VAR: 
            case ERROR_TY: {
                return type;
            }
            case WILD_TY: {
                return this.canonicalizeWildTy(base, (Type.WildTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                return Type.ArrayTy.create(this.canonicalize(base, arrayTy.elementType()), arrayTy.annos());
            }
            case CLASS_TY: {
                return this.canonicalizeClassTy(base, (Type.ClassTy)type);
            }
            case INTERSECTION_TY: {
                return this.canonicalizeIntersectionTy(base, (Type.IntersectionTy)type);
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private Type.ClassTy canon(ClassSymbol base, Type.ClassTy ty) {
        Type.ClassTy canon;
        if (ty.sym().equals(ClassSymbol.ERROR)) {
            return ty;
        }
        if (this.isRaw(ty)) {
            return Erasure.eraseClassTy(ty);
        }
        Iterator it = ty.classes().iterator();
        Collection<Type.ClassTy.SimpleClassTy> lexicalBase = this.lexicalBase(((Type.ClassTy.SimpleClassTy)ty.classes().get(0)).sym(), base);
        Type.ClassTy classTy = canon = !lexicalBase.isEmpty() ? Type.ClassTy.create(lexicalBase) : Type.ClassTy.create(Collections.singletonList((Type.ClassTy.SimpleClassTy)it.next()));
        while (it.hasNext()) {
            canon = this.canonOne(canon, (Type.ClassTy.SimpleClassTy)it.next());
        }
        return canon;
    }

    private boolean isRaw(Type.ClassTy ty) {
        for (Type.ClassTy.SimpleClassTy s : ty.classes().reverse()) {
            TypeBoundClass info = this.getInfo(s.sym());
            if (s.targs().isEmpty() && !info.typeParameters().isEmpty()) {
                return true;
            }
            if ((info.access() & 8) != 8) continue;
            break;
        }
        return false;
    }

    private Collection<Type.ClassTy.SimpleClassTy> lexicalBase(ClassSymbol first, ClassSymbol owner) {
        if ((this.getInfo(first).access() & 8) == 8) {
            return ImmutableList.of();
        }
        ClassSymbol canonOwner = this.getInfo(first).owner();
        ArrayDeque<Type.ClassTy.SimpleClassTy> result = new ArrayDeque<Type.ClassTy.SimpleClassTy>();
        while (canonOwner != null && owner != null) {
            if (!this.isSubclass(owner, canonOwner)) {
                owner = this.getInfo(owner).owner();
                continue;
            }
            result.addFirst(this.uninstantiated(owner));
            if ((this.getInfo(owner).access() & 8) == 8) break;
            canonOwner = this.getInfo(canonOwner).owner();
        }
        return result;
    }

    private Type.ClassTy.SimpleClassTy uninstantiated(ClassSymbol owner) {
        ImmutableList.Builder targs = ImmutableList.builder();
        for (TyVarSymbol p : this.getInfo(owner).typeParameterTypes().keySet()) {
            targs.add(Type.TyVar.create(p, ImmutableList.of()));
        }
        return Type.ClassTy.SimpleClassTy.create(owner, (ImmutableList<Type>)targs.build(), ImmutableList.of());
    }

    private boolean isSubclass(ClassSymbol s, ClassSymbol t) {
        while (s != null) {
            if (s.equals(t)) {
                return true;
            }
            s = this.getInfo(s).superclass();
        }
        return false;
    }

    private Type.ClassTy canonOne(Type.ClassTy base, Type.ClassTy.SimpleClassTy ty) {
        if ((this.getInfo(ty.sym()).access() & 8) == 8) {
            return Type.ClassTy.create(ImmutableList.of(ty));
        }
        ImmutableList.Builder simples = ImmutableList.builder();
        ClassSymbol owner = Objects.requireNonNull(this.getInfo(ty.sym()).owner());
        if (owner.equals(base.sym())) {
            simples.addAll(base.classes());
            simples.add(ty);
            return Type.ClassTy.create(simples.build());
        }
        Type.ClassTy curr = base;
        LinkedHashMap<TyVarSymbol, Type> mapping = new LinkedHashMap<TyVarSymbol, Type>();
        while (curr != null) {
            for (Type.ClassTy.SimpleClassTy s : curr.classes()) {
                this.addInstantiation(mapping, s);
            }
            if (curr.sym().equals(owner)) {
                for (Type.ClassTy.SimpleClassTy s : curr.classes()) {
                    simples.add(this.instantiate(mapping, s.sym()));
                }
                break;
            }
            TypeBoundClass info = this.getInfo(curr.sym());
            curr = this.canon(info.owner(), (Type.ClassTy)info.superClassType());
        }
        simples.add(ty);
        return Type.ClassTy.create(simples.build());
    }

    private void addInstantiation(Map<TyVarSymbol, Type> mapping, Type.ClassTy.SimpleClassTy simpleType) {
        Collection symbols = this.getInfo(simpleType.sym()).typeParameters().values();
        if (simpleType.targs().isEmpty()) {
            for (TyVarSymbol sym : symbols) {
                mapping.put(sym, null);
            }
            return;
        }
        Verify.verify(symbols.size() == simpleType.targs().size());
        Iterator typeArguments = simpleType.targs().iterator();
        for (TyVarSymbol sym : symbols) {
            Type argument = (Type)typeArguments.next();
            if (Objects.equals(Canonicalize.tyVarSym(argument), sym)) continue;
            mapping.put(sym, argument);
        }
    }

    private Type.ClassTy.SimpleClassTy instantiate(Map<TyVarSymbol, Type> mapping, ClassSymbol classSymbol) {
        ArrayList<Type> args = new ArrayList<Type>();
        for (TyVarSymbol sym : this.getInfo(classSymbol).typeParameterTypes().keySet()) {
            if (!mapping.containsKey(sym)) {
                args.add(Type.TyVar.create(sym, ImmutableList.of()));
                continue;
            }
            Type arg = Canonicalize.instantiate(mapping, mapping.get(sym));
            if (arg == null) {
                args.clear();
                break;
            }
            args.add(arg);
        }
        return Type.ClassTy.SimpleClassTy.create(classSymbol, ImmutableList.copyOf(args), ImmutableList.of());
    }

    private static @Nullable Type instantiate(Map<TyVarSymbol, Type> mapping, Type type) {
        if (type == null) {
            return null;
        }
        switch (type.tyKind()) {
            case WILD_TY: {
                return Canonicalize.instantiateWildTy(mapping, (Type.WildTy)type);
            }
            case PRIM_TY: 
            case VOID_TY: 
            case ERROR_TY: {
                return type;
            }
            case CLASS_TY: {
                return Canonicalize.instantiateClassTy(mapping, (Type.ClassTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                Type elem = Canonicalize.instantiate(mapping, arrayTy.elementType());
                return Type.ArrayTy.create(elem, arrayTy.annos());
            }
            case TY_VAR: {
                Type.TyVar tyVar = (Type.TyVar)type;
                if (mapping.containsKey(tyVar.sym())) {
                    return Canonicalize.instantiate(mapping, mapping.get(tyVar.sym()));
                }
                return type;
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private static Type instantiateWildTy(Map<TyVarSymbol, Type> mapping, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(Canonicalize.instantiate(mapping, type.bound()), type.annotations());
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(Canonicalize.instantiate(mapping, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private static Type instantiateClassTy(Map<TyVarSymbol, Type> mapping, Type.ClassTy type) {
        ImmutableList.Builder simples = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy simple : type.classes()) {
            ImmutableList.Builder args = ImmutableList.builder();
            for (Type arg : simple.targs()) {
                args.add(Objects.requireNonNull(Canonicalize.instantiate(mapping, arg)));
            }
            simples.add(Type.ClassTy.SimpleClassTy.create(simple.sym(), (ImmutableList<Type>)args.build(), simple.annos()));
        }
        return Type.ClassTy.create(simples.build());
    }

    private static @Nullable TyVarSymbol tyVarSym(Type type) {
        if (type.tyKind() == Type.TyKind.TY_VAR) {
            return ((Type.TyVar)type).sym();
        }
        return null;
    }

    private Type.ClassTy canonicalizeClassTy(ClassSymbol base, Type.ClassTy ty) {
        ImmutableList.Builder args = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy s : ty.classes()) {
            args.add(Type.ClassTy.SimpleClassTy.create(s.sym(), this.canonicalize(s.targs(), base), s.annos()));
        }
        ty = Type.ClassTy.create(args.build());
        return this.canon(base, ty);
    }

    private ImmutableList<Type> canonicalize(ImmutableList<Type> targs, ClassSymbol base) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type a : targs) {
            result.add(this.canonicalize(base, a));
        }
        return result.build();
    }

    private Type canonicalizeWildTy(ClassSymbol base, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case LOWER: {
                return Type.WildLowerBoundedTy.create(this.canonicalize(base, type.bound()), type.annotations());
            }
            case UPPER: {
                return Type.WildUpperBoundedTy.create(this.canonicalize(base, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private Type canonicalizeIntersectionTy(ClassSymbol base, Type.IntersectionTy type) {
        ImmutableList.Builder bounds = ImmutableList.builder();
        for (Type bound : type.bounds()) {
            bounds.add(this.canonicalize(base, bound));
        }
        return Type.IntersectionTy.create((ImmutableList<Type>)bounds.build());
    }

    private TypeBoundClass getInfo(ClassSymbol canonOwner) {
        TypeBoundClass info = this.env.get(canonOwner);
        if (info == null) {
            throw TurbineError.format(this.source, this.position, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, canonOwner);
        }
        return info;
    }
}

