/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.tree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.tree.Pretty;
import com.google.turbine.tree.TurbineModifier;
import com.google.turbine.tree.TurbineOperatorKind;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jspecify.nullness.Nullable;

public abstract class Tree {
    private final int position;

    public abstract Kind kind();

    public abstract <I, O> O accept(Visitor<I, O> var1, I var2);

    protected Tree(int position) {
        this.position = position;
    }

    public int position() {
        return this.position;
    }

    public String toString() {
        return Pretty.pretty(this);
    }

    public static interface Visitor<I, O> {
        public O visitIdent(Ident var1, I var2);

        public O visitWildTy(WildTy var1, I var2);

        public O visitArrTy(ArrTy var1, I var2);

        public O visitPrimTy(PrimTy var1, I var2);

        public O visitVoidTy(VoidTy var1, I var2);

        public O visitClassTy(ClassTy var1, I var2);

        public O visitLiteral(Literal var1, I var2);

        public O visitParen(Paren var1, I var2);

        public O visitTypeCast(TypeCast var1, I var2);

        public O visitUnary(Unary var1, I var2);

        public O visitBinary(Binary var1, I var2);

        public O visitConstVarName(ConstVarName var1, I var2);

        public O visitClassLiteral(ClassLiteral var1, I var2);

        public O visitAssign(Assign var1, I var2);

        public O visitConditional(Conditional var1, I var2);

        public O visitArrayInit(ArrayInit var1, I var2);

        public O visitCompUnit(CompUnit var1, I var2);

        public O visitImportDecl(ImportDecl var1, I var2);

        public O visitVarDecl(VarDecl var1, I var2);

        public O visitMethDecl(MethDecl var1, I var2);

        public O visitAnno(Anno var1, I var2);

        public O visitTyDecl(TyDecl var1, I var2);

        public O visitTyParam(TyParam var1, I var2);

        public O visitPkgDecl(PkgDecl var1, I var2);

        public O visitModDecl(ModDecl var1, I var2);

        public O visitModRequires(ModRequires var1, I var2);

        public O visitModExports(ModExports var1, I var2);

        public O visitModOpens(ModOpens var1, I var2);

        public O visitModUses(ModUses var1, I var2);

        public O visitModProvides(ModProvides var1, I var2);
    }

    public static class ModProvides
    extends ModDirective {
        private final ImmutableList<Ident> typeName;
        private final ImmutableList<ImmutableList<Ident>> implNames;

        public ModProvides(int position, ImmutableList<Ident> typeName, ImmutableList<ImmutableList<Ident>> implNames) {
            super(position);
            this.typeName = typeName;
            this.implNames = implNames;
        }

        public ImmutableList<Ident> typeName() {
            return this.typeName;
        }

        public ImmutableList<ImmutableList<Ident>> implNames() {
            return this.implNames;
        }

        @Override
        public Kind kind() {
            return Kind.MOD_PROVIDES;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModProvides(this, input);
        }

        @Override
        public ModDirective.DirectiveKind directiveKind() {
            return ModDirective.DirectiveKind.PROVIDES;
        }
    }

    public static class ModUses
    extends ModDirective {
        private final ImmutableList<Ident> typeName;

        public ModUses(int position, ImmutableList<Ident> typeName) {
            super(position);
            this.typeName = typeName;
        }

        public ImmutableList<Ident> typeName() {
            return this.typeName;
        }

        @Override
        public Kind kind() {
            return Kind.MOD_USES;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModUses(this, input);
        }

        @Override
        public ModDirective.DirectiveKind directiveKind() {
            return ModDirective.DirectiveKind.USES;
        }
    }

    public static class ModOpens
    extends ModDirective {
        private final String packageName;
        private final ImmutableList<String> moduleNames;

        public ModOpens(int position, String packageName, ImmutableList<String> moduleNames) {
            super(position);
            this.packageName = packageName;
            this.moduleNames = moduleNames;
        }

        public String packageName() {
            return this.packageName;
        }

        public ImmutableList<String> moduleNames() {
            return this.moduleNames;
        }

        @Override
        public Kind kind() {
            return Kind.MOD_OPENS;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModOpens(this, input);
        }

        @Override
        public ModDirective.DirectiveKind directiveKind() {
            return ModDirective.DirectiveKind.OPENS;
        }
    }

    public static class ModExports
    extends ModDirective {
        private final String packageName;
        private final ImmutableList<String> moduleNames;

        @Override
        public Kind kind() {
            return Kind.MOD_EXPORTS;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModExports(this, input);
        }

        public ModExports(int position, String packageName, ImmutableList<String> moduleNames) {
            super(position);
            this.packageName = packageName;
            this.moduleNames = moduleNames;
        }

        public String packageName() {
            return this.packageName;
        }

        public ImmutableList<String> moduleNames() {
            return this.moduleNames;
        }

        @Override
        public ModDirective.DirectiveKind directiveKind() {
            return ModDirective.DirectiveKind.EXPORTS;
        }
    }

    public static class ModRequires
    extends ModDirective {
        private final ImmutableSet<TurbineModifier> mods;
        private final String moduleName;

        @Override
        public Kind kind() {
            return Kind.MOD_REQUIRES;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModRequires(this, input);
        }

        public ModRequires(int position, ImmutableSet<TurbineModifier> mods, String moduleName) {
            super(position);
            this.mods = mods;
            this.moduleName = moduleName;
        }

        public ImmutableSet<TurbineModifier> mods() {
            return this.mods;
        }

        public String moduleName() {
            return this.moduleName;
        }

        @Override
        public ModDirective.DirectiveKind directiveKind() {
            return ModDirective.DirectiveKind.REQUIRES;
        }
    }

    public static abstract class ModDirective
    extends Tree {
        public abstract DirectiveKind directiveKind();

        protected ModDirective(int position) {
            super(position);
        }

        public static enum DirectiveKind {
            REQUIRES,
            EXPORTS,
            OPENS,
            USES,
            PROVIDES;

        }
    }

    public static class ModDecl
    extends Tree {
        private final ImmutableList<Anno> annos;
        private final boolean open;
        private final String moduleName;
        private final ImmutableList<ModDirective> directives;

        public ModDecl(int position, ImmutableList<Anno> annos, boolean open, String moduleName, ImmutableList<ModDirective> directives) {
            super(position);
            this.annos = annos;
            this.open = open;
            this.moduleName = moduleName;
            this.directives = directives;
        }

        public boolean open() {
            return this.open;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }

        public String moduleName() {
            return this.moduleName;
        }

        public ImmutableList<ModDirective> directives() {
            return this.directives;
        }

        @Override
        public Kind kind() {
            return Kind.MOD_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitModDecl(this, input);
        }
    }

    public static class PkgDecl
    extends Tree {
        private final ImmutableList<Ident> name;
        private final ImmutableList<Anno> annos;

        public PkgDecl(int position, ImmutableList<Ident> name, ImmutableList<Anno> annos) {
            super(position);
            this.name = name;
            this.annos = annos;
        }

        @Override
        public Kind kind() {
            return Kind.PKG_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitPkgDecl(this, input);
        }

        public ImmutableList<Ident> name() {
            return this.name;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }
    }

    public static class TyParam
    extends Tree {
        private final Ident name;
        private final ImmutableList<Tree> bounds;
        private final ImmutableList<Anno> annos;

        public TyParam(int position, Ident name, ImmutableList<Tree> bounds, ImmutableList<Anno> annos) {
            super(position);
            this.name = name;
            this.bounds = bounds;
            this.annos = annos;
        }

        @Override
        public Kind kind() {
            return Kind.TY_PARAM;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitTyParam(this, input);
        }

        public Ident name() {
            return this.name;
        }

        public ImmutableList<Tree> bounds() {
            return this.bounds;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }
    }

    public static class TyDecl
    extends Tree {
        private final ImmutableSet<TurbineModifier> mods;
        private final ImmutableList<Anno> annos;
        private final Ident name;
        private final ImmutableList<TyParam> typarams;
        private final Optional<ClassTy> xtnds;
        private final ImmutableList<ClassTy> impls;
        private final ImmutableList<ClassTy> permits;
        private final ImmutableList<Tree> members;
        private final ImmutableList<VarDecl> components;
        private final TurbineTyKind tykind;
        private final @Nullable String javadoc;

        public TyDecl(int position, Set<TurbineModifier> mods, ImmutableList<Anno> annos, Ident name, ImmutableList<TyParam> typarams, Optional<ClassTy> xtnds, ImmutableList<ClassTy> impls, ImmutableList<ClassTy> permits, ImmutableList<Tree> members, ImmutableList<VarDecl> components, TurbineTyKind tykind, @Nullable String javadoc) {
            super(position);
            this.mods = ImmutableSet.copyOf(mods);
            this.annos = annos;
            this.name = name;
            this.typarams = typarams;
            this.xtnds = xtnds;
            this.impls = impls;
            this.permits = permits;
            this.members = members;
            this.components = components;
            this.tykind = tykind;
            this.javadoc = javadoc;
        }

        @Override
        public Kind kind() {
            return Kind.TY_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitTyDecl(this, input);
        }

        public ImmutableSet<TurbineModifier> mods() {
            return this.mods;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }

        public Ident name() {
            return this.name;
        }

        public ImmutableList<TyParam> typarams() {
            return this.typarams;
        }

        public Optional<ClassTy> xtnds() {
            return this.xtnds;
        }

        public ImmutableList<ClassTy> impls() {
            return this.impls;
        }

        public ImmutableList<ClassTy> permits() {
            return this.permits;
        }

        public ImmutableList<Tree> members() {
            return this.members;
        }

        public ImmutableList<VarDecl> components() {
            return this.components;
        }

        public TurbineTyKind tykind() {
            return this.tykind;
        }

        public @Nullable String javadoc() {
            return this.javadoc;
        }
    }

    public static class AnnoExpr
    extends Expression {
        private final Anno value;

        public AnnoExpr(int position, Anno value) {
            super(position);
            this.value = value;
        }

        public Anno value() {
            return this.value;
        }

        @Override
        public Kind kind() {
            return Kind.ANNO_EXPR;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitAnno(this.value, input);
        }
    }

    public static class Anno
    extends Tree {
        private final ImmutableList<Ident> name;
        private final ImmutableList<Expression> args;

        public Anno(int position, ImmutableList<Ident> name, ImmutableList<Expression> args) {
            super(position);
            this.name = name;
            this.args = args;
        }

        @Override
        public Kind kind() {
            return Kind.ANNO;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitAnno(this, input);
        }

        public ImmutableList<Ident> name() {
            return this.name;
        }

        public ImmutableList<Expression> args() {
            return this.args;
        }
    }

    public static class MethDecl
    extends Tree {
        private final ImmutableSet<TurbineModifier> mods;
        private final ImmutableList<Anno> annos;
        private final ImmutableList<TyParam> typarams;
        private final Optional<Tree> ret;
        private final Ident name;
        private final ImmutableList<VarDecl> params;
        private final ImmutableList<ClassTy> exntys;
        private final Optional<Tree> defaultValue;
        private final String javadoc;

        public MethDecl(int position, Set<TurbineModifier> mods, ImmutableList<Anno> annos, ImmutableList<TyParam> typarams, Optional<Tree> ret, Ident name, ImmutableList<VarDecl> params, ImmutableList<ClassTy> exntys, Optional<Tree> defaultValue, String javadoc) {
            super(position);
            this.mods = ImmutableSet.copyOf(mods);
            this.annos = annos;
            this.typarams = typarams;
            this.ret = ret;
            this.name = name;
            this.params = params;
            this.exntys = exntys;
            this.defaultValue = defaultValue;
            this.javadoc = javadoc;
        }

        @Override
        public Kind kind() {
            return Kind.METH_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitMethDecl(this, input);
        }

        public ImmutableSet<TurbineModifier> mods() {
            return this.mods;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }

        public ImmutableList<TyParam> typarams() {
            return this.typarams;
        }

        public Optional<Tree> ret() {
            return this.ret;
        }

        public Ident name() {
            return this.name;
        }

        public ImmutableList<VarDecl> params() {
            return this.params;
        }

        public ImmutableList<ClassTy> exntys() {
            return this.exntys;
        }

        public Optional<Tree> defaultValue() {
            return this.defaultValue;
        }

        public String javadoc() {
            return this.javadoc;
        }
    }

    public static class VarDecl
    extends Tree {
        private final ImmutableSet<TurbineModifier> mods;
        private final ImmutableList<Anno> annos;
        private final Tree ty;
        private final Ident name;
        private final Optional<Expression> init;
        private final @Nullable String javadoc;

        public VarDecl(int position, Set<TurbineModifier> mods, ImmutableList<Anno> annos, Tree ty, Ident name, Optional<Expression> init, @Nullable String javadoc) {
            super(position);
            this.mods = ImmutableSet.copyOf(mods);
            this.annos = annos;
            this.ty = ty;
            this.name = name;
            this.init = init;
            this.javadoc = javadoc;
        }

        @Override
        public Kind kind() {
            return Kind.VAR_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitVarDecl(this, input);
        }

        public ImmutableSet<TurbineModifier> mods() {
            return this.mods;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }

        public Tree ty() {
            return this.ty;
        }

        public Ident name() {
            return this.name;
        }

        public Optional<Expression> init() {
            return this.init;
        }

        public @Nullable String javadoc() {
            return this.javadoc;
        }
    }

    public static class ImportDecl
    extends Tree {
        private final ImmutableList<Ident> type;
        private final boolean stat;
        private final boolean wild;

        public ImportDecl(int position, ImmutableList<Ident> type, boolean stat, boolean wild) {
            super(position);
            this.type = type;
            this.stat = stat;
            this.wild = wild;
        }

        @Override
        public Kind kind() {
            return Kind.IMPORT_DECL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitImportDecl(this, input);
        }

        public ImmutableList<Ident> type() {
            return this.type;
        }

        public boolean stat() {
            return this.stat;
        }

        public boolean wild() {
            return this.wild;
        }
    }

    public static class CompUnit
    extends Tree {
        private final Optional<PkgDecl> pkg;
        private final Optional<ModDecl> mod;
        private final ImmutableList<ImportDecl> imports;
        private final ImmutableList<TyDecl> decls;
        private final SourceFile source;

        public CompUnit(int position, Optional<PkgDecl> pkg, Optional<ModDecl> mod, ImmutableList<ImportDecl> imports, ImmutableList<TyDecl> decls, SourceFile source) {
            super(position);
            this.pkg = pkg;
            this.mod = mod;
            this.imports = imports;
            this.decls = decls;
            this.source = source;
        }

        @Override
        public Kind kind() {
            return Kind.COMP_UNIT;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitCompUnit(this, input);
        }

        public Optional<PkgDecl> pkg() {
            return this.pkg;
        }

        public Optional<ModDecl> mod() {
            return this.mod;
        }

        public ImmutableList<ImportDecl> imports() {
            return this.imports;
        }

        public ImmutableList<TyDecl> decls() {
            return this.decls;
        }

        public SourceFile source() {
            return this.source;
        }
    }

    public static class ArrayInit
    extends Expression {
        private final ImmutableList<Expression> exprs;

        public ArrayInit(int position, ImmutableList<Expression> exprs) {
            super(position);
            this.exprs = exprs;
        }

        @Override
        public Kind kind() {
            return Kind.ARRAY_INIT;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitArrayInit(this, input);
        }

        public ImmutableList<Expression> exprs() {
            return this.exprs;
        }
    }

    public static class Conditional
    extends Expression {
        private final Expression cond;
        private final Expression iftrue;
        private final Expression iffalse;

        public Conditional(int position, Expression cond, Expression iftrue, Expression iffalse) {
            super(position);
            this.cond = cond;
            this.iftrue = iftrue;
            this.iffalse = iffalse;
        }

        @Override
        public Kind kind() {
            return Kind.CONDITIONAL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitConditional(this, input);
        }

        public Expression cond() {
            return this.cond;
        }

        public Expression iftrue() {
            return this.iftrue;
        }

        public Expression iffalse() {
            return this.iffalse;
        }
    }

    public static class Assign
    extends Expression {
        private final Ident name;
        private final Expression expr;

        public Assign(int position, Ident name, Expression expr) {
            super(position);
            this.name = Objects.requireNonNull(name);
            this.expr = Objects.requireNonNull(expr);
        }

        @Override
        public Kind kind() {
            return Kind.ASSIGN;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitAssign(this, input);
        }

        public Ident name() {
            return this.name;
        }

        public Expression expr() {
            return this.expr;
        }
    }

    public static class ClassLiteral
    extends Expression {
        private final Type type;

        public ClassLiteral(int position, Type type) {
            super(position);
            this.type = type;
        }

        @Override
        public Kind kind() {
            return Kind.CLASS_LITERAL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitClassLiteral(this, input);
        }

        public Type type() {
            return this.type;
        }
    }

    public static class ConstVarName
    extends Expression {
        private final ImmutableList<Ident> name;

        public ConstVarName(int position, ImmutableList<Ident> name) {
            super(position);
            this.name = name;
        }

        @Override
        public Kind kind() {
            return Kind.CONST_VAR_NAME;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitConstVarName(this, input);
        }

        public ImmutableList<Ident> name() {
            return this.name;
        }
    }

    public static class Binary
    extends Expression {
        private final Expression lhs;
        private final Expression rhs;
        private final TurbineOperatorKind op;

        public Binary(int position, Expression lhs, Expression rhs, TurbineOperatorKind op) {
            super(position);
            this.lhs = lhs;
            this.rhs = rhs;
            this.op = op;
        }

        @Override
        public Kind kind() {
            return Kind.BINARY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitBinary(this, input);
        }

        public Iterable<Expression> children() {
            ImmutableList.Builder children = ImmutableList.builder();
            ArrayDeque<Expression> stack = new ArrayDeque<Expression>();
            stack.addFirst(this.rhs);
            stack.addFirst(this.lhs);
            while (!stack.isEmpty()) {
                Binary b;
                Expression curr = (Expression)stack.removeFirst();
                if (curr.kind().equals((Object)Kind.BINARY) && (b = (Binary)curr).op().equals((Object)this.op())) {
                    stack.addFirst(b.rhs);
                    stack.addFirst(b.lhs);
                    continue;
                }
                children.add(curr);
            }
            return children.build();
        }

        public TurbineOperatorKind op() {
            return this.op;
        }
    }

    public static class Unary
    extends Expression {
        private final Expression expr;
        private final TurbineOperatorKind op;

        public Unary(int position, Expression expr, TurbineOperatorKind op) {
            super(position);
            this.expr = expr;
            this.op = op;
        }

        @Override
        public Kind kind() {
            return Kind.UNARY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitUnary(this, input);
        }

        public Expression expr() {
            return this.expr;
        }

        public TurbineOperatorKind op() {
            return this.op;
        }
    }

    public static class TypeCast
    extends Expression {
        private final Type ty;
        private final Expression expr;

        public TypeCast(int position, Type ty, Expression expr) {
            super(position);
            this.ty = ty;
            this.expr = expr;
        }

        @Override
        public Kind kind() {
            return Kind.TYPE_CAST;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitTypeCast(this, input);
        }

        public Type ty() {
            return this.ty;
        }

        public Expression expr() {
            return this.expr;
        }
    }

    public static class Paren
    extends Expression {
        private final Expression expr;

        public Paren(int position, Expression expr) {
            super(position);
            this.expr = expr;
        }

        @Override
        public Kind kind() {
            return Kind.PAREN;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitParen(this, input);
        }

        public Expression expr() {
            return this.expr;
        }
    }

    public static class Literal
    extends Expression {
        private final TurbineConstantTypeKind tykind;
        private final Const value;

        public Literal(int position, TurbineConstantTypeKind tykind, Const value) {
            super(position);
            this.tykind = tykind;
            this.value = value;
        }

        @Override
        public Kind kind() {
            return Kind.LITERAL;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitLiteral(this, input);
        }

        public TurbineConstantTypeKind tykind() {
            return this.tykind;
        }

        public Const value() {
            return this.value;
        }
    }

    public static class ClassTy
    extends Type {
        private final Optional<ClassTy> base;
        private final Ident name;
        private final ImmutableList<Type> tyargs;

        public ClassTy(int position, Optional<ClassTy> base, Ident name, ImmutableList<Type> tyargs, ImmutableList<Anno> annos) {
            super(position, annos);
            this.base = base;
            this.name = name;
            this.tyargs = tyargs;
        }

        @Override
        public Kind kind() {
            return Kind.CLASS_TY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitClassTy(this, input);
        }

        public Optional<ClassTy> base() {
            return this.base;
        }

        public Ident name() {
            return this.name;
        }

        public ImmutableList<Type> tyargs() {
            return this.tyargs;
        }
    }

    public static class VoidTy
    extends Type {
        @Override
        public Kind kind() {
            return Kind.VOID_TY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitVoidTy(this, input);
        }

        public VoidTy(int position) {
            super(position, ImmutableList.of());
        }
    }

    public static class PrimTy
    extends Type {
        private final TurbineConstantTypeKind tykind;

        public PrimTy(int position, ImmutableList<Anno> annos, TurbineConstantTypeKind tykind) {
            super(position, annos);
            this.tykind = tykind;
        }

        @Override
        public Kind kind() {
            return Kind.PRIM_TY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitPrimTy(this, input);
        }

        public TurbineConstantTypeKind tykind() {
            return this.tykind;
        }
    }

    public static class ArrTy
    extends Type {
        private final Type elem;

        public ArrTy(int position, ImmutableList<Anno> annos, Type elem) {
            super(position, annos);
            this.elem = elem;
        }

        @Override
        public Kind kind() {
            return Kind.ARR_TY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitArrTy(this, input);
        }

        public Type elem() {
            return this.elem;
        }
    }

    public static class WildTy
    extends Type {
        private final Optional<Type> upper;
        private final Optional<Type> lower;

        public WildTy(int position, ImmutableList<Anno> annos, Optional<Type> upper, Optional<Type> lower) {
            super(position, annos);
            this.upper = upper;
            this.lower = lower;
        }

        @Override
        public Kind kind() {
            return Kind.WILD_TY;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitWildTy(this, input);
        }

        public Optional<Type> upper() {
            return this.upper;
        }

        public Optional<Type> lower() {
            return this.lower;
        }
    }

    public static abstract class Expression
    extends Tree {
        public Expression(int position) {
            super(position);
        }
    }

    public static abstract class Type
    extends Tree {
        private final ImmutableList<Anno> annos;

        public Type(int position, ImmutableList<Anno> annos) {
            super(position);
            this.annos = annos;
        }

        public ImmutableList<Anno> annos() {
            return this.annos;
        }
    }

    @Immutable
    public static class Ident
    extends Tree {
        private final String value;

        public Ident(int position, String value) {
            super(position);
            this.value = value;
        }

        @Override
        public Kind kind() {
            return Kind.IDENT;
        }

        @Override
        public <I, O> O accept(Visitor<I, O> visitor, I input) {
            return visitor.visitIdent(this, input);
        }

        public String value() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static enum Kind {
        IDENT,
        WILD_TY,
        ARR_TY,
        PRIM_TY,
        VOID_TY,
        CLASS_TY,
        LITERAL,
        PAREN,
        TYPE_CAST,
        UNARY,
        BINARY,
        CONST_VAR_NAME,
        CLASS_LITERAL,
        ASSIGN,
        CONDITIONAL,
        ARRAY_INIT,
        COMP_UNIT,
        IMPORT_DECL,
        VAR_DECL,
        METH_DECL,
        ANNO,
        ANNO_EXPR,
        TY_DECL,
        TY_PARAM,
        PKG_DECL,
        MOD_DECL,
        MOD_REQUIRES,
        MOD_EXPORTS,
        MOD_OPENS,
        MOD_USES,
        MOD_PROVIDES;

    }
}

